/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.AssGrpDefaultVal;
import kd.bos.ext.fi.util.PeriodUtil;
import kd.bos.util.StringUtils;
import kd.fi.gl.accountref.constant.AbstractBalData;
import kd.fi.gl.accountref.constant.AcctSumBalContext;
import kd.fi.gl.accountref.constant.BalData;
import kd.fi.gl.accountref.constant.SingleAccountRefContext;
import kd.fi.gl.accountref.handler.AbstractBalDataHandler;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.reciprocal.FlexSaveService;

public class BalDataTransHandler
extends AbstractBalDataHandler {
    @Override
    public void handle(SingleAccountRefContext context) {
        AccountTableRef accountTableRef = context.getAcctTblRef();
        Collection<AbstractBalData> oldBalDatas = context.getOldBalDatas();
        HashMap<String, BalData> newBalDatas = new HashMap<String, BalData>(1024);
        HashMap<String, BalData> newSumBalDatas = new HashMap<String, BalData>(1024);
        ArrayList<FlexEntireData> flexEntireDatas = new ArrayList<FlexEntireData>(1024);
        for (AbstractBalData oldData : oldBalDatas) {
            BalData oldBalData = (BalData)oldData;
            this.collectAssvals(context, accountTableRef, oldBalData, flexEntireDatas);
            this.sumBal(context, newBalDatas, accountTableRef, oldBalData);
            this.sumAcctBal(context, newSumBalDatas, accountTableRef, oldBalData);
        }
        this.createAndCacheNewAssgrpIds(context, flexEntireDatas);
        this.addUpdateOrInsertBalDatas(context, newBalDatas.values());
        this.updateAcctSumContext(context, newSumBalDatas.values());
    }

    private void createAndCacheNewAssgrpIds(SingleAccountRefContext context, List<FlexEntireData> flexEntireDatas) {
        MainEntityType mainEntity = new MainEntityType();
        mainEntity.setAlias("T_GL_ASSIST");
        mainEntity.setDBRouteKey("gl");
        Map<String, Long> valAndAssgrpIdMap = FlexSaveService.batchSaveFlexData(mainEntity, flexEntireDatas);
        for (Map.Entry<String, Long> entry : valAndAssgrpIdMap.entrySet()) {
            context.getAssistCache().cacheAssvalAndAssgrp(entry.getKey(), entry.getValue());
        }
    }

    private void collectAssvals(SingleAccountRefContext context, AccountTableRef accountTableRef, BalData oldBalData, List<FlexEntireData> flexEntireDatas) {
        FlexEntireData flexEntireData = new FlexEntireData();
        Long oldAccountId = oldBalData.getAcctPKId();
        AssGrpDefaultVal newAssgrpVals = accountTableRef.getNewDefaultAssgrp(oldAccountId);
        Long newAccountId = accountTableRef.getNewAccountId(oldAccountId);
        Set<String> newFlexFields = context.getAccountCache().getNewAccountDetails(newAccountId).getFlexFields();
        Long oldAssgrpId = oldBalData.getAssgrpId();
        ArrayList<FlexEntireData.FlexData> flexDatas = new ArrayList<FlexEntireData.FlexData>(32);
        if (oldAssgrpId.equals(0L)) {
            this.buildAssvalWithZeorAssgrp(flexEntireData, newAssgrpVals, newFlexFields, flexDatas);
        } else {
            Map<String, Object> oldAssgrpVals = context.getAssistCache().getOldAssvalFromCache(oldAssgrpId);
            if (oldAssgrpVals != null) {
                boolean isAllMatch = true;
                if (newFlexFields.size() == oldAssgrpVals.size()) {
                    for (String newFlexField : newFlexFields) {
                        if (oldAssgrpVals.containsKey(newFlexField)) continue;
                        isAllMatch = false;
                        break;
                    }
                } else {
                    isAllMatch = false;
                }
                if (isAllMatch) {
                    oldBalData.setAssgrpMatch(true);
                    return;
                }
                this.buildAssvalWithNoZeorAssgrp(context, flexEntireData, newAssgrpVals, newFlexFields, oldAssgrpId, flexDatas, oldAssgrpVals);
            }
        }
        if (!flexDatas.isEmpty()) {
            flexEntireData.setFlexDatas(flexDatas);
            String newAssval = flexEntireData.concatFlexData();
            oldBalData.setAssval(newAssval);
            if (!context.getAssistCache().existsNewAssgrpCache(newAssval)) {
                flexEntireDatas.add(flexEntireData);
            }
        } else {
            oldBalData.setAssval(null);
        }
    }

    private void buildAssvalWithZeorAssgrp(FlexEntireData flexEntireData, AssGrpDefaultVal newAssgrpVals, Set<String> newFlexFields, List<FlexEntireData.FlexData> flexDatas) {
        for (String flexField : newFlexFields) {
            FlexEntireData.FlexData flexData = null;
            Object defaultAssval = newAssgrpVals.getDefaultAssgrpId(flexField);
            if (defaultAssval != null) {
                flexData = this.buildFlexData(flexField, defaultAssval, flexEntireData);
            }
            if (flexData == null) continue;
            flexDatas.add(flexData);
        }
    }

    private void buildAssvalWithNoZeorAssgrp(SingleAccountRefContext context, FlexEntireData flexEntireData, AssGrpDefaultVal newAssgrpVals, Set<String> newFlexFields, Long oldAssgrpId, List<FlexEntireData.FlexData> flexDatas, Map<String, Object> oldAssgrpVals) {
        for (String flexField : newFlexFields) {
            FlexEntireData.FlexData flexData = null;
            Object assval = oldAssgrpVals.get(flexField);
            if (assval != null) {
                flexData = this.buildFlexData(flexField, assval, flexEntireData);
            } else {
                Object defaultAssval = newAssgrpVals.getDefaultAssgrpId(flexField);
                if (defaultAssval != null) {
                    flexData = this.buildFlexData(flexField, defaultAssval, flexEntireData);
                }
            }
            if (flexData == null) continue;
            flexDatas.add(flexData);
        }
    }

    private FlexEntireData.FlexData buildFlexData(String flexField, Object assval, FlexEntireData flexEntireData) {
        FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData);
        if (assval instanceof String) {
            flexData.setDbType(FlexEntireData.FlexFieldDataType.STRING);
        } else {
            flexData.setDbType(FlexEntireData.FlexFieldDataType.LONG);
        }
        flexData.setPropId(flexField);
        flexData.setValue(assval);
        return flexData;
    }

    private void sumBal(SingleAccountRefContext context, Map<String, BalData> newBalDatas, AccountTableRef accountTableRef, BalData oldBalData) {
        String newAssval;
        Long oldAccountId = oldBalData.getAcctPKId();
        Long newAccountId = accountTableRef.getNewAccountId(oldAccountId);
        Long measureUnitId = oldBalData.getMeasureUnitId();
        Long currencyId = oldBalData.getCurrencyId();
        String balKey = BalanceTransferUtils.getAccountBalanceKey(newAccountId, currencyId, newAssval = oldBalData.getAssval(), measureUnitId);
        BalData balData = newBalDatas.get(balKey);
        if (balData == null) {
            balData = this.buildNewBalData(context, oldBalData, newAccountId);
            newBalDatas.put(balKey, balData);
        } else {
            balData.setBeginFor(balData.getBeginFor().add(oldBalData.getEndFor()));
            balData.setBeginLocal(balData.getBeginLocal().add(oldBalData.getEndLocal()));
            balData.setBeginQty(balData.getBeginQty().add(oldBalData.getEndQty()));
            balData.setYearDebitFor(balData.getYearDebitFor().add(oldBalData.getYearDebitFor()));
            balData.setYearDebitLocal(balData.getYearDebitLocal().add(oldBalData.getYearDebitLocal()));
            balData.setYearDebitQty(balData.getYearDebitQty().add(oldBalData.getYearDebitQty()));
            balData.setYearCreditFor(balData.getYearCreditFor().add(oldBalData.getYearCreditFor()));
            balData.setYearCreditLocal(balData.getYearCreditLocal().add(oldBalData.getYearCreditLocal()));
            balData.setYearCreditQty(balData.getYearCreditQty().add(oldBalData.getYearCreditQty()));
            balData.setEndFor(balData.getEndFor().add(oldBalData.getEndFor()));
            balData.setEndLocal(balData.getEndLocal().add(oldBalData.getEndLocal()));
            balData.setEndQty(balData.getEndQty().add(oldBalData.getEndQty()));
        }
    }

    private void sumAcctBal(SingleAccountRefContext context, Map<String, BalData> newBalDatas, AccountTableRef accountTableRef, BalData oldBalData) {
        Long oldAccountId = oldBalData.getAcctPKId();
        Long newAccountId = accountTableRef.getNewAccountId(oldAccountId);
        Long measureUnitId = oldBalData.getMeasureUnitId();
        Long currencyId = oldBalData.getCurrencyId();
        String balKey = BalanceTransferUtils.getAccountBalanceKey(newAccountId, currencyId, 0L, measureUnitId);
        BalData balData = newBalDatas.get(balKey);
        if (balData == null) {
            balData = this.buildNewBalData(context, oldBalData, newAccountId);
            newBalDatas.put(balKey, balData);
        } else {
            balData.setBeginFor(balData.getBeginFor().add(oldBalData.getEndFor()));
            balData.setBeginLocal(balData.getBeginLocal().add(oldBalData.getEndLocal()));
            balData.setBeginQty(balData.getBeginQty().add(oldBalData.getEndQty()));
            balData.setYearDebitFor(balData.getYearDebitFor().add(oldBalData.getYearDebitFor()));
            balData.setYearDebitLocal(balData.getYearDebitLocal().add(oldBalData.getYearDebitLocal()));
            balData.setYearDebitQty(balData.getYearDebitQty().add(oldBalData.getYearDebitQty()));
            balData.setYearCreditFor(balData.getYearCreditFor().add(oldBalData.getYearCreditFor()));
            balData.setYearCreditLocal(balData.getYearCreditLocal().add(oldBalData.getYearCreditLocal()));
            balData.setYearCreditQty(balData.getYearCreditQty().add(oldBalData.getYearCreditQty()));
            balData.setEndFor(balData.getEndFor().add(oldBalData.getEndFor()));
            balData.setEndLocal(balData.getEndLocal().add(oldBalData.getEndLocal()));
            balData.setEndQty(balData.getEndQty().add(oldBalData.getEndQty()));
        }
    }

    private BalData buildNewBalData(SingleAccountRefContext context, BalData oldBalData, Long newAccountId) {
        BalData balData = new BalData();
        balData.setAcctPKId(newAccountId);
        balData.setAcctMasterId(context.getAccountCache().getNewAccountDetails(newAccountId).getMasterId());
        if (oldBalData.isAssgrpMatch()) {
            balData.setAssgrpId(oldBalData.getAssgrpId());
            balData.setAssgrpMatch(true);
        } else {
            balData.setAssgrpId(0L);
        }
        balData.setAssval(oldBalData.getAssval());
        balData.setCurrencyId(oldBalData.getCurrencyId());
        balData.setMeasureUnitId(oldBalData.getMeasureUnitId());
        balData.setPeriodId(context.getPeriodId());
        balData.setEndPeriodId(PeriodUtil.MAX_PERIOD);
        balData.setPeriodYear(context.getPeriodYear());
        balData.setBeginFor(oldBalData.getEndFor());
        balData.setBeginLocal(oldBalData.getEndLocal());
        balData.setBeginQty(oldBalData.getEndQty());
        balData.setDebitFor(BigDecimal.ZERO);
        balData.setDebitLocal(BigDecimal.ZERO);
        balData.setDebitQty(BigDecimal.ZERO);
        balData.setCreditFor(BigDecimal.ZERO);
        balData.setCreditLocal(BigDecimal.ZERO);
        balData.setCreditQty(BigDecimal.ZERO);
        if (context.isCrossYear()) {
            balData.setYearDebitFor(BigDecimal.ZERO);
            balData.setYearDebitLocal(BigDecimal.ZERO);
            balData.setYearDebitQty(BigDecimal.ZERO);
            balData.setYearCreditFor(BigDecimal.ZERO);
            balData.setYearCreditLocal(BigDecimal.ZERO);
            balData.setYearCreditQty(BigDecimal.ZERO);
        } else {
            balData.setYearDebitFor(oldBalData.getYearDebitFor());
            balData.setYearDebitLocal(oldBalData.getYearDebitLocal());
            balData.setYearDebitQty(oldBalData.getYearDebitQty());
            balData.setYearCreditFor(oldBalData.getYearCreditFor());
            balData.setYearCreditLocal(oldBalData.getYearCreditLocal());
            balData.setYearCreditQty(oldBalData.getYearCreditQty());
        }
        balData.setEndFor(oldBalData.getEndFor());
        balData.setEndLocal(oldBalData.getEndLocal());
        balData.setEndQty(oldBalData.getEndQty());
        return balData;
    }

    private void addUpdateOrInsertBalDatas(SingleAccountRefContext context, Collection<BalData> newbalDatas) {
        for (BalData balData : newbalDatas) {
            AbstractBalData firstBalData;
            Long assgrpId;
            String newAssval = balData.getAssval();
            if (balData.isAssgrpMatch()) {
                assgrpId = balData.getAssgrpId();
            } else if (StringUtils.isEmpty((String)newAssval)) {
                assgrpId = 0L;
            } else {
                assgrpId = context.getAssistCache().getNewAssgrpId(newAssval);
                if (assgrpId == null) {
                    String error = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u7ec4\u5408%s\u627e\u4e0d\u5230\u5bf9\u5e94\u7684assgrpid\uff0c\u4f59\u989d\u751f\u6210\u5931\u8d25\u3002", (String)"BalDataTransHandler_0", (String)"fi-gl-common", (Object[])new Object[0]), newAssval);
                    throw new KDBizException(error);
                }
            }
            balData.setAssgrpId(assgrpId);
            String balKey = BalanceTransferUtils.getAccountBalanceKey(balData.getAcctMasterId(), balData.getCurrencyId(), assgrpId, balData.getMeasureUnitId());
            List<AbstractBalData> existBalDatas = context.getExistNewAcctBalDatas(balKey);
            if (existBalDatas == null) {
                if (this.isBalAndYearZero(balData)) continue;
                context.addInsertBalData(balData);
                continue;
            }
            if (!existBalDatas.isEmpty() && (firstBalData = existBalDatas.get(0)).getPeriodId().compareTo(context.getPeriodId()) > 0) {
                balData.setEndPeriodId(firstBalData.getPeriodId());
                context.addInsertBalData(balData);
            }
            List<AbstractBalData> updateBalDatas = this.updateExistsBalDatas(balData, existBalDatas);
            for (AbstractBalData updateBalData : updateBalDatas) {
                context.addUpdateBalData(updateBalData);
            }
            context.addExistsFutureBalKey(balKey);
        }
    }

    private void updateAcctSumContext(SingleAccountRefContext context, Collection<BalData> newbalDatas) {
        AcctSumBalContext accSumCtx = context.getAcctSumBalCtx();
        for (BalData balData : newbalDatas) {
            AbstractBalData firstBalData;
            String balKey = BalanceTransferUtils.getAccountBalanceKey(balData.getAcctMasterId(), balData.getCurrencyId(), 0L, balData.getMeasureUnitId());
            List<AbstractBalData> existBalDatas = accSumCtx.getExistNewAcctBalDatas().get(balKey);
            if (existBalDatas == null) {
                if (this.isBalAndYearZero(balData)) continue;
                accSumCtx.getInsertBalDatas().add(balData);
                continue;
            }
            if (!existBalDatas.isEmpty() && (firstBalData = existBalDatas.get(0)).getPeriodId().compareTo(context.getPeriodId()) > 0) {
                balData.setEndPeriodId(firstBalData.getPeriodId());
                accSumCtx.getInsertBalDatas().add(balData);
            }
            List<AbstractBalData> updateBalDatas = this.updateExistsBalDatas(balData, existBalDatas);
            for (AbstractBalData updateBalData : updateBalDatas) {
                accSumCtx.getUpdateBalDatas().add(updateBalData);
            }
            accSumCtx.getExistsFutureBalKeys().add(balKey);
        }
    }

    private boolean isBalAndYearZero(BalData balData) {
        return balData.getBeginFor().compareTo(BigDecimal.ZERO) == 0 && balData.getBeginLocal().compareTo(BigDecimal.ZERO) == 0 && balData.getBeginQty().compareTo(BigDecimal.ZERO) == 0 && balData.getYearCreditFor().compareTo(BigDecimal.ZERO) == 0 && balData.getYearCreditLocal().compareTo(BigDecimal.ZERO) == 0 && balData.getYearCreditQty().compareTo(BigDecimal.ZERO) == 0 && balData.getYearDebitFor().compareTo(BigDecimal.ZERO) == 0 && balData.getYearDebitLocal().compareTo(BigDecimal.ZERO) == 0 && balData.getYearDebitQty().compareTo(BigDecimal.ZERO) == 0;
    }

    private List<AbstractBalData> updateExistsBalDatas(BalData balData, List<AbstractBalData> updateBalDatas) {
        BigDecimal prePeriodEndAmtFor = BigDecimal.ZERO;
        BigDecimal prePeriodEndAmtLocal = BigDecimal.ZERO;
        BigDecimal prePeriodEndQty = BigDecimal.ZERO;
        BigDecimal prePeriodYearDebitAmtFor = BigDecimal.ZERO;
        BigDecimal prePeriodYearDebitAmtLocal = BigDecimal.ZERO;
        BigDecimal prePeriodYearDebitQty = BigDecimal.ZERO;
        BigDecimal prePeriodYearCreditAmtFor = BigDecimal.ZERO;
        BigDecimal prePeriodYearCreditAmtLocal = BigDecimal.ZERO;
        BigDecimal prePeriodYearCreditQty = BigDecimal.ZERO;
        for (int i = 0; i < updateBalDatas.size(); ++i) {
            BalData updateBalData = (BalData)updateBalDatas.get(i);
            if (i == 0) {
                updateBalData.setBeginFor(balData.getEndFor());
                updateBalData.setBeginLocal(balData.getEndLocal());
                updateBalData.setBeginQty(balData.getEndQty());
                if (updateBalData.getPeriodYear() == balData.getPeriodYear()) {
                    prePeriodYearDebitAmtFor = updateBalData.getDebitFor().add(balData.getYearDebitFor());
                    prePeriodYearDebitAmtLocal = updateBalData.getDebitLocal().add(balData.getYearDebitLocal());
                    prePeriodYearDebitQty = updateBalData.getDebitQty().add(balData.getYearDebitQty());
                    updateBalData.setYearDebitFor(prePeriodYearDebitAmtFor);
                    updateBalData.setYearDebitLocal(prePeriodYearDebitAmtLocal);
                    updateBalData.setYearDebitQty(prePeriodYearDebitQty);
                    prePeriodYearCreditAmtFor = updateBalData.getCreditFor().add(balData.getYearCreditFor());
                    prePeriodYearCreditAmtLocal = updateBalData.getCreditLocal().add(balData.getYearCreditLocal());
                    prePeriodYearCreditQty = updateBalData.getCreditQty().add(balData.getYearCreditQty());
                    updateBalData.setYearCreditFor(prePeriodYearCreditAmtFor);
                    updateBalData.setYearCreditLocal(prePeriodYearCreditAmtLocal);
                    updateBalData.setYearCreditQty(prePeriodYearCreditQty);
                }
            } else {
                updateBalData.setBeginFor(prePeriodEndAmtFor);
                updateBalData.setBeginLocal(prePeriodEndAmtLocal);
                updateBalData.setBeginQty(prePeriodEndQty);
                if (updateBalData.getPeriodYear() == balData.getPeriodYear()) {
                    prePeriodYearDebitAmtFor = prePeriodYearDebitAmtFor.add(updateBalData.getDebitFor());
                    prePeriodYearDebitAmtLocal = prePeriodYearDebitAmtLocal.add(balData.getDebitLocal());
                    prePeriodYearDebitQty = prePeriodYearDebitQty.add(balData.getDebitQty());
                    updateBalData.setYearDebitFor(prePeriodYearDebitAmtFor);
                    updateBalData.setYearDebitLocal(prePeriodYearDebitAmtLocal);
                    updateBalData.setYearDebitQty(prePeriodYearDebitQty);
                    prePeriodYearCreditAmtFor = prePeriodYearCreditAmtFor.add(balData.getCreditFor());
                    prePeriodYearCreditAmtLocal = prePeriodYearCreditAmtLocal.add(balData.getCreditLocal());
                    prePeriodYearCreditQty = prePeriodYearCreditQty.add(balData.getCreditQty());
                    updateBalData.setYearCreditFor(prePeriodYearCreditAmtFor);
                    updateBalData.setYearCreditLocal(prePeriodYearCreditAmtLocal);
                    updateBalData.setYearCreditQty(prePeriodYearCreditQty);
                }
            }
            prePeriodEndAmtFor = updateBalData.getBeginFor().add(updateBalData.getDebitFor()).subtract(updateBalData.getCreditFor());
            prePeriodEndAmtLocal = updateBalData.getBeginLocal().add(updateBalData.getDebitLocal()).subtract(updateBalData.getCreditLocal());
            prePeriodEndQty = updateBalData.getBeginQty().add(updateBalData.getDebitQty()).subtract(updateBalData.getCreditQty());
            updateBalData.setEndFor(prePeriodEndAmtFor);
            updateBalData.setEndLocal(prePeriodEndAmtLocal);
            updateBalData.setEndQty(prePeriodEndQty);
        }
        return updateBalDatas;
    }
}

