/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.handler.untrans;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accountref.constant.AcccurrentData;
import kd.fi.gl.accountref.constant.SingleAccountRefContext;
import kd.fi.gl.accountref.handler.AcccurrentDataHandler;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;

public class UntransAcccurrentDataHandler
extends AcccurrentDataHandler {
    @Override
    public void handle(SingleAccountRefContext context) {
        try (DataSet dSet = this.queryOldAcccurrentData(context);){
            for (Row row : dSet) {
                AcccurrentData acccurrentData = this.buildAcccurrentData(context, row, true);
                context.addOldBalData(acccurrentData);
            }
        }
        var3_3 = null;
        try (DataSet resultSet = this.queryNewAcccurrentData(context);){
            for (Row row : resultSet) {
                AcccurrentData balData = this.buildAcccurrentData(context, row, false);
                context.addExistNewAcctBalDatas(this.getBalKey(row), balData);
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    private DataSet queryOldAcccurrentData(SingleAccountRefContext context) {
        List<QFilter> filters = this.getOldAcccurrentFilter(context);
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)"id, period, account, assgrp, assgrp.value assval, bizdate, expiredate, biznum,currency,amountfor, amountbalfor,localcurrency, amount, amountbal, description, voucherid, voucherentry, status, sourcetype, masterid, entrydc, creator, writeoffperson, bookeddate", (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    private List<QFilter> getOldAcccurrentFilter(SingleAccountRefContext context) {
        Long prePeriodId = context.getPrePeriodId();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)context.getOrgId()));
        filters.add(new QFilter("booktype", "=", (Object)context.getBookTypeId()));
        filters.add(new QFilter("accounttable", "=", (Object)context.getAcctTblRef().getOldAccountTableId()));
        filters.add(new QFilter("period", "<=", (Object)prePeriodId));
        HashSet<Long> acctMasterIdSet = new HashSet<Long>(1024);
        try (DataSet acctSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".account"), (String)"bd_accountview", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", context.getOldAccountIds())}, null);){
            for (Row row : acctSet) {
                acctMasterIdSet.add(row.getLong("masterid"));
            }
        }
        filters.add(new QFilter("uneffectivedate", "=", (Object)context.getDate()));
        filters.add(new QFilter("account", "in", acctMasterIdSet));
        return filters;
    }

    private DataSet queryNewAcccurrentData(SingleAccountRefContext context) {
        List<QFilter> filters = this.getNewAcccurrentFilter(context);
        DataSet dSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)"id, period, account, assgrp, assgrp.value assval, bizdate, expiredate, biznum,currency,amountfor, amountbalfor,localcurrency, amount, amountbal, description, voucherid, voucherentry, status, sourcetype, masterid, entrydc, creator, writeoffperson, bookeddate", (QFilter[])filters.toArray(new QFilter[0]), null);
        return dSet.filter("id!=masterid");
    }

    private List<QFilter> getNewAcccurrentFilter(SingleAccountRefContext context) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)context.getOrgId()));
        filters.add(new QFilter("booktype", "=", (Object)context.getBookTypeId()));
        filters.add(new QFilter("accounttable", "=", (Object)context.getAcctTblRef().getNewAccountTableId()));
        AccountTableRef accountTableRef = context.getAcctTblRef();
        HashSet<Long> newAccountIds = new HashSet<Long>(1024);
        for (Long oldAccountId : context.getOldAccountIds()) {
            Long newAccountId = accountTableRef.getNewAccountId(oldAccountId);
            if (newAccountId == null) continue;
            newAccountIds.add(newAccountId);
        }
        HashSet<Long> acctMasterIdSet = new HashSet<Long>(1024);
        try (DataSet acctSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".account"), (String)"bd_accountview", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", newAccountIds)}, null);){
            for (Row row : acctSet) {
                acctMasterIdSet.add(row.getLong("masterid"));
            }
        }
        filters.add(new QFilter("uneffectivedate", "=", (Object)BalanceTransferUtils.getEndDate()));
        filters.add(new QFilter("account", "in", acctMasterIdSet));
        return filters;
    }
}

