/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.transferbal;

import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accountref.constant.SingleAccountRefContext;
import kd.fi.gl.accountref.handler.AbstractBalDataHandler;

public class FutureVoucherBalanceHandler
extends AbstractBalDataHandler {
    @Override
    public void handle(SingleAccountRefContext context) {
        Set<Long> oldAccountIdSet = this.getAccountMasterIds(context.getOldAccountIds());
        int i = 0;
        int sqlBatchSize = 2000;
        HashSet<Long> tmpIdSet = new HashSet<Long>(sqlBatchSize);
        int size = oldAccountIdSet.size();
        TreeSet<Long> periodIds = new TreeSet<Long>();
        for (Long oid : oldAccountIdSet) {
            tmpIdSet.add(oid);
            if (++i % sqlBatchSize != 0 && i != size) continue;
            StringJoiner oldStr = new StringJoiner(",");
            for (Long oldAcctId : tmpIdSet) {
                oldStr.add(oldAcctId.toString());
            }
            String accstr = oldStr.toString();
            this.dbExecute(context, periodIds, accstr);
            tmpIdSet.clear();
        }
        periodIds.add(context.getPeriodId());
        context.setFuturePeriodIds(periodIds);
    }

    private void dbExecute(SingleAccountRefContext context, Set<Long> periodIds, String accstr) {
        DB.query((DBRoute)DBRoute.of((String)"gl"), (String)("select distinct fperiodid from T_GL_BALANCE where forgid= ? and fbooktypeid=? and fperiodid >= ? and faccountid in (" + accstr + ") order by fperiodid asc "), (Object[])new Object[]{context.getOrgId(), context.getBookTypeId(), context.getPeriodId()}, r -> {
            while (r.next()) {
                periodIds.add(r.getLong("fperiodid"));
            }
            return null;
        });
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from T_GL_BALANCE where forgid= ? and fbooktypeid=? and fperiodid >= ? and faccountid in (" + accstr + ")  "), (Object[])new Object[]{context.getOrgId(), context.getBookTypeId(), context.getPeriodId()});
    }

    private Set<Long> getAccountMasterIds(Set<Long> accountIds) {
        HashSet<Long> acctMasterIdSet = new HashSet<Long>(1024);
        try (DataSet acctSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".account"), (String)"bd_accountview", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", accountIds)}, null);){
            for (Row row : acctSet) {
                acctMasterIdSet.add(row.getLong("masterid"));
            }
        }
        return acctMasterIdSet;
    }
}

