/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.assistitem;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.gl.assistitem.AssgrpMappingParam;
import kd.fi.gl.assistitem.IAccountingItemValueMapper;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.interfaces.service.cf.ICashFlowFlexService;

public class AccountItemValueMappingHelper {
    private static final Log extLogger = ExtLogFactory.getLog(AccountItemValueMappingHelper.class, (String)"[AccountItemValueMappingHelper]");

    private AccountItemValueMappingHelper() {
    }

    protected static ICashFlowFlexService getFlexService() {
        return GLServiceFactory.getService(ICashFlowFlexService.class);
    }

    public static Map<String, Object> getMappingValue(AssgrpMappingParam param) {
        extLogger.info("getMappingValue params = {}", (Object)param);
        HashSet<String> tempFlexs = new HashSet<String>(param.getTargetFlexs());
        HashMap<String, Object> targetFlexToValue = new HashMap<String, Object>(tempFlexs.size());
        List<IAccountingItemValueMapper> mappers = AccountItemValueMappingHelper.getFlexService().getMappers(param.getUseOrgId());
        for (IAccountingItemValueMapper mapper : mappers) {
            if (tempFlexs.isEmpty()) {
                return targetFlexToValue;
            }
            targetFlexToValue.putAll(mapper.mapping(new AssgrpMappingParam(param.getOriginalFlexToValue(), tempFlexs, param.getUseOrgId())));
            tempFlexs.removeAll(targetFlexToValue.keySet());
        }
        extLogger.info("getMappingValue result = {}", targetFlexToValue);
        return targetFlexToValue;
    }
}

