/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.balcal.CashflowData;
import kd.fi.gl.balcal.CashflowKey;
import kd.fi.gl.balcal.CashflowSumLog;
import kd.fi.gl.balcal.CashflowSumLogKey;
import kd.fi.gl.balcal.Log;
import kd.fi.gl.balcal.LogList;
import kd.fi.gl.balcal.Params;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.enums.CashStatusType;
import kd.fi.gl.util.GLUtil;

public class CashflowSumCalculator {
    private static final String UPD_SUM_BAL_AMT_SQL = "UPDATE t_gl_cashflowsum set famount = famount + ? where fid = ?";
    private static final String COVER_SUM_BAL_AMT_SQL = "UPDATE t_gl_cashflowsum set famount = ? where fid = ?";
    private static final String INSERT_SUM_BAL_SQL = "INSERT INTO t_gl_cashflowsum(fid,forgid,fbooktypeid,fperiodid,faccountid,fcfitemid,fmaincfassgrpid,ftype,fdc,famount) VALUES (?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_SUM_ENTRY_BAL_SQL = "INSERT INTO t_gl_cashflowsumentry(fid,fseq,fvoucherid,fvchentryid,fbookeddate,feamount,fentryid) values (?,?,?,?,?,?,?)";
    private static final String DEL_SUM_ENTRY_BAL_SQL = "DELETE FROM t_gl_cashflowsumentry WHERE fid ";
    private static final String[] SUM_LOG_KEY = new String[]{"faccountid", "fcfitemid", "fmaincfassgrpid", "ftype", "fdc"};
    private static final String VOUCHER_SELECT = "id,org,booktype,bookeddate,period,localcur,mainstatus,suppstatus,entries.account account,entries.account.iscash,entries.account.isbank,entries.account.iscashequivalent,entries.account.accounttype,entries.account.accounttype.accounttype,entries.account.masterid masterid,entries.account.accounttable accounttable,entries.assgrp assgrp,entries.measureunit measureunit,entries.currency currency,entries.id,entries.entrydc dc,entries.quantity quantity,entries.debitori debitori,entries.debitlocal debitlocal,entries.creditori creditori, entries.creditlocal creditlocal,entries.maincfitem maincfitem,entries.maincfitem.masterid mcfmasterid,entries.maincfassgrp maincfassgrp,entries.maincfamount maincfamount,entries.suppcfitem suppcfitem,entries.suppcfitem.masterid scfmasterid,entries.suppcfamount suppcfamount, sourcetype";
    private static final String VCH_CASH_PROFITITEM = "vch_cash_profititem";
    private boolean hasCashOrPLAcct = false;
    private List<Tuple<CashflowSumLogKey, CashflowSumLog>> cashDebitInfo = new ArrayList<Tuple<CashflowSumLogKey, CashflowSumLog>>();
    private List<Tuple<CashflowSumLogKey, CashflowSumLog>> cashCreditInfo = new ArrayList<Tuple<CashflowSumLogKey, CashflowSumLog>>();
    private BigDecimal cashDebitTotalAmt = BigDecimal.ZERO;
    private BigDecimal cashCreditTotalAmt = BigDecimal.ZERO;
    LogList<CashflowKey> tempLogList = new LogList();
    private Map<Long, DynamicObject> cfItemMapCache;
    private long voucherId = -1L;
    protected static final DBRoute gl = DBRoute.of((String)"gl");
    private static final int MAX_RECORD_NUM = 500;

    public int reCalculate(long orgId, long bookTypeId, long periodId) {
        DataSet dataSet = this.getVouSet(orgId, bookTypeId, periodId);
        return this.updateBalance(orgId, bookTypeId, dataSet, periodId);
    }

    protected Integer updateBalance(long orgId, long bookTypeId, DataSet ds, long periodId) {
        LogList<CashflowKey> logSumList = new LogList<CashflowKey>();
        long period = 0L;
        int index = 0;
        long vId = -1L;
        HashSet<Long> removeBalIds = new HashSet<Long>(16);
        for (Row rs : ds) {
            long pd = rs.getLong("period");
            this.addCashflowLog(logSumList, rs);
            if (!logSumList.isEmpty() && (period != pd || this.voucherId != vId && logSumList.size() >= 500)) {
                this.updateBalance(orgId, bookTypeId, period, logSumList, removeBalIds);
            }
            period = pd;
            vId = rs.getLong("id");
            ++index;
        }
        this.handleLogList(logSumList, this);
        if (!logSumList.isEmpty()) {
            this.updateBalance(orgId, bookTypeId, period, logSumList, removeBalIds);
        }
        return index;
    }

    protected void updateBalance(long orgId, long bookTypeId, long periodId, LogList<CashflowKey> logList, Set<Long> removeBalIds) {
        Map<CashflowSumLogKey, CashflowData> data = this.getCashSumData(orgId, bookTypeId, periodId, logList);
        Params detailarams = new Params();
        this.buildDetailParams(orgId, bookTypeId, periodId, logList, detailarams, data, removeBalIds);
        this.storeDB(detailarams, logList);
    }

    private void buildDetailParams(long orgId, long bookTypeId, long periodId, LogList<CashflowKey> logList, Params params, Map<CashflowSumLogKey, CashflowData> data, Set<Long> removeBalIds) {
        for (Map.Entry<CashflowKey, Log> logEntry : logList.getData().entrySet()) {
            Map<Long, List<Object[]>> addVouchers;
            CashflowSumLogKey key = (CashflowSumLogKey)logEntry.getKey();
            CashflowSumLog value = (CashflowSumLog)logEntry.getValue();
            CashflowData cashflowData = data.get(key);
            long fid = 0L;
            if (cashflowData != null) {
                fid = cashflowData.getId();
                if (removeBalIds.add(fid)) {
                    params.addCoverBalParams(new Object[]{value.getAmount(), fid});
                    params.addRemoveBalId(fid);
                } else {
                    params.addUpdateBalParam(new Object[]{value.getAmount(), fid});
                }
            } else {
                fid = DB.genLongId((String)"t_gl_cashflowsum");
                params.getNewBalParams().add(new Object[]{fid, orgId, bookTypeId, periodId, key.getAccountId(), key.getCfItemId(), key.getAssgrpId(), key.getType(), key.getDc(), value.getAmount()});
                removeBalIds.add(fid);
            }
            if ((addVouchers = value.getAddVoucherInfos()).isEmpty()) continue;
            for (Map.Entry<Long, List<Object[]>> entry : addVouchers.entrySet()) {
                Long vid = entry.getKey();
                List<Object[]> eInfos = entry.getValue();
                long[] entryIds = DB.genGlobalLongIds((int)eInfos.size());
                int i = 0;
                for (Object[] e : eInfos) {
                    params.getAddVchParams().add(new Object[]{fid, 0, vid, e[0], e[1], e[2], entryIds[i]});
                    ++i;
                }
            }
        }
    }

    protected void storeDB(Params param, LogList<CashflowKey> logList) {
        try (TXHandle h = TX.requiresNew((String)(this.getClass().getName() + "update"));){
            try {
                this.storeDetailBal(param);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
            finally {
                logList.clear();
            }
        }
    }

    private void storeDetailBal(Params param) {
        if (!param.getNewBalParams().isEmpty()) {
            DB.executeBatch((DBRoute)gl, (String)INSERT_SUM_BAL_SQL, param.getNewBalParams());
        }
        if (!param.getUpdateBalParams().isEmpty()) {
            DB.executeBatch((DBRoute)gl, (String)UPD_SUM_BAL_AMT_SQL, param.getUpdateBalParams());
        }
        if (!param.getCoverBalParams().isEmpty()) {
            DB.executeBatch((DBRoute)gl, (String)COVER_SUM_BAL_AMT_SQL, param.getCoverBalParams());
        }
        if (!param.getRemoveBalIds().isEmpty()) {
            SqlBuilder builder = new SqlBuilder();
            builder.appendIn(DEL_SUM_ENTRY_BAL_SQL, new ArrayList<Long>(param.getRemoveBalIds()));
            DB.execute((DBRoute)gl, (SqlBuilder)builder);
        }
        if (!param.getAddVchParams().isEmpty()) {
            DB.executeBatch((DBRoute)gl, (String)INSERT_SUM_ENTRY_BAL_SQL, param.getAddVchParams());
        }
    }

    private Map<CashflowSumLogKey, CashflowData> getCashSumData(long orgId, long bookTypeId, long periodId, LogList<CashflowKey> logList) {
        SqlBuilder builder = this.getSumlogSqlBuilder(orgId, bookTypeId, periodId, logList);
        return (Map)DB.query((DBRoute)gl, (SqlBuilder)builder, rs -> {
            HashMap<CashflowSumLogKey, CashflowData> data = new HashMap<CashflowSumLogKey, CashflowData>(16);
            while (rs.next()) {
                CashflowSumLogKey key = this.getSumLogPk(rs);
                data.put(key, this.getSumData(rs));
            }
            return data;
        });
    }

    private SqlBuilder getSumlogSqlBuilder(long orgId, long bookTypeId, long periodId, LogList<CashflowKey> logList) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fid,forgid,fbooktypeid,fperiodid,faccountid,fcfitemid,fmaincfassgrpid fassgrpid,ftype,fdc,famount, 1 fcount from t_gl_cashflowsum where ", new Object[0]);
        builder.append(" forgid = ?", new Object[]{orgId});
        builder.append(" and fbooktypeid = ?", new Object[]{bookTypeId});
        builder.append(" and fperiodid =?", new Object[]{periodId});
        String[] keys = this.getSumLogkeyField();
        Object[] param = new Object[5];
        for (int i = 0; i < keys.length; ++i) {
            param[i] = new HashSet();
        }
        for (CashflowKey logKey : logList.getData().keySet()) {
            int i = 0;
            for (Object val : ((CashflowSumLogKey)logKey).getKeyValue()) {
                ((Set)param[i]).add(val);
                ++i;
            }
        }
        for (int j = 0; j < keys.length; ++j) {
            builder.append(" and ", new Object[0]);
            builder.appendIn(keys[j], ((Set)param[j]).toArray());
        }
        return builder;
    }

    private String[] getSumLogkeyField() {
        return SUM_LOG_KEY;
    }

    public void addCashflowLog(LogList<CashflowKey> cashFlowLogList, Row row) {
        BigDecimal mainAmt;
        Long mainCFId;
        if (this.isBudgetAcct(row)) {
            return;
        }
        if (this.voucherId != -1L && this.voucherId != row.getLong("id")) {
            this.handleLogList(cashFlowLogList, this);
            this.resetVarData();
        }
        this.voucherId = row.getLong("id");
        Long entryid = row.getLong("entries.id");
        if (entryid == null || entryid == 0L) {
            return;
        }
        String mainstatus = row.getString("mainstatus");
        String suppstatus = row.getString("suppstatus");
        boolean iscash = GLUtil.isCashAcct(row);
        if (iscash) {
            this.addCashInfo(row);
        }
        boolean isPl = GLUtil.isPLAcct(row.getLong("entries.account.accounttype"));
        if ("3".equals(mainstatus)) {
            mainCFId = row.getLong("maincfitem");
            if (mainCFId > 0L) {
                mainAmt = row.getBigDecimal("maincfamount");
                this.addMaincfLog(row, mainAmt);
                this.dealSuppCashLog(row, mainCFId, mainAmt, iscash, isPl);
            }
        } else if ("2".equals(mainstatus) || "1".equals(mainstatus)) {
            mainCFId = row.getLong("maincfitem");
            if (mainCFId > 0L) {
                mainAmt = row.getBigDecimal("maincfamount");
                this.addMaincfLog(row, mainAmt);
                this.dealSuppCashLog(row, mainCFId, mainAmt, iscash, isPl);
            } else if (!iscash) {
                this.addMaincfLog(row, row.getBigDecimal("creditlocal").subtract(row.getBigDecimal("debitlocal")));
            }
        } else if (!iscash && "3".equals(suppstatus)) {
            Long suppCFId = row.getLong("suppcfitem");
            if (suppCFId > 0L) {
                this.addSuppLog(row, row.getBigDecimal("suppcfamount"));
            }
        } else if (!(iscash || "0".equals(suppstatus) || isPl)) {
            this.addSuppLog(row, row.getBigDecimal("creditlocal").subtract(row.getBigDecimal("debitlocal")));
        }
        boolean isProfitVch = "1".equals(row.getString("sourcetype"));
        if (!isProfitVch && isPl) {
            BigDecimal profitAmt = row.getBigDecimal("creditlocal").subtract(row.getBigDecimal("debitlocal"));
            this.addProfitCashflowLog(row, profitAmt);
        }
        if (iscash || isPl) {
            this.hasCashOrPLAcct = true;
        }
    }

    public void handleLogList(LogList<CashflowKey> cashFlowLogList, CashflowSumCalculator logCal) {
        if (!this.hasCashOrPLAcct) {
            return;
        }
        if (logCal.cashDebitTotalAmt.compareTo(BigDecimal.ZERO) != 0 && logCal.cashCreditTotalAmt.compareTo(BigDecimal.ZERO) != 0) {
            this.calCashAcctLog(logCal);
        } else if (logCal.cashCreditTotalAmt.compareTo(BigDecimal.ZERO) != 0) {
            this.tempLogList.getData().forEach((k, v) -> ((CashflowSumLogKey)k).setDc("-1"));
        } else {
            this.tempLogList.getData().forEach((k, v) -> ((CashflowSumLogKey)k).setDc("1"));
        }
        cashFlowLogList.add(this.tempLogList);
    }

    private void calCashAcctLog(CashflowSumCalculator logCal) {
        BigDecimal amt = logCal.cashDebitTotalAmt.subtract(logCal.cashCreditTotalAmt);
        if (amt.compareTo(BigDecimal.ZERO) > 0) {
            this.tempLogList.getData().forEach((k, v) -> ((CashflowSumLogKey)k).setDc("1"));
            BigDecimal difAmt = logCal.cashCreditTotalAmt;
            for (Tuple<CashflowSumLogKey, CashflowSumLog> tuple : logCal.cashDebitInfo) {
                CashflowSumLog item2 = (CashflowSumLog)tuple.item2;
                if (difAmt.compareTo(item2.getAmount()) > 0) {
                    this.addCashAcctLog((CashflowSumLogKey)tuple.item1, item2, item2.getAmount(), "-1");
                    difAmt = difAmt.subtract(item2.getAmount());
                    continue;
                }
                this.addCashAcctLog((CashflowSumLogKey)tuple.item1, item2, difAmt, "-1");
                break;
            }
            for (Tuple<CashflowSumLogKey, CashflowSumLog> tuple : logCal.cashCreditInfo) {
                this.addCashAcctLog((CashflowSumLogKey)tuple.item1, (CashflowSumLog)tuple.item2, ((CashflowSumLog)tuple.item2).getAmount(), "1");
            }
        } else {
            this.tempLogList.getData().forEach((k, v) -> ((CashflowSumLogKey)k).setDc("-1"));
            BigDecimal difAmt = logCal.cashDebitTotalAmt;
            for (Tuple<CashflowSumLogKey, CashflowSumLog> tuple : logCal.cashCreditInfo) {
                CashflowSumLog item2 = (CashflowSumLog)tuple.item2;
                if (difAmt.compareTo(item2.getAmount()) > 0) {
                    this.addCashAcctLog((CashflowSumLogKey)tuple.item1, item2, item2.getAmount(), "1");
                    difAmt = difAmt.subtract(item2.getAmount());
                    continue;
                }
                this.addCashAcctLog((CashflowSumLogKey)tuple.item1, item2, difAmt, "1");
                break;
            }
            for (Tuple<CashflowSumLogKey, CashflowSumLog> tuple : logCal.cashDebitInfo) {
                this.addCashAcctLog((CashflowSumLogKey)tuple.item1, (CashflowSumLog)tuple.item2, ((CashflowSumLog)tuple.item2).getAmount(), "-1");
            }
        }
    }

    private void addCashAcctLog(CashflowSumLogKey logKey, CashflowSumLog cashflowLog, BigDecimal amt, String dc) {
        cashflowLog.setAmount(amt);
        logKey.setDc(dc);
        this.tempLogList.add(logKey, cashflowLog);
    }

    private void addCashInfo(Row row) {
        BigDecimal debit = row.getBigDecimal("debitlocal");
        if (debit.compareTo(BigDecimal.ZERO) != 0) {
            this.cashDebitTotalAmt = this.cashDebitTotalAmt.add(debit);
            this.cashDebitInfo.add(new Tuple<CashflowSumLogKey, CashflowSumLog>(this.getSumLogPk(row, 0L, 0L, CashStatusType.CASHITEM.getValue()), this.getSumLogData(row, row.getBigDecimal("debitlocal"))));
        } else {
            BigDecimal credit = row.getBigDecimal("creditlocal");
            this.cashCreditTotalAmt = this.cashCreditTotalAmt.add(credit);
            this.cashCreditInfo.add(new Tuple<CashflowSumLogKey, CashflowSumLog>(this.getSumLogPk(row, 0L, 0L, CashStatusType.CASHITEM.getValue()), this.getSumLogData(row, credit)));
        }
    }

    private void dealSuppCashLog(Row row, long mainCFId, BigDecimal mainAmt, boolean iscash, boolean isPl) {
        long suppCfId = row.getLong("suppcfitem");
        if (suppCfId > 0L) {
            this.addSuppLog(row, row.getBigDecimal("suppcfamount"));
        } else {
            DynamicObject mainItem = this.batchLoadCfItem().get(mainCFId);
            if (!iscash && !isPl && mainItem.getBoolean("isdealactivity")) {
                if ("o".equals(mainItem.getString("direction"))) {
                    mainAmt = mainAmt.negate();
                }
                this.addSuppLog(row, mainAmt);
            } else if (isPl && !mainItem.getBoolean("isdealactivity")) {
                this.addSuppLog(row, row.getBigDecimal("debitlocal").subtract(row.getBigDecimal("creditlocal")));
            }
        }
    }

    private void addMaincfLog(Row row, BigDecimal amount) {
        CashflowSumLogKey maincfKey = this.createMainCfKey(row);
        CashflowSumLog mainFlowLog = this.getSumLogData(row, amount);
        this.tempLogList.add(maincfKey, mainFlowLog);
    }

    private void addSuppLog(Row row, BigDecimal amount) {
        CashflowSumLogKey suppFlowKey = this.createSuppCfKey(row);
        CashflowSumLog suppFlowLog = this.getSumLogData(row, amount);
        this.tempLogList.add(suppFlowKey, suppFlowLog);
    }

    private void addProfitCashflowLog(Row row, BigDecimal profitAmt) {
        Long orgId = row.getLong("org");
        DynamicObject profitItem = this.getProfitItem(orgId);
        if (profitItem == null) {
            return;
        }
        long profitItemId = profitItem.getLong("masterid");
        CashflowSumLogKey cashFlowKey = this.getSumLogPk(row, profitItemId, 0L, CashStatusType.PROFIT.getValue());
        CashflowSumLog cashFlowLog = this.getSumLogData(row, profitAmt);
        this.tempLogList.add(cashFlowKey, cashFlowLog);
    }

    private DynamicObject getProfitItem(long orgId) {
        HashMap<Long, DynamicObject> profitMap = (HashMap<Long, DynamicObject>)ThreadCache.get((Object)VCH_CASH_PROFITITEM);
        if (null == profitMap) {
            profitMap = new HashMap<Long, DynamicObject>();
            DynamicObject profitItem = this.loadProfitItem(orgId);
            profitMap.put(orgId, profitItem);
            ThreadCache.put((Object)VCH_CASH_PROFITITEM, profitMap);
            return profitItem;
        }
        if (profitMap.containsKey(orgId)) {
            return (DynamicObject)profitMap.get(orgId);
        }
        DynamicObject profitItem = this.loadProfitItem(orgId);
        profitMap.put(orgId, profitItem);
        ThreadCache.put((Object)VCH_CASH_PROFITITEM, profitMap);
        return profitItem;
    }

    private DynamicObject loadProfitItem(long orgId) {
        QFilter fid = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
        DynamicObject profitItem = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_cashflowitem", (QFilter[])new QFilter[]{new QFilter("isprefit", "=", (Object)"1"), fid});
        return profitItem;
    }

    private CashflowSumLog getSumLogData(Row rs, BigDecimal amount) {
        CashflowSumLog log = new CashflowSumLog();
        log.setAmount(amount);
        log.setCount(1);
        log.addVoucherInfo(rs.getLong("id"), rs.getLong("entries.id"), rs.getDate("bookeddate"), amount);
        return log;
    }

    private CashflowSumLogKey createMainCfKey(Row row) {
        return this.getSumLogPk(row, row.getLong("mcfmasterid"), row.getLong("maincfassgrp"), CashStatusType.MAINITEM.getValue());
    }

    private CashflowSumLogKey createSuppCfKey(Row row) {
        return this.getSumLogPk(row, row.getLong("scfmasterid"), 0L, CashStatusType.SUPPITEM.getValue());
    }

    private CashflowSumLogKey getSumLogPk(Row rs, long cfitemid, long assgrpid, String type) {
        return new CashflowSumLogKey(cfitemid, 0L, assgrpid, rs.getLong("account"), type, "0", Collections.emptyList());
    }

    private CashflowSumLogKey getSumLogPk(ResultSet rs) throws SQLException {
        return new CashflowSumLogKey(rs.getLong("fcfitemid"), 0L, rs.getLong("fassgrpid"), rs.getLong("faccountid"), rs.getString("ftype"), rs.getString("fdc"), Collections.emptyList());
    }

    protected CashflowData getSumData(ResultSet rs) throws SQLException {
        CashflowData data = new CashflowData(rs.getLong("fid"));
        data.setPeriodId(rs.getLong("fperiodid"));
        data.setAmount(rs.getBigDecimal("famount"));
        data.setCount(rs.getInt("fcount"));
        data.setAcctId(rs.getLong("faccountid"));
        return data;
    }

    private DataSet getVouSet(long orgId, long bookTypeId, long periodId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId);
        QFilter periodFilter = new QFilter("period", "=", (Object)periodId);
        QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{"B", "C"});
        QFilter sourceTypeFilter = new QFilter("sourcetype", "!=", (Object)"1");
        QFilter suppsFilter = new QFilter("suppstatus", "in", (Object)new String[]{"0", "1", "2", "3"});
        DataSet vouSet = QueryServiceHelper.queryDataSet((String)CashflowSumCalculator.class.getName(), (String)"gl_voucher", (String)VOUCHER_SELECT, (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, periodFilter, statusFilter, suppsFilter, sourceTypeFilter}, (String)"id");
        return vouSet;
    }

    private boolean isBudgetAcct(Row row) {
        return AccountType.isBudgetProp(row.getString("entries.account.accounttype.accounttype"));
    }

    private Map<Long, DynamicObject> batchLoadCfItem() {
        if (this.cfItemMapCache == null) {
            HashMap<Long, DynamicObject> cfItemMap = new HashMap<Long, DynamicObject>(8);
            Map resMap = BusinessDataServiceHelper.loadFromCache((String)"gl_cashflowitem", (String)"direction,isdealactivity,type", null);
            for (Map.Entry entry : resMap.entrySet()) {
                long id = (Long)entry.getKey();
                cfItemMap.put(id, (DynamicObject)entry.getValue());
            }
            this.cfItemMapCache = cfItemMap;
        }
        return this.cfItemMapCache;
    }

    private void resetVarData() {
        this.cashDebitInfo.clear();
        this.cashCreditInfo.clear();
        this.tempLogList.clear();
        this.cashDebitTotalAmt = BigDecimal.ZERO;
        this.cashCreditTotalAmt = BigDecimal.ZERO;
        this.hasCashOrPLAcct = false;
    }
}

