/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.gl.balcal.Log;

public class CashflowSumLog
extends Log {
    private BigDecimal amount = BigDecimal.ZERO;
    private Map<Long, Long> delvoucherIds = new HashMap<Long, Long>();
    private Map<Long, List<Object[]>> addVoucherInfos = new HashMap<Long, List<Object[]>>();

    @Override
    public void add(Log log) {
        if (log instanceof CashflowSumLog) {
            super.add(log);
            CashflowSumLog data = (CashflowSumLog)log;
            this.amount = this.amount.add(data.amount);
            this.delvoucherIds.putAll(data.delvoucherIds);
            Map<Long, List<Object[]>> addVouchers = data.addVoucherInfos;
            for (Map.Entry<Long, List<Object[]>> entry : addVouchers.entrySet()) {
                Long key = entry.getKey();
                List vEntryInfos = this.addVoucherInfos.computeIfAbsent(key, k -> new ArrayList(10));
                vEntryInfos.addAll((Collection)entry.getValue());
            }
        }
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void addVoucherInfo(long voucherId, long vchEntryId, Date bookedDate, BigDecimal amt) {
        List vEntryInfos = this.addVoucherInfos.computeIfAbsent(voucherId, k -> new ArrayList(10));
        vEntryInfos.add(new Object[]{vchEntryId, bookedDate, amt});
    }

    public Map<Long, List<Object[]>> getAddVoucherInfos() {
        return this.addVoucherInfos;
    }

    public void delVoucherId(long voucherId, long vchEntryId) {
        this.delvoucherIds.put(vchEntryId, voucherId);
    }

    public Map<Long, Long> getDelvoucherIds() {
        return this.delvoucherIds;
    }

    @Override
    public boolean isZero() {
        return super.isZero() && BigDecimal.ZERO.compareTo(this.amount) == 0;
    }

    @Override
    public String toString() {
        return "amount:" + this.amount + "," + super.toString();
    }
}

