/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.constant.InitBalance;

public class InitCashFlowKey {
    private int hashcode;
    private long org;
    private long bookType;
    private long cfitem;
    private long assgrp;
    private long currency;
    private List<Long> comAssists;

    public InitCashFlowKey(long org, long bookType, long cfitem, long assgrp, long currency, List<Long> comAssists) {
        this.org = org;
        this.bookType = bookType;
        this.cfitem = cfitem;
        this.assgrp = assgrp;
        this.currency = currency;
        this.comAssists = comAssists;
    }

    public InitCashFlowKey(DynamicObject dyn) {
        this.org = dyn.getLong(InitBalance.id_("org"));
        this.bookType = dyn.getLong(InitBalance.id_("booktype"));
        this.cfitem = dyn.getLong("account.masterid");
        this.assgrp = dyn.getLong(InitBalance.id_("assgrp"));
        this.currency = dyn.getLong(InitBalance.id_("currency"));
    }

    public int hashCode() {
        int result = this.hashcode;
        if (result == 0) {
            result = Long.hashCode(this.cfitem);
            result = 31 * result + Long.hashCode(this.assgrp);
            result = 31 * result + Long.hashCode(this.currency);
            result = 31 * result + Long.hashCode(this.org);
            result = 31 * result + Long.hashCode(this.bookType);
            for (Long comassist : this.comAssists) {
                result = 31 * result + Long.hashCode(comassist);
            }
            this.hashcode = result;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InitCashFlowKey)) {
            return false;
        }
        InitCashFlowKey bal = (InitCashFlowKey)obj;
        return bal.cfitem == this.cfitem && bal.assgrp == this.assgrp && bal.currency == this.currency && bal.org == this.org && bal.bookType == this.bookType && bal.comAssists.equals(this.comAssists);
    }

    public String toString() {
        return "org:" + this.org + ";bookType:" + this.bookType + ";account:" + this.cfitem + ";assgrp:" + this.assgrp + ";currency:" + this.currency + "comassists:" + this.comAssists.toString();
    }

    public long getOrg() {
        return this.org;
    }

    public long getBookType() {
        return this.bookType;
    }

    public long getCfitem() {
        return this.cfitem;
    }

    public long getAssgrp() {
        return this.assgrp;
    }

    public long getCurrency() {
        return this.currency;
    }

    public List<Long> getComAssists() {
        return this.comAssists;
    }
}

