/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal.carriedintoleaf;

import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.gl.balcal.carriedintoleaf.BalData;

public class SaveBalanceHandler {
    private static final Log logger = LogFactory.getLog(SaveBalanceHandler.class);
    private static final String T_GL_BALANCE = "T_GL_BALANCE";
    private static final int SPLIT_EXECUTE_COUNT = 5000;
    private static final String INSERT_BAL_SQL = "INSERT INTO T_GL_BALANCE(FID,FORGID,FBOOKTYPEID,FPERIODID,FENDPERIODID,FACCOUNTTABLEID,FACCOUNTID,FCURRENCYID,FASSGRPID,FMEASUREUNITID,FBEGINFOR,FBEGINLOCAL,FBEGINQTY,FYEARDEBITFOR,FYEARDEBITLOCAL,FYEARDEBITQTY,FYEARCREDITFOR,FYEARCREDITLOCAL,FYEARCREDITQTY,FENDFOR,FENDLOCAL,FENDQTY) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public void handle(List<BalData> balDatas) {
        try (TXHandle txHandle = TX.required();){
            try {
                this.insertBalData(balDatas);
            }
            catch (Exception e) {
                this.logError(e);
                txHandle.markRollback();
                throw e;
            }
        }
    }

    private void patchExecute(String sql, List<Object[]> insertParams) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)sql, insertParams);
    }

    private void logError(Exception e) {
        logger.error("\u79d1\u76ee\u7248\u672c\u5316\u4f59\u989d\u7ed3\u8f6c\u65e5\u5fd7\uff1a" + e);
    }

    private void insertBalData(List<BalData> balDatas) {
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(5000);
        for (BalData balData : balDatas) {
            Object[] insertParam = new Object[]{this.genLongIdMethod(T_GL_BALANCE), balData.getOrgId(), balData.getBookTypeId(), balData.getPeriod(), balData.getEndPeriodId(), balData.getAcctTblId(), balData.getAcctMasterId(), balData.getCurrency(), balData.getAssgrp(), balData.getMeasureUnitId(), balData.getBeginFor(), balData.getBeginLocal(), balData.getBeginQty(), balData.getYearDebitFor(), balData.getYearDebitLocal(), balData.getYearDebitQty(), balData.getYearCreditFor(), balData.getYearCreditLocal(), balData.getYearCreditQty(), balData.getEndFor(), balData.getEndLocal(), balData.getEndQty()};
            insertParams.add(insertParam);
            if (insertParams.size() < 5000) continue;
            this.patchExecute(INSERT_BAL_SQL, insertParams);
            insertParams.clear();
        }
        this.patchExecute(INSERT_BAL_SQL, insertParams);
    }

    private long genLongIdMethod(String tGlBalance) {
        return DB.genLongId((String)tGlBalance);
    }
}

