/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.dao.synbook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.business.vo.synbook.VoucherRefTrackerVO;
import kd.fi.gl.constant.VoucherRefTracker;

public class VoucherRefTrackerDao {
    private static final IDataEntityType type = OrmUtils.getDataEntityType(VoucherRefTrackerVO.class);

    public static void batchSaveVoucherRefTrackers(Collection<VoucherRefTrackerVO> voucherRefTrackers) {
        SaveServiceHelper.save((IDataEntityType)type, (Object[])voucherRefTrackers.toArray());
    }

    public static List<VoucherRefTrackerVO> getTrackersBySourceVouchers(Collection<Long> sourceVoucherIds, Long targetBookId) {
        ArrayList<VoucherRefTrackerVO> result = new ArrayList<VoucherRefTrackerVO>(sourceVoucherIds.size());
        try (DataSet logDataSet = QueryServiceHelper.queryDataSet((String)"SynBookLogDao.getLogsBySourceVouchers", (String)"gl_voucher_ref_tracker", (String)String.join((CharSequence)",", VoucherRefTracker.ALL_FIELDS), (QFilter[])QFilterBuilder.create((String)"sourcevoucher", (String)"in", sourceVoucherIds).addEqual("targetbook", (Object)targetBookId).toArray(new QFilter[0]), (String)"");){
            for (Row row : logDataSet) {
                result.add(new VoucherRefTrackerVO(row.getLong("id"), row.getString("username"), row.getString("opdesc"), row.getDate("optime"), row.getLong("sourcevoucher"), row.getLong("targetbook")));
            }
        }
        return result;
    }

    public static void deleteBySrcVoucherAndTargetBook(List<Object[]> params) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)"DELETE FROM T_GL_VOUCHER_REF_TRACKER WHERE FSOURCEVOUCHERID = ? AND FTARGETBOOKID = ?", params);
    }
}

