/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.dao.voucher.option;

import java.util.Arrays;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.business.service.voucher.option.cfg.VoucherCarryConfig;
import kd.fi.gl.business.service.voucher.option.key.CarryKey;

public class VoucherCarryConfigDAO {
    private static final String ORG = "org";
    private static final String USER = "user";
    private static final String ISDEFAULT = "isdefault";
    private static final String ORG_ID = "org_id";
    private static final String USER_ID = "user_id";

    public static VoucherCarryConfig create(long orgId, long userId) {
        return VoucherCarryConfig.fromDynamic(orgId, userId, VoucherCarryConfigDAO.createDynamic(orgId, userId, false));
    }

    public static Optional<VoucherCarryConfig> tryLoadDefault(long userId) {
        return VoucherCarryConfigDAO.tryLoadDynamic(0L, userId, true).map(x -> {
            VoucherCarryConfig config = VoucherCarryConfig.fromDynamic(0L, userId, x);
            config.setDefaultConfig(true);
            return config;
        });
    }

    public static Optional<VoucherCarryConfig> tryLoad(long orgId, long userId) {
        return VoucherCarryConfigDAO.tryLoadDynamic(orgId, userId, false).map(x -> VoucherCarryConfig.fromDynamic(orgId, userId, x));
    }

    public static void save(VoucherCarryConfig config) {
        DynamicObject dynamicConfig = VoucherCarryConfigDAO.tryLoadDynamic(config.getOrgId(), config.getUserId(), config.isDefaultConfig()).orElseGet(() -> VoucherCarryConfigDAO.createDynamic(config.getOrgId(), config.getUserId(), config.isDefaultConfig()));
        Arrays.stream(CarryKey.values()).forEach(x -> dynamicConfig.set(x.name(), (Object)config.isCarry((CarryKey)((Object)x))));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicConfig});
    }

    public static void setDefault(VoucherCarryConfig config) {
        try (TXHandle th = TX.requiresNew();){
            try {
                config.setOrgId(0L);
                config.setDefaultConfig(true);
                VoucherCarryConfigDAO.save(config);
                DeleteServiceHelper.delete((String)"gl_fieldautofill", (QFilter[])new QFilter(USER, "=", (Object)config.getUserId()).and(ISDEFAULT, "=", (Object)false).toArray());
            }
            catch (Throwable e) {
                th.markRollback();
                throw e;
            }
        }
    }

    public static DynamicObject createDynamic(long orgId, long userId, boolean isDefault) {
        DynamicObject dynamicConfig = BusinessDataServiceHelper.newDynamicObject((String)"gl_fieldautofill");
        dynamicConfig.set(ORG_ID, (Object)orgId);
        dynamicConfig.set(USER_ID, (Object)userId);
        dynamicConfig.set(ISDEFAULT, (Object)isDefault);
        return dynamicConfig;
    }

    public static Optional<DynamicObject> tryLoadDynamic(long orgId, long userId, boolean isDefault) {
        DynamicObject dynamicConfig = isDefault ? BusinessDataServiceHelper.loadSingleFromCache((String)"gl_fieldautofill", (QFilter[])new QFilter(ISDEFAULT, "=", (Object)true).and(USER, "=", (Object)userId).toArray()) : BusinessDataServiceHelper.loadSingleFromCache((String)"gl_fieldautofill", (QFilter[])new QFilter(ORG, "=", (Object)orgId).and(USER, "=", (Object)userId).and(ISDEFAULT, "=", (Object)false).toArray());
        return Optional.ofNullable(dynamicConfig);
    }
}

