/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.log;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.interfaces.service.bal.log.IDataChangeLogSaveService;
import kd.fi.gl.interfaces.service.bal.log.ISimpleDataEntity;

public abstract class AbstractDataChangeLogSaveService<C extends ISimpleDataEntity, S extends ISimpleDataEntity>
implements IDataChangeLogSaveService<C, S> {
    static final LogORM logORM = LogORM.create();

    protected abstract BlockingQueue<C> getChangeQueue();

    protected abstract BlockingQueue<S> getSourceQueue();

    protected abstract AtomicBoolean getChangeSaveStatus();

    protected abstract AtomicBoolean getSourceSaveStatus();

    protected abstract TaskType getChangeSaveTaskType();

    protected abstract TaskType getSourceSaveTaskType();

    @Override
    public void recordSourceLog(List<S> sourceLogs) {
        if (sourceLogs.isEmpty()) {
            return;
        }
        BlockingQueue<S> queue = this.getSourceQueue();
        try {
            for (ISimpleDataEntity changeLog : sourceLogs) {
                if (queue.offer(changeLog, 1L, TimeUnit.MINUTES)) continue;
                return;
            }
            this.submitSaveTask(queue, this.getSourceSaveStatus(), this.getSourceSaveTaskType());
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void recordChangeLog(List<C> changeLogs) {
        if (changeLogs.isEmpty()) {
            return;
        }
        BlockingQueue<C> queue = this.getChangeQueue();
        try {
            for (ISimpleDataEntity changeLog : changeLogs) {
                if (queue.offer(changeLog, 1L, TimeUnit.DAYS)) continue;
                return;
            }
            this.submitSaveTask(queue, this.getChangeSaveStatus(), this.getChangeSaveTaskType());
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    protected <T extends ISimpleDataEntity> void submitSaveTask(BlockingQueue<T> queue, AtomicBoolean executingStatus, TaskType taskType) {
        if (!executingStatus.get()) {
            ThreadService.execute(() -> {
                if (!executingStatus.getAndSet(true)) {
                    try {
                        this.batchSave(queue, 1000);
                    }
                    finally {
                        executingStatus.set(false);
                    }
                }
            }, (TaskType)taskType);
        }
    }

    <T extends ISimpleDataEntity> void batchSave(BlockingQueue<T> queue, int batchSize) {
        try {
            ArrayList<ISimpleDataEntity> elements = new ArrayList<ISimpleDataEntity>(batchSize);
            ISimpleDataEntity element = null;
            while ((element = (ISimpleDataEntity)queue.poll(500L, TimeUnit.MILLISECONDS)) != null) {
                elements.add(element);
                if (elements.size() < batchSize) continue;
                this.saveDataEntityLog(elements);
                elements.clear();
            }
            if (!elements.isEmpty()) {
                this.saveDataEntityLog(elements);
                elements.clear();
            }
        }
        catch (Throwable e) {
            LogFactory.getLog(this.getClass()).error(e);
            throw new IllegalStateException(e);
        }
    }

    public <T extends ISimpleDataEntity> void saveDataEntityLog(List<T> changeLogs) {
        HashMap<Class, List> clazz2Data = new HashMap<Class, List>(4);
        for (ISimpleDataEntity changeLog : changeLogs) {
            clazz2Data.computeIfAbsent(changeLog.getClass(), x -> new ArrayList(32)).add(changeLog);
        }
        ArrayList dyos = new ArrayList(changeLogs.size());
        clazz2Data.forEach((clazz, logs) -> {
            IDataEntityType dt = DataEntityType.getDataEntityType((Class)clazz);
            dyos.addAll(this.toDynamicObj((List<? extends ISimpleDataEntity>)logs, dt.getName()));
        });
        logORM.insert(dyos);
    }

    public List<DynamicObject> toDynamicObj(List<? extends ISimpleDataEntity> dataEntities, String entityName) {
        ArrayList<DynamicObject> res = new ArrayList<DynamicObject>(dataEntities.size());
        if (!dataEntities.isEmpty()) {
            DataEntityType dt = (DataEntityType)DataEntityType.getDataEntityType(dataEntities.get(0).getClass());
            DataEntityPropertyCollection properties = dt.getProperties();
            for (ISimpleDataEntity iSimpleDataEntity : dataEntities) {
                DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                for (IDataEntityProperty property : properties) {
                    dyo.set(property.getName(), property.getValueFast((Object)iSimpleDataEntity));
                }
                res.add(dyo);
            }
        }
        return res;
    }
}

