/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.orgrootchange;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.ext.version.BaseDataOrgRelExtService;
import kd.bos.bd.pojo.CtrlStrategyEnum;
import kd.bos.bd.service.AssignService;
import kd.bos.bd.service.ChangeManageRightService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgChangeCheckDetail;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.assign.AssignResult;
import kd.fi.bd.assign.AssignServiceHelper;
import kd.fi.gl.enums.basedata.BaseDataTypeEnum;
import org.apache.commons.lang3.tuple.Pair;

public class BaseDataServiceHelper {
    private static final Log log = LogFactory.getLog(BaseDataServiceHelper.class);
    private static int batchSize = 200;

    public List<OrgChangeCheckDetail> changeRootOrgBdUp(long oldRootId, long newRootId) {
        log.info("OrgRootChange basedata up start..");
        ArrayList<OrgChangeCheckDetail> checkDetails = new ArrayList<OrgChangeCheckDetail>(16);
        this.extUp(oldRootId, newRootId);
        for (BaseDataTypeEnum bt : BaseDataTypeEnum.values()) {
            Pair<Map<String, String>, Map<String, String>> result = this.standardUp(bt.getValue(), oldRootId, newRootId);
            this.dealResult(bt.getValue(), result, checkDetails);
        }
        Map<String, String> result = this.accountUp(oldRootId, newRootId);
        String solution = ResManager.loadKDString((String)"\u5c06\u4f7f\u7528\u6743\u5206\u914d\u7ed9\u65e7\u6839\u7ec4\u7ec7", (String)"BaseDataServiceHelper_4", (String)"fi-gl-common", (Object[])new Object[0]);
        this.addCheckDetail("bd_accountview", solution, checkDetails, result);
        Pair<Map<String, String>, Map<String, String>> r = this.cfItemUp("gl_cashflowitem", oldRootId, newRootId);
        this.dealResult("gl_cashflowitem", r, checkDetails);
        log.info("OrgRootChange basedata up end..");
        return checkDetails;
    }

    public Pair<Map<String, String>, Map<String, String>> standardUp(String entityId, long oldRootId, long newRootId) {
        HashMap<String, String> changResult = new HashMap<String, String>(16);
        HashMap<String, String> assignResult = new HashMap<String, String>(16);
        try {
            String selectFields = "id,number,ctrlstrategy";
            QFilter orgFilter = new QFilter("createorg", "=", (Object)oldRootId);
            QFilter csFilter = new QFilter("ctrlstrategy", "!=", (Object)CtrlStrategyEnum.PRIVATE.getCtrlStrategy());
            DynamicObjectCollection datas = QueryServiceHelper.query((String)entityId, (String)selectFields, (QFilter[])new QFilter[]{orgFilter, csFilter});
            if (CollectionUtils.isEmpty((Collection)datas)) {
                return Pair.of(changResult, assignResult);
            }
            HashMap<String, Set> dataMap = new HashMap<String, Set>(5);
            HashMap<Long, String> dataNumbers = new HashMap<Long, String>(16);
            for (DynamicObject data : datas) {
                Set values = dataMap.computeIfAbsent(data.getString("ctrlstrategy"), k -> new HashSet(16));
                values.add(data.getLong("id"));
                dataNumbers.put(data.getLong("id"), data.getString("number"));
            }
            String appId = this.getAppId(entityId);
            for (Map.Entry entry : dataMap.entrySet()) {
                Set dataIds = (Set)entry.getValue();
                BaseDataResponse changeResponse = this.getChangeManageRightService().changeManageRight(entityId, Long.valueOf(oldRootId), appId, dataIds, Long.valueOf(newRootId), true);
                if (!changeResponse.isSuccess()) {
                    this.dealFailResult(changeResponse, changResult, dataIds, dataNumbers);
                    continue;
                }
                String ctrlstrategy = (String)entry.getKey();
                if (!CtrlStrategyEnum.CU_ASSIGN.getCtrlStrategy().equals(ctrlstrategy) && !CtrlStrategyEnum.FREE_ASSIGN.getCtrlStrategy().equals(ctrlstrategy)) continue;
                HashSet<Long> orgSet = new HashSet<Long>(10);
                orgSet.add(oldRootId);
                AssignService assignService = this.getAssignService(entityId);
                BaseDataResponse assignRes = assignService.assign(Long.valueOf(newRootId), appId, dataIds, orgSet, true);
                if (assignRes.isSuccess()) continue;
                this.dealFailResult(assignRes, assignResult, dataIds, dataNumbers);
            }
        }
        catch (Exception e) {
            log.error("\u6807\u51c6\u57fa\u7840\u8d44\u6599\u5347\u7ea7\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5931\u8d25\u3002", (Throwable)e);
            changResult.put(entityId, e.getMessage());
        }
        return Pair.of(changResult, assignResult);
    }

    public Map<String, String> accountUp(long oldRootId, long newRootId) {
        try (TXHandle tx = TX.requiresNew((String)"BaseDataServiceHelper.accountUp");){
            try {
                DBRoute gl = DBRoute.of((String)"fi");
                String UPDATE_SQL = "UPDATE T_bd_account SET fcreateorgid = ?,forgid = ?,fsrccreateorgid = ? WHERE fcreateorgid = ?;";
                Object[] params = new Object[]{newRootId, newRootId, newRootId, oldRootId};
                DB.update((DBRoute)gl, (String)UPDATE_SQL, (Object[])params);
                UPDATE_SQL = "UPDATE t_bd_accountusereg SET fcreateorgid = ?,fadminorgid = ? WHERE fcreateorgid = ?;";
                params = new Object[]{newRootId, newRootId, oldRootId};
                DB.update((DBRoute)gl, (String)UPDATE_SQL, (Object[])params);
                UPDATE_SQL = "UPDATE t_bd_accountexc SET fcreateorgid = ? WHERE fcreateorgid = ?;";
                params = new Object[]{newRootId, oldRootId};
                DB.update((DBRoute)gl, (String)UPDATE_SQL, (Object[])params);
                new DataEntityCacheManager("T_bd_account").removeByDt();
            }
            catch (Exception e) {
                tx.markRollback();
                log.error("\u4f1a\u8ba1\u79d1\u76ee\u7ba1\u7406\u6743\u8f6c\u8ba9\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u4f1a\u8ba1\u79d1\u76ee\u7ba1\u7406\u6743\u8f6c\u8ba9\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"BaseDataServiceHelper_1", (String)"fi-gl-common", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
        ArrayList<Long> orgList = new ArrayList<Long>(2);
        orgList.add(newRootId);
        orgList.add(oldRootId);
        this.clearCache("bd_accountview", orgList);
        return this.assignAccount(oldRootId, newRootId);
    }

    public Pair<Map<String, String>, Map<String, String>> cfItemUp(String entityId, long oldRootId, long newRootId) {
        HashMap<String, String> changResult = new HashMap<String, String>(16);
        HashMap<String, String> assignResult = new HashMap<String, String>(16);
        try {
            String selectFields = "id,number,ctrlstrategy";
            QFilter orgFilter = new QFilter("createorg", "=", (Object)oldRootId);
            QFilter csFilter = new QFilter("ctrlstrategy", "!=", (Object)CtrlStrategyEnum.PRIVATE.getCtrlStrategy());
            DynamicObjectCollection datas = QueryServiceHelper.query((String)entityId, (String)selectFields, (QFilter[])new QFilter[]{orgFilter, csFilter});
            if (CollectionUtils.isEmpty((Collection)datas)) {
                return Pair.of(changResult, assignResult);
            }
            HashMap<String, Set> dataMap = new HashMap<String, Set>(5);
            HashMap<Long, String> dataNumbers = new HashMap<Long, String>(16);
            HashSet<Long> dataIds = new HashSet<Long>(datas.size());
            for (DynamicObject data : datas) {
                long dataId = data.getLong("id");
                String ctrlstrategy = data.getString("ctrlstrategy");
                dataIds.add(dataId);
                if (!CtrlStrategyEnum.CU_ASSIGN.getCtrlStrategy().equals(ctrlstrategy) && !CtrlStrategyEnum.FREE_ASSIGN.getCtrlStrategy().equals(ctrlstrategy)) continue;
                Set values = dataMap.computeIfAbsent(ctrlstrategy, k -> new HashSet(16));
                values.add(dataId);
                dataNumbers.put(dataId, data.getString("number"));
            }
            new BaseDataOrgRelExtService(entityId).drmWithResetViewRoot(Long.valueOf(oldRootId), Long.valueOf(newRootId), new ArrayList(dataIds));
            String appId = this.getAppId(entityId);
            for (Map.Entry entry : dataMap.entrySet()) {
                Set asdIds = (Set)entry.getValue();
                HashSet<Long> orgSet = new HashSet<Long>(10);
                orgSet.add(oldRootId);
                AssignService assignService = this.getAssignService(entityId);
                BaseDataResponse assignRes = assignService.assign(Long.valueOf(newRootId), appId, asdIds, orgSet, true);
                if (assignRes.isSuccess()) continue;
                this.dealFailResult(assignRes, assignResult, asdIds, dataNumbers);
            }
        }
        catch (Exception e) {
            log.error("\u6807\u51c6\u57fa\u7840\u8d44\u6599\u5347\u7ea7\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5931\u8d25\u3002", (Throwable)e);
            changResult.put(entityId, e.getMessage());
        }
        return Pair.of(changResult, assignResult);
    }

    public Map<String, String> assignAccount(long oldRootId, long newRootId) {
        QFilter csFilter;
        HashMap<String, String> assignResult = new HashMap<String, String>(16);
        QFilter orgFilter = new QFilter("createorg", "=", (Object)newRootId);
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"bd_accountview", (String)"id,number,accounttable,ctrlstrategy", (QFilter[])new QFilter[]{orgFilter, csFilter = new QFilter("ctrlstrategy", "in", (Object)new String[]{CtrlStrategyEnum.CU_ASSIGN.getCtrlStrategy(), CtrlStrategyEnum.FREE_ASSIGN.getCtrlStrategy()})});
        if (CollectionUtils.isEmpty((Collection)datas)) {
            return assignResult;
        }
        HashMap<String, Map> dataMap = new HashMap<String, Map>(2);
        HashMap<Long, String> dataNumbers = new HashMap<Long, String>(16);
        for (DynamicObject data : datas) {
            Map valueMap = dataMap.computeIfAbsent(data.getString("ctrlstrategy"), k -> new HashMap(16));
            List values = valueMap.computeIfAbsent(data.getLong("accounttable"), k -> new ArrayList(10));
            values.add(data.getLong("id"));
            dataNumbers.put(data.getLong("id"), data.getString("number"));
        }
        ArrayList<Long> useOrgs = new ArrayList<Long>(10);
        useOrgs.add(oldRootId);
        for (Map.Entry entry : dataMap.entrySet()) {
            String ctrlstrategy = (String)entry.getKey();
            Map valueMap = (Map)entry.getValue();
            for (Map.Entry et : valueMap.entrySet()) {
                List dataIds = (List)et.getValue();
                List batchList = Lists.partition((List)dataIds, (int)batchSize);
                for (List partList : batchList) {
                    try {
                        AssignResult assignRes = AssignServiceHelper.assign((Long)newRootId, useOrgs, (List)partList, (String)ctrlstrategy);
                        if (AssignResult.ResultType.success.equals((Object)assignRes.getResultType())) continue;
                        String msg = "";
                        if (assignRes.getMsgs() != null && assignRes.getMsgs().size() > 0) {
                            msg = (String)assignRes.getMsgs().iterator().next();
                        }
                        for (Long dataId : partList) {
                            assignResult.put((String)dataNumbers.get(dataId), msg);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u91cd\u7f6e\u6839\u7ec4\u7ec7\u4f1a\u8ba1\u79d1\u76ee\u5206\u914d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5931\u8d25\u3002", (Throwable)e);
                        for (Long dataId : partList) {
                            assignResult.put((String)dataNumbers.get(dataId), e.getMessage());
                        }
                    }
                }
            }
        }
        return assignResult;
    }

    public void extUp(long oldRootId, long newRootId) {
        Object[] params = new Object[]{newRootId, oldRootId};
        try (TXHandle tx = TX.requiresNew((String)"BaseDataServiceHelper.extUp");){
            try {
                DBRoute gl = DBRoute.of((String)"fi");
                String UPDATE_SQL = "UPDATE T_bd_accounttable SET forgid = ? WHERE forgid = ?;";
                DB.update((DBRoute)gl, (String)UPDATE_SQL, (Object[])params);
                UPDATE_SQL = "UPDATE t_gl_presetcashflowitem SET fcreateorgid = ? WHERE fcreateorgid = ?;";
                DB.update((DBRoute)gl, (String)UPDATE_SQL, (Object[])params);
                new DataEntityCacheManager("T_bd_accounttable").removeByDt();
                new DataEntityCacheManager("t_gl_presetcashflowitem").removeByDt();
            }
            catch (Exception e) {
                tx.markRollback();
                log.error("\u79d1\u76ee\u8868\u3001\u79d1\u76ee\u73b0\u91d1\u6d41\u91cf\u6620\u5c04\u5173\u7cfb\u7ba1\u7406\u6743\u8f6c\u8ba9\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u79d1\u76ee\u8868\u3001\u79d1\u76ee\u73b0\u91d1\u6d41\u91cf\u6620\u5c04\u5173\u7cfb\u7ba1\u7406\u6743\u8f6c\u8ba9\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"BaseDataServiceHelper_2", (String)"fi-gl-common", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
        tx = TX.requiresNew((String)"BaseDataServiceHelper.asstExtUp");
        var7_5 = null;
        try {
            try {
                String UPDATE_SQL = "UPDATE t_bas_flex_property SET fcreateorgid = ? WHERE fcreateorgid = ?;";
                DB.update((DBRoute)DBRoute.base, (String)UPDATE_SQL, (Object[])params);
                new DataEntityCacheManager("t_bas_flex_property").removeByDt();
            }
            catch (Exception e) {
                tx.markRollback();
                log.error("\u6838\u7b97\u7ef4\u5ea6\u7ba1\u7406\u6743\u8f6c\u8ba9\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u7ba1\u7406\u6743\u8f6c\u8ba9\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"BaseDataServiceHelper_5", (String)"fi-gl-common", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
        catch (Throwable throwable) {
            var7_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void dealFailResult(BaseDataResponse response, Map<String, String> result, Set<Long> dataIds, Map<Long, String> dataNumbers) {
        Map resultMap = response.getResult();
        if (CollectionUtils.isEmpty((Map)resultMap)) {
            dataIds.stream().forEach(a -> result.put((String)dataNumbers.get(a), response.getErrorMsg()));
        } else {
            Collection errorMsgMap = resultMap.values();
            for (Map errorMap : errorMsgMap) {
                if (CollectionUtils.isEmpty((Map)errorMap)) continue;
                for (Map.Entry error : errorMap.entrySet()) {
                    String number = dataNumbers.get(error.getKey());
                    result.put(number, (String)error.getValue());
                }
            }
        }
    }

    protected String getAppId(String entityId) {
        if (null != entityId) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            return null != mainEntityType ? mainEntityType.getAppId() : null;
        }
        return null;
    }

    private void clearCache(String entity, List<Long> orgIDList) {
        BaseDataService baseDataService = new BaseDataService();
        orgIDList.stream().forEach(orgid -> baseDataService.clearBaseDataFilterCache(entity, orgid));
        kd.bos.servicehelper.basedata.BaseDataServiceHelper.refreshBaseDataUseRange((String)entity, orgIDList);
    }

    private void dealResult(String entity, Pair<Map<String, String>, Map<String, String>> result, List<OrgChangeCheckDetail> checkDetails) {
        Map errorMap = (Map)result.getLeft();
        String solution = ResManager.loadKDString((String)"\u5c06\u7ba1\u7406\u6743\u8f6c\u8ba9\u7ed9\u65b0\u6839\u7ec4\u7ec7", (String)"BaseDataServiceHelper_3", (String)"fi-gl-common", (Object[])new Object[0]);
        this.addCheckDetail(entity, solution, checkDetails, errorMap);
        errorMap = (Map)result.getRight();
        solution = ResManager.loadKDString((String)"\u5c06\u4f7f\u7528\u6743\u5206\u914d\u7ed9\u65e7\u6839\u7ec4\u7ec7", (String)"BaseDataServiceHelper_4", (String)"fi-gl-common", (Object[])new Object[0]);
        this.addCheckDetail(entity, solution, checkDetails, errorMap);
    }

    private void addCheckDetail(String entity, String solution, List<OrgChangeCheckDetail> checkDetails, Map<String, String> errorMap) {
        if (CollectionUtils.isEmpty(errorMap)) {
            return;
        }
        for (Map.Entry<String, String> entry : errorMap.entrySet()) {
            OrgChangeCheckDetail assistantCheckDetail = new OrgChangeCheckDetail();
            assistantCheckDetail.setEntity(entity);
            assistantCheckDetail.setBdNumber(entry.getKey());
            assistantCheckDetail.setReason(entry.getValue());
            assistantCheckDetail.setSolution(solution);
            checkDetails.add(assistantCheckDetail);
        }
    }

    public DynamicObject saveChangeRecord(long oldRootId, long newRootId) {
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"gl_org_changerecord");
        record.set("billno", (Object)newRootId);
        record.set("executionstatus", (Object)"0");
        record.set("oldorg", (Object)oldRootId);
        record.set("neworg", (Object)newRootId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        return record;
    }

    public void saveChangeResult(DynamicObject record, List<OrgChangeCheckDetail> checkDetails) {
        if (checkDetails != null && checkDetails.size() > 0) {
            DynamicObjectCollection collection = record.getDynamicObjectCollection("entryentity");
            collection.clear();
            for (OrgChangeCheckDetail detail : checkDetails) {
                DynamicObject entry = collection.addNew();
                entry.set("entity", (Object)detail.getEntity());
                entry.set("bdnumber", (Object)detail.getBdNumber());
                entry.set("reason", (Object)StringUtils.substring((String)detail.getReason(), (int)0, (int)200));
                entry.set("solution", (Object)StringUtils.substring((String)detail.getSolution(), (int)0, (int)50));
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
    }

    protected ChangeManageRightService getChangeManageRightService() {
        return new ChangeManageRightService();
    }

    protected AssignService getAssignService(String entityId) {
        return new AssignService(entityId);
    }
}

