/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.reciprocal.baldeduct;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.exception.KDBizException;

public class AssgrpFeed<K> {
    private final Date bookDate;
    private final long accMasterId;
    private Map<K, Set<Long>> assgrpMap = new HashMap<K, Set<Long>>(8);
    private boolean isFullReCalculate = false;
    private boolean existUnAcccurrent = false;
    private int thresholdAssgrpIdCount;

    public AssgrpFeed(Date bookDate, long accMasterId, int assgrpIdCountThreshold) {
        if (Objects.isNull(bookDate)) {
            throw new KDBizException("The accounting date cannot be empty");
        }
        this.bookDate = bookDate;
        this.accMasterId = accMasterId;
        this.thresholdAssgrpIdCount = assgrpIdCountThreshold;
    }

    public void feedUnAcccurrentRecord(Date forWriteoffDate, Date localWriteOffDate, K currencyId, long assgrpId) {
        boolean isReCal;
        this.existUnAcccurrent = true;
        if (this.checkFullReCalculate(assgrpId)) {
            return;
        }
        boolean bl = isReCal = null != forWriteoffDate && forWriteoffDate.compareTo(this.bookDate) > 0 || null != localWriteOffDate && localWriteOffDate.compareTo(this.bookDate) > 0;
        if (isReCal) {
            this.updateAssgrpMap(currencyId, assgrpId);
        }
    }

    public void feedChangeRecord(K currencyId, long assgrpId) {
        if (this.checkFullReCalculate(assgrpId)) {
            return;
        }
        this.updateAssgrpMap(currencyId, assgrpId);
    }

    private boolean checkFullReCalculate(long assgrpId) {
        if (this.isFullReCalculate) {
            return true;
        }
        if (0L == assgrpId) {
            this.isFullReCalculate = true;
            return true;
        }
        return false;
    }

    private void updateAssgrpMap(K currencyId, long assgrpId) {
        Set<Long> assgrpSet = this.assgrpMap.get(currencyId);
        if (null == assgrpSet) {
            assgrpSet = new HashSet<Long>(8);
            this.assgrpMap.put(currencyId, assgrpSet);
        }
        assgrpSet.add(assgrpId);
        int curAssgrpCnt = this.assgrpMap.values().stream().mapToInt(x -> x.size()).sum();
        if (curAssgrpCnt > this.thresholdAssgrpIdCount) {
            this.isFullReCalculate = true;
        }
    }

    public boolean isFullReCalculate() {
        if (!this.existUnAcccurrent) {
            return true;
        }
        return this.isFullReCalculate;
    }

    public Map<K, Set<Long>> getCalculateAssgrp() {
        return Collections.unmodifiableMap(this.assgrpMap);
    }

    public String toString() {
        return "AssgrpFeed{bookDate=" + this.bookDate + ", accMasterId=" + this.accMasterId + ", assgrpMap=" + this.assgrpMap + ", isFullReCalculate=" + this.isFullReCalculate + ", thresholdAssgrpIdCount=" + this.thresholdAssgrpIdCount + '}';
    }
}

