/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.reciprocal.baldeduct.result;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.gl.business.vo.reciprocal.AccountFlexVO;
import kd.fi.gl.reciprocal.RcpWriteOffUtils;
import kd.fi.gl.reciprocal.ReciprocalRecord;

public abstract class AgingResult {
    protected DataSetBuilder dsBuilder;
    protected RowMeta rowMeta;
    protected List<AccountFlexVO> acctFlexVOs;
    protected Date expiredate;
    protected boolean showByExpireDate;
    protected boolean isSynCurrency;

    public AgingResult(List<AccountFlexVO> accountFlexVOS) {
        this(accountFlexVOS, false, null, false);
        this.initialize();
    }

    public AgingResult(List<AccountFlexVO> accountFlexVOS, boolean showByExpireDate, Date expiredate, boolean isSynCurrency) {
        this.acctFlexVOs = Objects.isNull(accountFlexVOS) ? new ArrayList(0) : accountFlexVOS;
        this.expiredate = expiredate;
        this.showByExpireDate = showByExpireDate;
        if (this.showByExpireDate) {
            Preconditions.checkNotNull((Object)expiredate, (Object)ResManager.loadKDString((String)"\u5230\u671f\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgingResult_0", (String)"fi-gl-common", (Object[])new Object[0]));
            this.expiredate = expiredate;
        }
        this.isSynCurrency = isSynCurrency;
    }

    protected void initialize() {
        this.rowMeta = this.buildRowMeta();
        this.dsBuilder = RcpWriteOffUtils.dataSetBuilder(this.rowMeta);
    }

    protected abstract RowMeta buildRowMeta();

    public abstract void add(ReciprocalRecord var1);

    public abstract DataSet getAgingResult();

    protected RowMeta getRowMeta() {
        return this.rowMeta;
    }
}

