/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.reciprocal.baldeduct.result;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.fi.gl.business.service.reciprocal.baldeduct.result.AgingResult;
import kd.fi.gl.business.vo.reciprocal.AccountFlexVO;
import kd.fi.gl.business.vo.reciprocal.AgeRangeVO;
import kd.fi.gl.enums.writeoff.WriteOffField;
import kd.fi.gl.reciprocal.RcpWriteOffUtils;
import kd.fi.gl.reciprocal.ReciprocalRecord;

public class AgingSumarryResult
extends AgingResult {
    private static final String SUFFIX_LOCAL = "local";
    private final List<Integer> sumIndexFileds = new ArrayList<Integer>(8);
    private final List<AgeRangeVO> rangeVOs;
    private Object[] sumAssistData;
    private Object[] preRowGroupKey;

    public AgingSumarryResult(List<AgeRangeVO> rangeVOs, List<AccountFlexVO> accountFlexVOS, boolean showByExpireDate, Date expiredate, boolean isSynCurrency) {
        super(accountFlexVOS, showByExpireDate, expiredate, isSynCurrency);
        this.rangeVOs = Objects.isNull(rangeVOs) ? new ArrayList(0) : rangeVOs;
        this.initialize();
        for (int i = 0; i < this.rowMeta.getDataTypes().length; ++i) {
            if (!(this.rowMeta.getDataType(i) instanceof BigDecimalType)) continue;
            this.sumIndexFileds.add(i);
        }
    }

    @Override
    protected RowMeta buildRowMeta() {
        ArrayList<Field> writeOffFields = new ArrayList<Field>(5 + this.acctFlexVOs.size() + 2 * this.rangeVOs.size() + 6);
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.ORG));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.ACCOUNT));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.CURRENCYID));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.CURRENCYFOR));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.CURRENCYLOCAL));
        for (AccountFlexVO accountFlexVO : this.acctFlexVOs) {
            writeOffFields.add(RcpWriteOffUtils.buildField(accountFlexVO.getFlexField(), WriteOffField.ASSGRPITEM.getType()));
        }
        for (AgeRangeVO rangeVO : this.rangeVOs) {
            String name = rangeVO.getName();
            writeOffFields.add(RcpWriteOffUtils.buildField(name, WriteOffField.UDE_EXT.getType()));
            writeOffFields.add(RcpWriteOffUtils.buildField(name + SUFFIX_LOCAL, WriteOffField.UDE_EXT.getType()));
        }
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.OVERDUETOTAL));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.OVERDUETOTALLOCAL));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.UNDUETOTAL));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.UNDUETOTALLOCAL));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.BALTOTAL));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.LOCALBALTOTAL));
        return new RowMeta(writeOffFields.toArray(new Field[0]));
    }

    @Override
    public void add(ReciprocalRecord unWriteOffVO) {
        this.assistSum(unWriteOffVO);
    }

    @Override
    public DataSet getAgingResult() {
        this.add(null);
        return this.dsBuilder.build();
    }

    private void assistSum(ReciprocalRecord unWriteOffVO) {
        if (Objects.isNull(unWriteOffVO)) {
            if (Objects.nonNull(this.sumAssistData) && this.sumAssistData.length > 0) {
                this.dsBuilder.append(this.sumAssistData);
            }
            return;
        }
        Object[] groupKey = this.comAssgrpKey(unWriteOffVO);
        if (Objects.nonNull(this.preRowGroupKey) && !Arrays.equals(this.preRowGroupKey, groupKey)) {
            this.dsBuilder.append(this.sumAssistData);
            this.sumAssistData = null;
        }
        this.preRowGroupKey = groupKey;
        this.summary(unWriteOffVO);
    }

    private void summary(ReciprocalRecord unWriteOffVO) {
        ArrayList<Object> values = new ArrayList<Object>(30);
        values.add(unWriteOffVO.getOrg());
        values.add(unWriteOffVO.getAccount());
        if (this.isSynCurrency) {
            values.add(unWriteOffVO.getLocalCurrency());
        } else {
            values.add(unWriteOffVO.getCurrency());
        }
        values.add(unWriteOffVO.getCurrency());
        values.add(unWriteOffVO.getLocalCurrency());
        for (AccountFlexVO accountFlexVO : this.acctFlexVOs) {
            Map<String, Object> assgrpVals = unWriteOffVO.getAssgrpVals();
            if (Objects.nonNull(assgrpVals)) {
                values.add(assgrpVals.get(accountFlexVO.getFlexField()));
                continue;
            }
            values.add(0L);
        }
        LocalDate endLocalDate = Instant.ofEpochMilli(this.expiredate.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate startLocalDate = this.showByExpireDate ? Instant.ofEpochMilli(unWriteOffVO.getExpireDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDate() : Instant.ofEpochMilli(unWriteOffVO.getBizDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        long daysBetween = ChronoUnit.DAYS.between(startLocalDate, endLocalDate);
        BigDecimal overduetotal = BigDecimal.ZERO;
        BigDecimal overduetotallocal = BigDecimal.ZERO;
        BigDecimal unduetotal = BigDecimal.ZERO;
        BigDecimal unduetotallocal = BigDecimal.ZERO;
        for (AgeRangeVO rangeVO : this.rangeVOs) {
            if (rangeVO.isDue()) {
                if (daysBetween <= (long)rangeVO.getEnd() && daysBetween >= (long)rangeVO.getStart() || daysBetween >= (long)rangeVO.getStart() && rangeVO.getEnd() == 0) {
                    values.add(unWriteOffVO.getLeavingAmountFor());
                    values.add(unWriteOffVO.getLeavingAmount());
                    overduetotal = overduetotal.add(unWriteOffVO.getLeavingAmountFor());
                    overduetotallocal = overduetotallocal.add(unWriteOffVO.getLeavingAmount());
                    continue;
                }
                values.add(BigDecimal.ZERO);
                values.add(BigDecimal.ZERO);
                continue;
            }
            if (daysBetween >= (long)rangeVO.getEnd() && daysBetween <= (long)rangeVO.getStart() || daysBetween <= (long)rangeVO.getStart() && rangeVO.getEnd() == 0) {
                values.add(unWriteOffVO.getLeavingAmountFor());
                values.add(unWriteOffVO.getLeavingAmount());
                unduetotal = unduetotal.add(unWriteOffVO.getLeavingAmountFor());
                unduetotallocal = unduetotallocal.add(unWriteOffVO.getLeavingAmount());
                continue;
            }
            values.add(BigDecimal.ZERO);
            values.add(BigDecimal.ZERO);
        }
        values.add(overduetotal);
        values.add(overduetotallocal);
        values.add(unduetotal);
        values.add(unduetotallocal);
        values.add(overduetotal.add(unduetotal));
        values.add(overduetotallocal.add(unduetotallocal));
        if (Objects.isNull(this.sumAssistData) || this.sumAssistData.length == 0) {
            this.sumAssistData = values.toArray();
        } else {
            for (Integer index : this.sumIndexFileds) {
                this.sumAssistData[index.intValue()] = ((BigDecimal)this.sumAssistData[index]).add((BigDecimal)values.get(index));
            }
        }
    }

    private Object[] comAssgrpKey(ReciprocalRecord unWriteOffVO) {
        ArrayList<Object> keys = new ArrayList<Object>(this.acctFlexVOs.size() + 3);
        keys.add(unWriteOffVO.getOrg());
        keys.add(unWriteOffVO.getAccount());
        keys.add(unWriteOffVO.getCurrency());
        for (AccountFlexVO accountFlexVO : this.acctFlexVOs) {
            keys.add(unWriteOffVO.getAssgrpVals().get(accountFlexVO.getFlexField()));
        }
        return keys.toArray();
    }
}

