/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.voucher;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.gl.interfaces.service.voucher.IVoucherQueryService;

public class VoucherQueryServiceImpl
implements IVoucherQueryService {
    @Override
    public DataSet queryByIds(Set<Long> voucherIds, QFilter[] filters, String selectFields, String orderBys) {
        ArrayList filterList = Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "in", voucherIds)});
        MainEntityType voucherType = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
        if (StringUtils.isNotEmpty((String)selectFields) && selectFields.contains("entries.") || StringUtils.isNotEmpty((String)orderBys) && orderBys.contains("entries.")) {
            voucherType = this.addEntryVoucherIdProp(voucherType);
            filterList.add(new QFilter("entries.voucherid", "in", voucherIds));
        }
        ORM orm = ORM.create();
        orm.setDataEntityType("gl_voucher", (IDataEntityType)voucherType);
        if (ArrayUtils.isNotEmpty((Object[])filters)) {
            filterList.addAll(Arrays.asList(filters));
        }
        try (ShardingHintContext ignored = this.buildShardingHintContext(voucherIds).prepareShardingIndex();){
            DataSet dataSet = orm.queryDataSet(this.getClass().getName(), "gl_voucher", selectFields, filterList.toArray(new QFilter[0]), orderBys);
            return dataSet;
        }
    }

    protected MainEntityType addEntryVoucherIdProp(MainEntityType voucherType) {
        if (voucherType == null) {
            return null;
        }
        try {
            voucherType = (MainEntityType)voucherType.clone();
            if (voucherType != null) {
                LongProp voucherIdProp = new LongProp();
                voucherIdProp.setAlias("fid");
                voucherIdProp.setName("voucherid");
                voucherIdProp.setDefaultValue((Object)0L);
                EntryProp entryProp = (EntryProp)voucherType.getProperty("entries");
                EntryType entryType = (EntryType)entryProp.getItemType();
                entryType.registerSimpleProperty((DynamicSimpleProperty)voucherIdProp);
            }
            return voucherType;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ShardingHintContext buildShardingHintContext(Collection<Long> voucherIds) {
        return ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, voucherIds)});
    }
}

