/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.voucher;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.interfaces.service.voucher.IVoucherQueryService;
import kd.fi.gl.interfaces.service.voucher.IVoucherStatusService;
import kd.fi.gl.util.iter.SplitIterator;

public class VoucherStatusServiceImpl
implements IVoucherStatusService {
    protected IVoucherQueryService getQueryService() {
        return GLServiceFactory.getService(IVoucherQueryService.class);
    }

    @Override
    public Set<Long> getCheckedVoucherIds(Collection<Long> voucherIds) {
        if (CollectionUtils.isEmpty(voucherIds)) {
            return new HashSet<Long>(1);
        }
        SplitIterator<Long> splitIterator = new SplitIterator<Long>(voucherIds.iterator(), 1000);
        HashSet<Long> results = new HashSet<Long>(16);
        while (splitIterator.hasNext()) {
            DataSet vouchers = this.getQueryService().queryByIds(new HashSet<Long>((Collection<Long>)splitIterator.next()), new QFilter("ischeck", "=", (Object)"c").toArray(), "id", null);
            Throwable throwable = null;
            try {
                for (Row row : vouchers) {
                    results.add(row.getLong(0));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (vouchers == null) continue;
                if (throwable != null) {
                    try {
                        vouchers.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                vouchers.close();
            }
        }
        return results;
    }
}

