/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.voucher.option.helper;

import java.util.Optional;
import kd.bos.cache.ThreadCache;
import kd.fi.gl.business.dao.voucher.option.VoucherArgConfigDAO;
import kd.fi.gl.business.service.voucher.option.cfg.VoucherArgConfig;
import kd.fi.gl.business.service.voucher.option.key.ArgKey;
import kd.fi.gl.cache.ThreadCacheKey;

public class VoucherArgConfigServiceHelper {
    public static <T> T getArgValue(long orgId, long userId, ArgKey key) {
        return VoucherArgConfigServiceHelper.get(orgId, userId).getArgValue(key);
    }

    public static VoucherArgConfig get(long orgId, long userId) {
        return (VoucherArgConfig)ThreadCache.get((Object)ThreadCacheKey.buildVoucherOptionKey(VoucherArgConfig.class.getSimpleName(), orgId, userId), () -> VoucherArgConfigServiceHelper.query(orgId, userId));
    }

    public static void save(VoucherArgConfig config) {
        VoucherArgConfigDAO.save(config);
    }

    public static void setDefault(VoucherArgConfig config) {
        VoucherArgConfigDAO.setDefault(config);
    }

    private static VoucherArgConfig query(long orgId, long userId) {
        Optional<VoucherArgConfig> config = VoucherArgConfigDAO.tryLoad(orgId, userId);
        if (config.isPresent()) {
            return config.get();
        }
        config = VoucherArgConfigDAO.tryLoadDefault(userId);
        return config.orElseGet(() -> VoucherArgConfigDAO.create(orgId, userId));
    }
}

