/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.cashflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class CashFlowInitExecutor {
    public static final Log logger = LogFactory.getLog(CashFlowInitExecutor.class);

    public static HashMap<String, Object> batchInit(String opKey, String orgstr, long booksTypeId) {
        HashMap<String, Object> batchInitresult = new HashMap<String, Object>(8);
        List orgs = Arrays.stream(orgstr.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        CashFlowInitExecutor.updateResultMap(batchInitresult, 0, 0, "", false);
        batchInitresult.put("opkey", opKey);
        if (!StringUtils.isBlank((CharSequence)opKey) && null != orgs && orgs.size() != 0) {
            QFilter booksTypeFiter = new QFilter("bookstype", "=", (Object)booksTypeId);
            HashMap orgNameError = new HashMap(orgs.size());
            StringBuilder errorMsg = new StringBuilder(orgNameError.size());
            QFilter orgF = new QFilter("org", "in", orgs);
            DynamicObjectCollection accountbooks = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{orgF, booksTypeFiter});
            if (null != accountbooks && accountbooks.size() > 0) {
                ArrayList<Long> ids = new ArrayList<Long>(accountbooks.size());
                for (DynamicObject book : accountbooks) {
                    ids.add(book.getLong("id"));
                }
                DynamicObject[] datas = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_endinit"));
                OperationResult result = OperationServiceHelper.executeOperate((String)opKey, (String)"gl_endinit", (DynamicObject[])datas, (OperateOption)OperateOption.create());
                List successPkIds = result.getSuccessPkIds();
                if (!result.isSuccess()) {
                    ValidateResultCollection validateResult = result.getValidateResult();
                    HashSet errorPkIds = validateResult.getErrorPkIds();
                    List validateErrors = validateResult.getValidateErrors();
                    for (ValidateResult info : validateErrors) {
                        List allErrorInfo = info.getAllErrorInfo();
                        for (OperateErrorInfo errorInfo : allErrorInfo) {
                            errorMsg.append(errorInfo.getMessage());
                            errorMsg.append("\n");
                        }
                    }
                    int errorPkSize = errorPkIds.size();
                    if (StringUtils.isBlank((CharSequence)errorMsg.toString())) {
                        errorMsg.append(result.getMessage());
                        errorPkSize += datas.length;
                    }
                    CashFlowInitExecutor.updateResultMap(batchInitresult, successPkIds.size(), errorPkSize + orgNameError.size(), errorMsg.toString(), false);
                    return batchInitresult;
                }
            }
            CashFlowInitExecutor.updateResultMap(batchInitresult, orgs.size(), orgNameError.size(), errorMsg.toString(), false);
            return batchInitresult;
        }
        return batchInitresult;
    }

    private static void updateResultMap(HashMap<String, Object> resultMap, int successCount, int errorCount, String errorMsg, boolean isSuccess) {
        resultMap.put("successcount", successCount);
        resultMap.put("faultcount", errorCount);
        resultMap.put("errormsg", errorMsg);
        resultMap.put("issuccess", isSuccess);
    }
}

