/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.cashflow;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.business.service.PeriodService;
import kd.fi.gl.cashflow.CashFlowQueryExecutor;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.util.DataSetUtils;
import kd.fi.gl.util.GLUtil;

class SQLCashFlowQueryExecutor
extends CashFlowQueryExecutor {
    private static final String AMOUNT = "amount";
    private static final String YEAR_AMOUNT = "yearamount";
    private static final String CFITEM_SELECTOR = "id,number, masterid, parent.masterid pmasterid, isleaf, direction";
    private Set<Long> LEAFCFITEMIDS = new HashSet<Long>();
    private Set<Long> CFITEMIDS = new HashSet<Long>();
    private DataSet ALLCFITEMSET;
    private static final String TAG_LEAF = "_tag_leaf";
    Log LOG = LogFactory.getLog(SQLCashFlowQueryExecutor.class);

    SQLCashFlowQueryExecutor() {
    }

    @Override
    public DataSet getCashFlow(String algoKey, String selector, long[] orgIds, long bookTypeId, long beginPeriodId, long endPeriodId, QFilter[] filter) {
        this.checkPeriod(beginPeriodId, endPeriodId);
        List<QFilter> qF = this.buildFilter(orgIds, bookTypeId, endPeriodId, filter);
        return this.getCashFlow(algoKey, selector, qF.toArray(new QFilter[qF.size()]), beginPeriodId, endPeriodId, null);
    }

    @Override
    public DataSet getCashFlowEntity(String algoKey, String selector, long[] orgIds, long bookTypeId, long beginPeriodId, long endPeriodId, QFilter[] filter, MainEntityType cashflowEntity) {
        this.checkPeriod(beginPeriodId, endPeriodId);
        List<QFilter> qF = this.buildFilter(orgIds, bookTypeId, endPeriodId, filter);
        return this.getCashFlow(algoKey, selector, qF.toArray(new QFilter[qF.size()]), beginPeriodId, endPeriodId, cashflowEntity);
    }

    private void checkPeriod(long beginPeriod, long endPeriod) {
        if (beginPeriod > endPeriod) {
            throw new GLException(GLErrorCode.beginPeriodCantMoreThanEndPeriod, new Object[0]);
        }
    }

    private List<QFilter> buildFilter(long[] orgIds, long bookTypeId, long endPeriodId, QFilter[] filters) {
        List<QFilter> qF = this.buildFilter(orgIds, bookTypeId, endPeriodId);
        if (filters != null) {
            List<QFilter> parseFilters = this.parseFilter(filters, orgIds[0], endPeriodId);
            qF.addAll(parseFilters);
        }
        return qF;
    }

    private List<QFilter> parseFilter(QFilter[] filters, long orgId, long endPeriodId) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        ArrayList<QFilter> cashFlowList = new ArrayList<QFilter>();
        for (QFilter filter : filters) {
            if (filter == null) continue;
            if (filter.getProperty().startsWith("cfitem")) {
                String cfitemProperty = filter.getProperty();
                Object refField = "";
                refField = "cfitem".equals(cfitemProperty) ? "id" : cfitemProperty.substring(7);
                cashFlowList.add(new QFilter((String)refField, filter.getCP(), filter.getValue()));
                continue;
            }
            list.add(filter);
        }
        if (!cashFlowList.isEmpty()) {
            DataSet cfitemIDSet = this.getCashFlowItem(CFITEM_SELECTOR, cashFlowList.toArray(new QFilter[0]), endPeriodId);
            for (Row row : cfitemIDSet) {
                this.CFITEMIDS.add(row.getLong("id"));
            }
            DataSet cfitemSet = this.getCashFlowItem(CFITEM_SELECTOR, new QFilter[]{new QFilter("id", "in", this.CFITEMIDS)}, endPeriodId);
            DataSet allLeafSet = this.getAllLeafCfitem(cfitemSet.copy(), cfitemSet, endPeriodId);
            if (null != allLeafSet) {
                QFilter baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
                HashSet<Long> idSet = new HashSet<Long>(64);
                for (Row row : allLeafSet) {
                    idSet.add(row.getLong("id"));
                }
                DataSet allCFSet = this.getCashFlowItem(CFITEM_SELECTOR, new QFilter[]{baseFilter, new QFilter("id", "in", idSet)}, endPeriodId);
                List<String> allLeafList = this.getFieldsByDs(allCFSet);
                this.ALLCFITEMSET = allCFSet.groupBy(allLeafList.toArray(new String[0])).finish();
                if (!this.LEAFCFITEMIDS.isEmpty()) {
                    QFilter filter = new QFilter("cfitem", "in", this.LEAFCFITEMIDS);
                    list.add(filter);
                }
            }
        }
        return list;
    }

    private DataSet sumCfitemData(DataSet cashFlowData, Map<String, String> groupSelectMap) {
        Field[] fields = cashFlowData.getRowMeta().getFields();
        HashSet<String> sumFieldSet = new HashSet<String>();
        HashSet<String> groupFieldSet = new HashSet<String>();
        ArrayList<String> selectSet = new ArrayList<String>(fields.length);
        HashSet<String> leftSelectSet = new HashSet<String>();
        for (Field field : fields) {
            String name = field.getName().toLowerCase();
            selectSet.add(name);
            if (!"cfitem".equalsIgnoreCase(name)) {
                leftSelectSet.add(name);
            }
            if (field.getDataType() instanceof BigDecimalType) {
                sumFieldSet.add(name);
                continue;
            }
            groupFieldSet.add(name);
        }
        String[] groupFields = groupFieldSet.toArray(new String[0]);
        String[] sumFields = sumFieldSet.toArray(new String[0]);
        String[] selector = selectSet.toArray(new String[0]);
        return this.accountSum(cashFlowData, groupFields, sumFields, selector, leftSelectSet, groupSelectMap);
    }

    private DataSet accountSum(DataSet cashFlowData, String[] groupFields, String[] sumFields, String[] selector, Set<String> leftSelector, Map<String, String> groupSelectMap) {
        DataSet ds;
        DataSet pacctDataSet = cashFlowData;
        DataSet sumDataSet = null;
        String cfitemAlias = groupSelectMap.get("cfitem");
        ArrayList<String> leftDc1 = new ArrayList<String>();
        leftDc1.addAll(leftSelector);
        leftDc1.removeIf(x -> x.equals("direction"));
        leftDc1.add("direction direction1");
        leftDc1.add(cfitemAlias);
        while ((ds = pacctDataSet.copy().join(this.ALLCFITEMSET.copy(), JoinType.INNER).on(cfitemAlias, "masterid").select(leftSelector.toArray(new String[0]), new String[]{"pmasterid " + cfitemAlias}).finish().filter(cfitemAlias + "!=0")).hasNext()) {
            ds = ds.join(this.ALLCFITEMSET.copy(), JoinType.INNER).on(cfitemAlias, "masterid").select(leftDc1.toArray(new String[0]), new String[]{"direction"}).finish().filter(cfitemAlias + "!=0");
            GroupbyDataSet group = ds.groupBy(groupFields);
            GroupbyDataSet groupbyDataSet = sumFields;
            int n = ((GroupbyDataSet)groupbyDataSet).length;
            for (int i = 0; i < n; ++i) {
                GroupbyDataSet sumField = groupbyDataSet[i];
                String sumStr = "case when (direction='b' and direction1='o') then " + (String)sumField + "*(-1) else " + (String)sumField + " end";
                group.sum(sumStr, (String)sumField);
            }
            pacctDataSet = group.finish().select(selector);
            sumDataSet = sumDataSet == null ? pacctDataSet : sumDataSet.union(pacctDataSet);
        }
        if (sumDataSet != null) {
            GroupbyDataSet group = sumDataSet.groupBy(groupFields);
            for (String sumField : sumFields) {
                group.sum(sumField);
            }
            sumDataSet = group.finish().select(selector);
            List<String> cols = GLUtil.getDataSetCols(cashFlowData);
            sumDataSet = sumDataSet.select(cols.toArray(new String[0]));
            return cashFlowData.addField("true", TAG_LEAF).union(sumDataSet.addField("false", TAG_LEAF));
        }
        return cashFlowData.addField("true", TAG_LEAF);
    }

    private DataSet getAllLeafCfitem(DataSet levelCfitemSet, DataSet dataSet, long endPeriodId) {
        HashSet<Long> pSet = new HashSet<Long>();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            long masterId = row.getLong("masterid");
            this.LEAFCFITEMIDS.add(masterId);
            if (row.getBoolean("isleaf").booleanValue()) continue;
            pSet.add(row.getLong("id"));
            pSet.add(masterId);
        }
        QFilter qFilter = new QFilter("parent", "in", pSet);
        DataSet ds = this.getCashFlowItem(CFITEM_SELECTOR, new QFilter[]{qFilter}, endPeriodId);
        if (levelCfitemSet != null) {
            levelCfitemSet = levelCfitemSet.union(ds.copy());
        }
        if (ds.hasNext()) {
            return this.getAllLeafCfitem(levelCfitemSet, ds, endPeriodId);
        }
        return levelCfitemSet;
    }

    private DataSet getCashFlowItem(String sel, QFilter[] filters, long periodId) {
        Date periodEndDate = PeriodService.getEndDate(periodId);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(Arrays.asList(filters));
        filterList.add(new QFilter("startdate", "<=", (Object)periodEndDate));
        filterList.add(new QFilter("enddate", ">", (Object)periodEndDate));
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_cashflowitem", (String)sel, (QFilter[])filterList.toArray(new QFilter[0]), null);
    }

    private List<QFilter> buildFilter(long[] orgIds, long bookTypeId, long endPeriodId) {
        ArrayList<QFilter> qF = new ArrayList<QFilter>();
        qF.add(new QFilter("booktype", "=", (Object)bookTypeId));
        qF.add(new QFilter("org", "in", (Object)orgIds));
        QFilter fPeriod = new QFilter("period", "<=", (Object)endPeriodId);
        qF.add(fPeriod);
        return qF;
    }

    private DataSet getCashFlow(String algoKey, String selector, QFilter[] filters, long beginPeriodId, long endPeriodId, MainEntityType cashflowEntity) {
        if (DebugTrace.enable()) {
            this.LOG.info(String.format("\u73b0\u91d1\u6d41\u91cf\u63a5\u53e3\u53c2\u6570\uff1aselector:%s,filters:%s,beginPeriodId:%s,endPeriodId:%s,MaintEntityType:%s", selector, filters, beginPeriodId, endPeriodId, cashflowEntity));
        }
        StringBuilder aliasField = new StringBuilder();
        HashMap<String, String> sumSelectMap = new HashMap<String, String>();
        HashMap<String, String> groupSelectMap = new HashMap<String, String>();
        StringBuffer groupByField = new StringBuffer();
        if (!selector.contains("cfitem.direction")) {
            selector = selector + ",cfitem.direction direction";
        }
        String[] strField = selector.split(",");
        LinkedHashSet<String> selectSet = new LinkedHashSet<String>(strField.length);
        for (int i = 0; i < strField.length; ++i) {
            String field = strField[i].trim();
            selectSet.add(field);
            PropertyField pField = new PropertyField(field);
            String name = pField.getName();
            String alias = pField.getAlias();
            aliasField.append(alias).append(",");
            if (AMOUNT.equals(name) || YEAR_AMOUNT.equals(name) || "count".equals(name)) {
                sumSelectMap.put(name, alias);
                continue;
            }
            groupByField.append(alias).append(",");
            groupSelectMap.put(name, alias);
        }
        if (StringUtils.isNotBlank((CharSequence)selector)) {
            if (!selectSet.contains("period")) {
                selector = selector + ",period";
            }
            if (!selectSet.contains("endperiod")) {
                selector = selector + ",endperiod";
            }
            selector = selector + ",period.periodyear endyear";
        }
        DataSet cashFlowData = this.getCashflowData(algoKey, filters, cashflowEntity, selector);
        if (StringUtils.isNotBlank((CharSequence)groupByField)) {
            GroupbyDataSet group = cashFlowData.groupBy(groupByField.toString().split(","));
            for (Map.Entry entry : sumSelectMap.entrySet()) {
                String name = (String)entry.getKey();
                String alias = (String)entry.getValue();
                if (AMOUNT.equals(name)) {
                    String string = "case when period >=" + beginPeriodId + " then " + alias + " else 0.0 end";
                    group.sum(string, alias);
                    continue;
                }
                if (YEAR_AMOUNT.equals(name)) {
                    String string = "case when endperiod >" + endPeriodId + " and period <=" + endPeriodId + " and (period >" + endPeriodId / GLUtil.YEAR_PERIOD_L * GLUtil.YEAR_PERIOD_L + ") then " + alias + " else 0.0 end";
                    group.sum(string, alias);
                    continue;
                }
                if ("count".equals(name)) {
                    String string = "case when period =" + beginPeriodId + " then " + alias + " else 0 end";
                    group.sum(string, alias);
                    continue;
                }
                group.sum(alias);
            }
            cashFlowData = group.finish();
        }
        List<String> selList = this.getFieldsByDs(cashFlowData);
        if (groupSelectMap.get("cfitem") != null) {
            String cfitemAlias = (String)groupSelectMap.get("cfitem");
            cashFlowData = this.sumCfitemData(cashFlowData, groupSelectMap);
            DataSet acctDataSet = this.getCashFlowItem(CFITEM_SELECTOR, new QFilter[]{new QFilter("id", "in", this.CFITEMIDS)}, endPeriodId);
            selList.remove(cfitemAlias);
            cashFlowData = cashFlowData.join(acctDataSet, JoinType.INNER).on(cfitemAlias, "masterid").select(selList.toArray(new String[0]), new String[]{"id " + cfitemAlias}).finish();
        }
        cashFlowData = cashFlowData.select(aliasField.toString().split(","));
        long[] orgIds = new long[]{};
        long bookTypeId = 0L;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        for (QFilter filter : filters) {
            if ("org".equals(filter.getProperty())) {
                orgIds = (long[])filter.getValue();
                continue;
            }
            if ("booktype".equals(filter.getProperty())) {
                bookTypeId = (Long)filter.getValue();
                continue;
            }
            if (!filter.getProperty().contains("comassist")) continue;
            qFilters.add(filter);
        }
        String string = StringUtils.join((Object[])DataSetUtils.getFields(cashFlowData).toArray(), (String)",");
        if (string.contains(YEAR_AMOUNT)) {
            for (long org : orgIds) {
                DataSet ds;
                Tuple<Long, DataSet> profitCashflow = this.getProfitCashflow(org, bookTypeId, endPeriodId, qFilters, cashFlowData.getRowMeta(), filters);
                if (profitCashflow == null) continue;
                Long profitItem = (Long)profitCashflow.item1;
                DataSet profitCashflowData = (DataSet)profitCashflow.item2;
                String filterStr = "cfitem = " + profitItem;
                if (selector.contains("org")) {
                    filterStr = filterStr + " and org = " + org;
                }
                if ((ds = cashFlowData.copy().filter(filterStr)).isEmpty()) {
                    cashFlowData = cashFlowData.union(profitCashflowData);
                    continue;
                }
                JoinDataSet joinDs = cashFlowData.join(profitCashflowData, JoinType.LEFT).on("cfitem", "cfitem");
                if (selector.contains("org")) {
                    joinDs = joinDs.on("org", "org");
                }
                cashFlowData = joinDs.select(string.split(","), new String[]{"yearamount profityearamount"}).finish();
                cashFlowData = cashFlowData.select(string.replace(YEAR_AMOUNT, "(yearamount + profityearamount) yearamount"));
            }
        }
        return cashFlowData;
    }

    private List<String> getFieldsByDs(DataSet dataSet) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (dataSet != null) {
            Field[] fields;
            for (Field field : fields = dataSet.getRowMeta().getFields()) {
                fieldNames.add(field.getAlias());
            }
        }
        return fieldNames;
    }

    private DataSet getCashflowData(String algoKey, QFilter[] filters, MainEntityType cashflowEntity, String querySelector) {
        DataSet cashflow;
        if (cashflowEntity != null) {
            ORM orm = ORM.create();
            orm.setDataEntityType("gl_cashflow", (IDataEntityType)cashflowEntity);
            cashflow = orm.queryDataSet(algoKey, "gl_cashflow", querySelector, filters);
        } else {
            cashflow = QueryServiceHelper.queryDataSet((String)algoKey, (String)"gl_cashflow", (String)querySelector, (QFilter[])filters, null);
        }
        return cashflow;
    }

    private Tuple<Long, DataSet> getProfitCashflow(long org, long bookType, long period, List<QFilter> qFilters, RowMeta rowMeta, QFilter[] filters) {
        boolean isCurrYear;
        QFilter orgQf = new QFilter("org", "=", (Object)org);
        QFilter bookTypeQf = new QFilter("bookstype", "=", (Object)bookType);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"cashinitperiod", (QFilter[])new QFilter[]{orgQf, bookTypeQf});
        Long cashIitPeriod = dynamicObject.getLong("cashinitperiod");
        boolean bl = isCurrYear = cashIitPeriod / GLUtil.YEAR_PERIOD_L == period / GLUtil.YEAR_PERIOD_L;
        if (isCurrYear) {
            Long profitItem = 0L;
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)org);
            DynamicObject prefitDyn = QueryServiceHelper.queryOne((String)"gl_cashflowitem", (String)"masterid", (QFilter[])new QFilter[]{new QFilter("isprefit", "=", (Object)true), orgFilter});
            if (prefitDyn != null) {
                profitItem = prefitDyn.getLong("masterid");
            }
            if (profitItem != 0L) {
                for (QFilter qFilter : filters) {
                    String value;
                    if (!"cfitem".equals(qFilter.getProperty()) || (value = qFilter.getValue().toString()).contains(profitItem.toString())) continue;
                    return null;
                }
                StringBuilder selector = new StringBuilder("org,account,beginlocal,endlocal,yeardebitlocal,yearcreditlocal");
                QueryParam param = new QueryParam();
                QFilter accountFilter = new QFilter("accounttype.accounttype", "=", (Object)"4");
                param.setAccountFilter(accountFilter);
                param.setOnlyLeafAcctBal(Boolean.TRUE.booleanValue());
                param.setSubstractPL(Boolean.TRUE.booleanValue());
                param.getCustomFilter().addAll(qFilters);
                DataSet balanceDs = BalanceQueryExecutor.getInstance().getBalance(selector.toString(), new Long[]{org}, bookType, SQLCashFlowQueryExecutor.getAccounttableIdByOrg(org, bookType).longValue(), cashIitPeriod.longValue(), cashIitPeriod.longValue(), param);
                balanceDs = balanceDs.groupBy(new String[]{"org"}).sum("beginlocal").sum("endlocal").sum("yeardebitlocal").sum("yearcreditlocal").finish();
                BigDecimal profitAmount = BigDecimal.ZERO;
                while (balanceDs.hasNext()) {
                    Row row = balanceDs.next();
                    this.LOG.info("getProfitCashflow balanceDs row : " + row.toString());
                    BigDecimal yearAmount = row.getBigDecimal("yearcreditlocal").subtract(row.getBigDecimal("yeardebitlocal"));
                    BigDecimal amount = row.getBigDecimal("endlocal").subtract(row.getBigDecimal("beginlocal"));
                    profitAmount = profitAmount.add(yearAmount.add(amount));
                }
                this.LOG.info("getProfitCashflow profitAmount: " + profitAmount);
                ArrayList<Object[]> objs = new ArrayList<Object[]>(1);
                Field[] fields = rowMeta.getFields();
                Object[] objects = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if ("org".equals(field.getAlias())) {
                        objects[i] = org;
                        continue;
                    }
                    if ("cfitem".equals(field.getAlias())) {
                        objects[i] = profitItem;
                        continue;
                    }
                    if (YEAR_AMOUNT.equals(field.getAlias())) {
                        objects[i] = profitAmount;
                        continue;
                    }
                    if (!AMOUNT.equals(field.getAlias())) continue;
                    objects[i] = BigDecimal.ZERO;
                }
                objs.add(objects);
                DataSet profitBalance = Algo.create((String)this.getClass().getName()).createDataSet(objs.iterator(), rowMeta);
                return new Tuple<Long, DataSet>(profitItem, profitBalance);
            }
        }
        return null;
    }

    public static Long getAccounttableIdByOrg(long orgId, Long bookTypeId) {
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter bookTypeQf = new QFilter("bookstype", "=", (Object)bookTypeId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"accounttable", (QFilter[])new QFilter[]{orgQf, bookTypeQf});
        return dyn.getLong("accounttable");
    }
}

