/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.checktools;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.ai.FIDataCheckTask;
import kd.bos.ext.fi.util.FIDataCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.util.BalanceCheckHelper;

public class BalanceCheckTask
implements FIDataCheckTask {
    private static final Log logger = LogFactory.getLog((String)"kd.fi.gl.checktools.BalanceCheckTask");

    public boolean execute() {
        List endList;
        if (FIDataCheckUtil.isStop()) {
            return false;
        }
        String tenantId = RequestContext.get().getTenantId();
        if (tenantId.equals("agilepre") || tenantId.equals("pretest")) {
            return true;
        }
        boolean checkResult = true;
        StringBuilder bal = new StringBuilder();
        this.checkBalCurPeriod(bal);
        if (bal.length() > 0) {
            FIDataCheckUtil.saveResult((String)"balancecheck", (String)"gl", (boolean)false, (String)ResManager.loadKDString((String)"\u79d1\u76ee\u4f59\u989d\u51fa\u73b0\u672c\u671f\u4f59\u989d\u6570\u636e\u4e0d\u5bf9\u3002", (String)"BalanceCheckTask_0", (String)"fi-gl-common", (Object[])new Object[0]), (String)"kd.fi.gl.checktools.BalanceCheckTask");
            checkResult = false;
            logger.info("balanceerrinfo:{}", (Object)bal.toString());
        }
        StringBuilder cf = new StringBuilder();
        this.checkCfBalCurPeriod(cf);
        if (cf.length() > 0) {
            FIDataCheckUtil.saveResult((String)"balancecheck", (String)"gl", (boolean)false, (String)ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u51fa\u73b0\u672c\u671f\u4f59\u989d\u6570\u636e\u4e0d\u5bf9\u3002", (String)"BalanceCheckTask_1", (String)"fi-gl-common", (Object[])new Object[0]), (String)"kd.fi.gl.checktools.BalanceCheckTask");
            checkResult = false;
            logger.info("cferrinfo:{}", (Object)cf.toString());
        }
        Tuple<List<Long>, List<Long>> tuple = this.checkYearBal();
        List yearList = (List)tuple.item1;
        if (!yearList.isEmpty()) {
            FIDataCheckUtil.saveResult((String)"balancecheck", (String)"gl", (boolean)false, (String)ResManager.loadKDString((String)"\u79d1\u76ee\u672c\u5e74\u7d2f\u8ba1\u6570\u636e\u4e0d\u5bf9\u3002", (String)"BalanceCheckTask_2", (String)"fi-gl-common", (Object[])new Object[0]), (String)"kd.fi.gl.checktools.BalanceCheckTask");
            checkResult = false;
            logger.info("balerryearinfo:{}", (Object)yearList.toString());
        }
        if (!(endList = (List)tuple.item2).isEmpty()) {
            FIDataCheckUtil.saveResult((String)"balancecheck", (String)"gl", (boolean)false, (String)ResManager.loadKDString((String)"\u79d1\u76ee\u671f\u521d\u671f\u672b\u6570\u636e\u4e0d\u5bf9\u3002", (String)"BalanceCheckTask_3", (String)"fi-gl-common", (Object[])new Object[0]), (String)"kd.fi.gl.checktools.BalanceCheckTask");
            checkResult = false;
            logger.info("balerryearinfo:{}", (Object)endList.toString());
        }
        return checkResult;
    }

    private void checkCfBalCurPeriod(StringBuilder sb) {
        try {
            DynamicObjectCollection col = BalanceCheckHelper.getAllBooks(null);
            ArrayList<String> err = new ArrayList<String>(100);
            for (DynamicObject book : col) {
                if (FIDataCheckUtil.isStop()) break;
                long org = book.getLong("org");
                long bt = book.getLong("bookstype");
                long curPeriod = book.getLong("curperiod");
                long baseCurrencyId = book.getLong("basecurrency");
                err.addAll(BalanceCheckHelper.checkCfitemFlow(org, bt, baseCurrencyId, curPeriod));
            }
            if (!err.isEmpty()) {
                err.stream().forEach(a -> sb.append("cf-id:").append((String)a).append(";"));
            }
        }
        catch (Exception e) {
            logger.error("###### gl-acct-balance execute error!" + e.getMessage());
        }
    }

    private void checkBalCurPeriod(StringBuilder sb) {
        try {
            DynamicObjectCollection col = BalanceCheckHelper.getAllBooks(null);
            ArrayList<String> err = new ArrayList<String>(100);
            for (DynamicObject book : col) {
                if (FIDataCheckUtil.isStop()) break;
                long org = book.getLong("org");
                long bt = book.getLong("bookstype");
                long curPeriod = book.getLong("curperiod");
                err.addAll(BalanceCheckHelper.checkBalPeriod(org, bt, curPeriod, curPeriod));
            }
            if (!err.isEmpty()) {
                err.stream().forEach(a -> sb.append((String)a));
            }
        }
        catch (Exception e) {
            logger.error("###### gl-acct-balance execute error!" + e.getMessage());
        }
    }

    public Tuple<List<Long>, List<Long>> checkYearBal() {
        DynamicObjectCollection books = BalanceCheckHelper.getAllBooks(null);
        String sel = "id,org,booktype,comassist1,comassist2,period,endperiod,accounttable,account,assgrp,currency,measureunit,beginlocal,debitlocal,creditlocal,yeardebitlocal,yearcreditlocal,endlocal";
        String orderBy = "org,booktype,comassist1,comassist2,account,assgrp,currency,measureunit,period";
        ArrayList<Long> yearIds = new ArrayList<Long>(10);
        ArrayList<Long> endIds = new ArrayList<Long>(10);
        for (DynamicObject obj : books) {
            long orgId = obj.getLong("org");
            long btId = obj.getLong("bookstype");
            long curperiod = obj.getLong("curperiod");
            QFilter forg = new QFilter("org", "=", (Object)orgId);
            QFilter fbt = new QFilter("booktype", "=", (Object)btId);
            QFilter fperiodid = new QFilter("endperiod", ">=", (Object)curperiod);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"checkallbal", (String)"gl_balance", (String)sel, (QFilter[])new QFilter[]{forg, fbt, fperiodid}, (String)orderBy);
            Throwable throwable = null;
            try {
                String key = "";
                String lastKey = "";
                boolean check = false;
                BigDecimal yearDL = BigDecimal.ZERO;
                BigDecimal yearCL = BigDecimal.ZERO;
                BigDecimal preEndBal = BigDecimal.ZERO;
                long prePid = 0L;
                for (Row row : ds) {
                    key = this.buildAcctKey(row);
                    long period = row.getLong("period");
                    if (!key.equals(lastKey)) {
                        check = false;
                    } else {
                        lastKey = key;
                        if (check) continue;
                        if (prePid / 10000L == period / 10000L && (row.getBigDecimal("debitlocal").add(yearDL).compareTo(row.getBigDecimal("yeardebitlocal")) != 0 || row.getBigDecimal("creditlocal").add(yearCL).compareTo(row.getBigDecimal("yearcreditlocal")) != 0)) {
                            yearIds.add(row.getLong("id"));
                            check = true;
                            continue;
                        }
                        if (prePid / 10000L != period / 10000L && (row.getBigDecimal("debitlocal").compareTo(row.getBigDecimal("yeardebitlocal")) != 0 || row.getBigDecimal("creditlocal").compareTo(row.getBigDecimal("yearcreditlocal")) != 0)) {
                            yearIds.add(row.getLong("id"));
                            check = true;
                            continue;
                        }
                        if (preEndBal.compareTo(row.getBigDecimal("beginlocal")) != 0) {
                            endIds.add(row.getLong("id"));
                            check = true;
                            continue;
                        }
                    }
                    yearDL = row.getBigDecimal("yeardebitlocal");
                    yearCL = row.getBigDecimal("yearcreditlocal");
                    prePid = row.getLong("period");
                    preEndBal = row.getBigDecimal("endlocal");
                    lastKey = key;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        Tuple<List<Long>, List<Long>> tuple = new Tuple<List<Long>, List<Long>>();
        tuple.item1 = yearIds;
        tuple.item2 = endIds;
        return tuple;
    }

    private String buildAcctKey(Row row) {
        return String.join((CharSequence)"-", row.getString("org"), row.getString("booktype"), row.getString("account"), row.getString("comassist1"), row.getString("comassist2"), row.getString("assgrp"), row.getString("currency"), row.getString("measureunit"));
    }
}

