/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeperiod.breakpoint;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.accsys.AccSysUtil;

public class OrgBooktypePeriod
implements Serializable {
    private Long orgId = 0L;
    private Long booktypeId = 0L;
    private Long periodId = 0L;
    private String bookName;
    private boolean checked;
    private Map<Long, Long> bookTypePeriod = new HashMap<Long, Long>();

    public OrgBooktypePeriod() {
    }

    public OrgBooktypePeriod(Long orgId) {
        this.orgId = orgId;
        this.initBookPeriod();
    }

    public OrgBooktypePeriod(Long orgId, Long booktypeId, Long periodId) {
        this.orgId = orgId;
        this.booktypeId = booktypeId;
        this.periodId = periodId;
        this.initBookPeriod();
    }

    private void initBookPeriod() {
        if (this.bookTypePeriod.isEmpty()) {
            List<DynamicObject> allBookDynFromAccSys = AccSysUtil.getAllBookDynFromAccSys(this.getOrgId(), String.join((CharSequence)",", "bookstype", "curperiod"));
            this.bookTypePeriod = allBookDynFromAccSys.stream().collect(Collectors.toMap(dyn -> dyn.getLong("bookstype"), dyn -> dyn.getLong("curperiod")));
            if (this.booktypeId == 0L) {
                this.booktypeId = allBookDynFromAccSys.size() >= 1 ? allBookDynFromAccSys.get(0).getLong("bookstype") : 0L;
            }
        }
    }

    public Map<Long, Long> getBookTypePeriod() {
        return this.bookTypePeriod;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getBooktypeId() {
        Optional first = this.bookTypePeriod.keySet().stream().findFirst();
        Long temp = Long.valueOf("0");
        if (first.isPresent()) {
            temp = (Long)first.get();
        }
        return this.booktypeId == 0L ? temp : this.booktypeId;
    }

    public void setBooktypeId(Long booktypeId) {
        this.booktypeId = booktypeId;
    }

    @Deprecated
    public Long getPeriodId() {
        Optional first = this.bookTypePeriod.keySet().stream().findFirst();
        Long temp = Long.valueOf("0");
        if (first.isPresent()) {
            temp = this.bookTypePeriod.get(first.get());
        }
        return this.periodId == 0L ? temp : this.periodId;
    }

    public Long getPeriodId(Long bookTypeId) {
        Long period = this.bookTypePeriod.getOrDefault(bookTypeId, 0L);
        return period.equals(0L) && !this.periodId.equals(0L) ? this.periodId : period;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public String getBookName() {
        return this.bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public String toString() {
        return "OrgBooktypePeriod{orgId=" + this.orgId + ", booktypeId=" + this.booktypeId + ", periodId=" + this.periodId + ", bookName='" + this.bookName + '\'' + ", checked=" + this.checked + '}';
    }
}

