/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeperiod.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.fcm.CheckContext;
import kd.bos.ext.fi.fcm.CheckResult;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.QFBuilder;

public class AcInitializeStatusChecker
implements IClosePeriodCheckPlugin {
    private static final String ENDINITPERIOD = "endinitperiod";
    private static final String ISENDINIT = "isendinit";

    public CheckResult execute(CheckContext context) throws Throwable {
        Long orgId = context.getOrgId();
        long bookTypeId = Long.parseLong(context.getSubBizAppId());
        Long periodId = context.getPeriodId();
        Set<String> accountNumbersUninitialized = AcInitializeStatusChecker.getUnInitAccountSet(orgId, bookTypeId, periodId);
        CheckResult result = new CheckResult();
        boolean success = accountNumbersUninitialized.isEmpty();
        result.setIsSuccess(success);
        ArrayList<String> msg = new ArrayList<String>(1);
        if (success) {
            msg.add(ResManager.loadKDString((String)"\u6240\u6709\u5f80\u6765\u79d1\u76ee\u5df2\u5b8c\u6210\u521d\u59cb\u5316\u3002", (String)"AcInitializeStatusChecker_0", (String)"fi-gl-common", (Object[])new Object[0]));
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u5b58\u5728\u5f80\u6765\u79d1\u76ee\u672a\u5b8c\u6210\u521d\u59cb\u5316:\n", (String)"AcInitializeStatusChecker_1", (String)"fi-gl-common", (Object[])new Object[0]));
            accountNumbersUninitialized.forEach(accountNumber -> sb.append((String)accountNumber).append("\n"));
            msg.add(sb.toString());
        }
        result.setMessages(msg);
        return result;
    }

    private static Set<String> getUnInitAccountSet(long orgId, long bookTypeId, long periodId) {
        HashSet<String> accountNumberSet = new HashSet<String>(8);
        long curPeriodAccountTableId = AccSysUtil.getCurPeriodAccountTableId(orgId, bookTypeId, periodId);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", periodId);
        DynamicObject periodDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)String.join((CharSequence)",", "begindate", "enddate"), (QFilter[])qfBuilder.toArray());
        if (Objects.isNull(periodDO)) {
            throw new GLException(GLErrorCode.common, String.format(ResManager.loadKDString((String)"ID\u201c%s\u201d\u5bf9\u5e94\u7684\u671f\u95f4\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u5df2\u88ab\u5220\u9664\u3002", (String)"ReciprocalUtils_11", (String)"fi-gl-common", (Object[])new Object[0]), periodId));
        }
        try (DataSet accountDataSet = AccountUtils.getAccountDataSet(orgId, curPeriodAccountTableId, periodDO.getDate("begindate"), periodDO.getDate("enddate"), true, new QFilter("accheck", "=", (Object)true), "masterid");){
            HashSet<String> hashSet;
            HashSet<Long> acAccountIds = new HashSet<Long>(10);
            for (Row row : accountDataSet) {
                acAccountIds.add(row.getLong("masterid"));
            }
            if (CollectionUtils.isEmpty(acAccountIds)) {
                hashSet = accountNumberSet;
                return hashSet;
            }
            qfBuilder.clear();
            qfBuilder.add("org", "=", orgId);
            qfBuilder.add("booktype", "=", bookTypeId);
            qfBuilder.add("account.masterid", "in", acAccountIds);
            try (DataSet reciprotalInitStates = QueryServiceHelper.queryDataSet((String)ReciprocalUtils.class.getName(), (String)"gl_reci_init_state", (String)String.join((CharSequence)",", "account.masterid", ISENDINIT, ENDINITPERIOD, "account.number"), (QFilter[])qfBuilder.toArray(), null);){
                for (Row row : reciprotalInitStates) {
                    if (row.getBoolean(ISENDINIT).booleanValue() || row.getLong(ENDINITPERIOD) > periodId) continue;
                    accountNumberSet.add(row.getString("account.number"));
                }
            }
            hashSet = accountNumberSet;
            return hashSet;
        }
    }
}

