/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeperiod.plugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.fcm.CheckContext;
import kd.bos.ext.fi.fcm.CheckResult;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.closeperiod.ClosePeriodUtils;

public class AccountTableExistsChecker
implements IClosePeriodCheckPlugin {
    private static final String ACCOUNTTABLE_ENABLE = "accounttable.enable";

    public CheckResult execute(CheckContext context) throws Throwable {
        CheckResult checkResult = new CheckResult();
        DynamicObject accountBook = ClosePeriodUtils.getAccountBook(context.getOrgId(), Long.valueOf(context.getSubBizAppId()), ACCOUNTTABLE_ENABLE);
        if (accountBook == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7ID%1$s\u4e0e\u8d26\u7c3f\u7c7b\u578bID%2$s\u5bf9\u5e94\u7684\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"AccountTableExistsChecker_0", (String)"fi-gl-common", (Object[])new Object[0]), String.valueOf(context.getOrgId()), String.valueOf(Long.valueOf(context.getSubBizAppId()))));
        }
        String enable = accountBook.getString(ACCOUNTTABLE_ENABLE);
        if (enable.equals("1")) {
            checkResult.setIsSuccess(true);
        } else {
            QFilter filter = new QFilter("id", "=", accountBook.getPkValue());
            filter.and("enable", "=", (Object)0);
            checkResult.setIsSuccess(false);
            checkResult.setOnlineQueryParams(filter.toSerializedString());
            checkResult.setOnlineViewId("bd_accounttable");
        }
        return checkResult;
    }
}

