/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeperiod.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.fcm.CheckContext;
import kd.bos.ext.fi.fcm.CheckResult;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;

public class PLAccountBalanceChecker
implements IClosePeriodCheckPlugin {
    private static final String KEY_ACCOUNTTYPE_ACCOUNTTYPE = "accounttype.accounttype";

    public CheckResult execute(CheckContext context) throws Throwable {
        AccountBookInfo bookFromAccSys = AccSysUtil.getBookFromAccSys(context.getOrgId(), Long.parseLong(context.getSubBizAppId()));
        long accountTableId = bookFromAccSys.getAccountTableId();
        QFilter accountFilter = new QFilter(KEY_ACCOUNTTYPE_ACCOUNTTYPE, "=", (Object)"4");
        QFilter baseDataIdInFilter = BaseDataServiceHelper.getBaseDataIdInFilter((String)"bd_accountview", (Long)context.getOrgId());
        QueryParam queryParam = new QueryParam();
        queryParam.setAccountFilter(accountFilter.and(baseDataIdInFilter));
        queryParam.setSpecialAccount(true);
        String selector = "endlocal,currency,assgrp";
        DataSet plBalacne = BalanceQueryExecutor.getInstance().getBalance(selector, new Long[]{context.getOrgId()}, Long.parseLong(context.getSubBizAppId()), accountTableId, context.getPeriodId().longValue(), context.getPeriodId().longValue(), queryParam);
        CheckResult checkResult = new CheckResult();
        checkResult.setIsSuccess(true);
        String msg = ResManager.loadKDString((String)"\u5b8c\u6210\u635f\u76ca\u7c7b\u79d1\u76ee\u7ed3\u8f6c\u3002", (String)"PLAccountBalanceChecker_0", (String)"fi-gl-common", (Object[])new Object[0]);
        for (Row row : plBalacne) {
            if (BigDecimal.ZERO.compareTo(row.getBigDecimal("endlocal")) == 0) continue;
            checkResult.setIsSuccess(false);
            msg = ResManager.loadKDString((String)"\u635f\u76ca\u7c7b\u79d1\u76ee\u4f59\u989d\u4e0d\u4e3a0\u3002", (String)"PLAccountBalanceChecker_1", (String)"fi-gl-common", (Object[])new Object[0]);
            break;
        }
        ArrayList<String> msgs = new ArrayList<String>(1);
        msgs.add(msg);
        checkResult.setMessages(msgs);
        return checkResult;
    }
}

