/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeperiod.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.fcm.CheckContext;
import kd.bos.ext.fi.fcm.CheckResult;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.fi.gl.util.GLUtil;

public class PeriodCheckoutChecker
implements IClosePeriodCheckPlugin {
    public CheckResult execute(CheckContext checkContext) throws Throwable {
        CheckResult checkResult = new CheckResult();
        Long orgId = checkContext.getOrgId();
        Long bookTypeId = Long.valueOf(checkContext.getSubBizAppId());
        List<Long> openPeriods = GLUtil.getOpenPeriod(orgId, bookTypeId);
        if (openPeriods.isEmpty()) {
            checkResult.setIsSuccess(true);
        } else {
            Long curPeriodId = checkContext.getPeriodId();
            List ids = openPeriods.stream().sorted().collect(Collectors.toList());
            if ((Long)ids.get(ids.size() - 1) < curPeriodId) {
                checkResult.setIsSuccess(false);
                checkResult.setOnlineViewId("gl_openedperiod");
                ArrayList<String> errorMsg = new ArrayList<String>(1);
                errorMsg.add(ResManager.loadKDString((String)"\u5386\u53f2\u5df2\u7ecf\u6253\u5f00\u7684\u671f\u95f4\u5fc5\u987b\u8981\u7ed3\u8d26\u3002", (String)"PeriodCheckoutChecker_0", (String)"fi-gl-common", (Object[])new Object[0]));
                checkResult.setMessages(errorMsg);
            } else {
                checkResult.setIsSuccess(true);
            }
        }
        return checkResult;
    }
}

