/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeperiod.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.fcm.CheckContext;
import kd.bos.ext.fi.fcm.CheckResult;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.util.QFBuilder;

public class VerifyResultCheckPlugin
implements IClosePeriodCheckPlugin {
    private static final String[] ICT_SERVICE_PARAM = new String[]{"fi", "ict", "VerifyStatisticsService", "getVerifyStatistics"};
    public static final String RESULT = "result";
    public static final String DIFF_AMOUNT = "diff_amount";
    public static final String DIFF_COUNT = "diff_count";
    public static final String ACCOUNT = "account";
    public static final String CASH_FLOW = "cash_flow";
    private static final String FORM_ICT_RELACCTRECORD = "ict_relacctrecord";
    private static final String FORM_ICT_RELCFRECORD = "ict_relcfrecord";
    private static final String FIELD_ORG = "org";
    private static final String FIELD_OPORG = "oporg";
    private static final String FIELD_BOOKTYPE = "booktype";
    private static final String FIELD_PERIOD = "period";
    private static final String FIELD_ACCOUNTTABLE = "accounttable";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_BILLSTATUS = "billstatus";

    public CheckResult execute(CheckContext context) {
        Long orgId = context.getOrgId();
        Long periodId = context.getPeriodId();
        String bookTypeId = context.getSubBizAppId();
        long curPeriodAccountTableId = AccSysUtil.getCurPeriodAccountTableId(orgId, Long.parseLong(bookTypeId), periodId);
        return this.toCheckResult(orgId, periodId, bookTypeId, curPeriodAccountTableId);
    }

    public CheckResult toCheckResult(Long orgId, Long periodId, String bookTypeId, long curPeriodAccountTableId) {
        String typeMsg = ResManager.loadKDString((String)"\u79d1\u76ee", (String)"VerifyResultCheckPlugin_0", (String)"fi-gl-common", (Object[])new Object[0]);
        List<String> errMsgList = this.checkResult(FORM_ICT_RELACCTRECORD, orgId, periodId, bookTypeId, curPeriodAccountTableId, typeMsg);
        typeMsg = ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf", (String)"VerifyResultCheckPlugin_1", (String)"fi-gl-common", (Object[])new Object[0]);
        errMsgList.addAll(this.checkResult(FORM_ICT_RELCFRECORD, orgId, periodId, bookTypeId, curPeriodAccountTableId, typeMsg));
        CheckResult checkResult = new CheckResult();
        checkResult.setIsSuccess(errMsgList.isEmpty());
        checkResult.setMessages(errMsgList);
        return checkResult;
    }

    public List<String> checkResult(String formKey, Long orgId, Long periodId, String bookTypeId, long curPeriodAccountTableId, String typeStr) {
        Set<Long> setOrgIds = this.getNoAlignedOrgSet(formKey, orgId, periodId, bookTypeId, curPeriodAccountTableId);
        Map<Long, String> orgNames = this.getOrgNames(setOrgIds);
        ArrayList<String> errMsgList = new ArrayList<String>(orgNames.size());
        orgNames.forEach((k, v) -> errMsgList.add(String.format(ResManager.loadKDString((String)"\u4e0e%1$s\u7ec4\u7ec7\u5185\u90e8\u4ea4\u6613%2$s\u7c7b\u5bf9\u8d26\u7ed3\u679c\u4e0d\u5e73\u3002", (String)"VerifyResultCheckPlugin_2", (String)"fi-gl-common", (Object[])new Object[0]), v, typeStr)));
        return errMsgList;
    }

    private Set<Long> getNoAlignedOrgSet(String formKey, Long orgId, Long periodId, String bookTypeId, long curPeriodAccountTableId) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(6);
        QFilter filterOrg = new QFilter(FIELD_ORG, "=", (Object)orgId);
        filterOrg.or(FIELD_OPORG, "=", (Object)orgId);
        filterList.add(filterOrg);
        filterList.add(new QFilter(FIELD_BOOKTYPE, "=", (Object)Long.valueOf(bookTypeId)));
        filterList.add(new QFilter(FIELD_PERIOD, "=", (Object)periodId));
        filterList.add(new QFilter(FIELD_STATUS, "in", Arrays.asList("0", "1")));
        filterList.add(new QFilter(FIELD_BILLSTATUS, "in", (Object)new String[]{"A", "B"}));
        if (FORM_ICT_RELACCTRECORD.equals(formKey)) {
            filterList.add(new QFilter(FIELD_ACCOUNTTABLE, "=", (Object)curPeriodAccountTableId));
        }
        DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), formKey, String.join((CharSequence)",", FIELD_ORG, FIELD_OPORG), filterList.toArray(new QFilter[0]), null, -1, (Distinctable)WithDistinctable.get());
        HashSet<Long> setOrgIds = new HashSet<Long>(16);
        ds.forEach(v -> {
            setOrgIds.add(v.getLong(FIELD_ORG));
            setOrgIds.add(v.getLong(FIELD_OPORG));
        });
        setOrgIds.remove(orgId);
        return setOrgIds;
    }

    private Map<Long, String> getOrgNames(Set<Long> orgIdSet) {
        QFBuilder qfBuilder = new QFBuilder("id", "in", orgIdSet);
        Map orgDynObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"name", (QFilter[])qfBuilder.toArray());
        return orgDynObjMap.values().stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x.getString("name")));
    }
}

