/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.comassist.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ControlContext;
import kd.bos.list.IListColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.bd.model.schema.basedata.AssistantDataDetailSchema;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.enums.ControlVisible;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.OrgFilterUtils;
import kd.fi.gl.util.PermissonType;

public class ComAssistService {
    private static Log logFactory = ExtLogFactory.getLog(ComAssistService.class);
    private static final String ISLEAF = "isleaf";
    public static final String F7_FILTER = "f7filter";
    public static final BeforeF7SelectListener F7Listener = evt -> {
        BasedataEdit control = (BasedataEdit)evt.getSource();
        DynamicProperty property = (DynamicProperty)control.getProperty();
        QFilter qFilter = (QFilter)property.getCustomProperty(F7_FILTER);
        if (qFilter != null) {
            evt.addCustomQFilter(qFilter);
        }
    };

    public static CommonFilterColumn mapToCommonFilterColumn(CommonAssist commonAssist, MainEntityType entityType, ListView view, ControlContext controlContext) {
        CommonBaseDataFilterColumn filterColumn = new CommonBaseDataFilterColumn();
        filterColumn.setCaption(commonAssist.getLocaleName());
        filterColumn.setEntityType(entityType);
        filterColumn.setFieldName(commonAssist.key + ".name");
        filterColumn.setView((IFormView)view);
        filterColumn.setContext(controlContext);
        filterColumn.setMulti(true);
        filterColumn.addSetFilterListeners(evt -> {
            IFormView listView = ((CommonBaseDataFilterColumn)evt.getSource()).getView();
            List allUseOrg = JSON.parseArray((String)listView.getPageCache().get("alluseorg"), Long.class);
            ComAssistService.generateQFilterWithDataPerm(commonAssist, allUseOrg).forEach(arg_0 -> ((SetFilterEvent)evt).addCustomQFilter(arg_0));
        });
        filterColumn.initProperties();
        return filterColumn;
    }

    public static List<QFilter> generateQFilterWithDataPerm(CommonAssist commonAssist, List<Long> permOrgs) {
        logFactory.info("commonAssist: " + commonAssist.valueSource + "; permOrgs: " + permOrgs);
        LinkedList<QFilter> res = new LinkedList<QFilter>();
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)commonAssist.valueSource);
        ComAssistService.getDataPermFilter(commonAssist, permOrgs).ifPresent(res::add);
        logFactory.info("generateQFilterWithDataPerm getDataPermFilter: " + res + "; commonAssist: " + commonAssist.valueSource + "; permOrgs: " + permOrgs);
        if (commonAssist.isAssistantSource()) {
            res.add(AssistantDataDetailSchema.INSTANCE.group.toFilter((Object)commonAssist.assistType));
        }
        res.add(BaseDataServiceHelper.getBaseDataFilter((String)commonAssist.valueSource, permOrgs, (boolean)true));
        logFactory.info("generateQFilterWithDataPerm getBaseDataFilter: " + res + "; commonAssist: " + commonAssist.valueSource + "; permOrgs: " + permOrgs);
        if (ComAssistService.isExistDataBaseField(mainType, ISLEAF)) {
            switch (commonAssist.valueSource) {
                case "bos_org": 
                case "bos_adminorg": {
                    res.add(OrgFilterUtils.getOrgFilterByEntityId(commonAssist.valueSource, Boolean.TRUE));
                    logFactory.info("generateQFilterWithDataPerm getOrgFilterByEntityId: " + res + "; commonAssist: " + commonAssist.valueSource + "; permOrgs: " + permOrgs);
                    break;
                }
                default: {
                    res.add(new QFilter(ISLEAF, "=", (Object)"1"));
                }
            }
        }
        logFactory.info("generateQFilterWithDataPerm switch process: " + res + "; commonAssist: " + commonAssist.valueSource + "; permOrgs: " + permOrgs);
        return res;
    }

    private static boolean isExistDataBaseField(MainEntityType mainType, String fieldName) {
        return mainType.getAllFields().containsKey(fieldName) && StringUtils.isNotEmpty((String)((IDataEntityProperty)mainType.getAllFields().get(fieldName)).getAlias());
    }

    public static Optional<QFilter> getDataPermFilter(CommonAssist commonAssist, List<Long> permOrgs) {
        return (Optional)ThreadCache.get((Object)("CommonAssistTable#permFilters#" + commonAssist.valueSource + ":" + permOrgs.toString()), () -> {
            List<Long> orgs = permOrgs.size() <= 1 ? permOrgs : Collections.singletonList(CommonAssistUtil.getPermParentOrg(permOrgs));
            PermissionService service = (PermissionService)ServiceFactory.getService(PermissionService.class);
            QFilter permFilter = service.getDataRuleWithoutDim(ContextUtil.getUserId(), EntityMetadataCache.getDataEntityType((String)commonAssist.valueSource).getAppId(), commonAssist.valueSource, PermissonType.VIEW.getPermId(), orgs);
            return Optional.ofNullable(permFilter);
        });
    }

    public static Optional<List<Long>> getDataPermIds(CommonAssist commonAssist, List<Long> permOrgs, String pkField) {
        Optional idAndMids = (Optional)ThreadCache.get((Object)("CommonAssistTable#permids#" + commonAssist.valueSource + ":" + permOrgs.toString()), () -> {
            boolean hasMidProp = CommonAssistUtil.hasMasteridProp(commonAssist.valueSource);
            return ComAssistService.getDataPermFilter(commonAssist, permOrgs).map(f -> {
                ArrayList ids = Lists.newArrayList((Object[])new Long[]{0L});
                ArrayList mids = Lists.newArrayList((Object[])new Long[]{0L});
                QueryServiceHelper.queryDataSet((String)"ComAssistTableService#getComAssistFilters", (String)commonAssist.valueSource, (String)(hasMidProp ? "id, masterid" : "id"), (QFilter[])f.toArray(), null, (int)-1).forEachRemaining(row -> {
                    ids.add(row.getLong(0));
                    if (hasMidProp) {
                        mids.add(row.getLong(1));
                    }
                });
                return hasMidProp ? new Tuple((Object)ids, (Object)mids) : new Tuple((Object)ids, null);
            });
        });
        return idAndMids.map(t -> pkField.equals("id") || t.item2 == null ? (List)t.item1 : (List)t.item2);
    }

    public static List<QFilter> generateBackQueryQFilter(CommonAssist commonAssist, List<Long> permOrgs) {
        LinkedList<QFilter> res = new LinkedList<QFilter>();
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)commonAssist.valueSource);
        ComAssistService.getDataPermFilter(commonAssist, permOrgs).ifPresent(res::add);
        if (res.isEmpty()) {
            return res;
        }
        if (commonAssist.isAssistantSource()) {
            res.add(AssistantDataDetailSchema.INSTANCE.group.toFilter((Object)commonAssist.assistType));
        }
        res.add(BaseDataServiceHelper.getBaseDataFilter((String)commonAssist.valueSource, permOrgs, (boolean)true));
        if (ComAssistService.isExistDataBaseField(mainType, ISLEAF)) {
            switch (commonAssist.valueSource) {
                case "bos_org": 
                case "bos_adminorg": {
                    res.add(OrgFilterUtils.getOrgFilterByEntityId(commonAssist.valueSource, Boolean.TRUE));
                    break;
                }
                default: {
                    res.add(new QFilter(ISLEAF, "=", (Object)"1"));
                }
            }
        }
        return res;
    }

    public static void modifyListField(CommonAssist commonAssist, ListField field) {
        field.setEntityName(commonAssist.valueSource);
        field.setVisible(true);
        try {
            DynamicProperty newSrcProp = (DynamicProperty)field.getSrcFieldProp().clone();
            ComAssistService.modifyCommonAssistProp(commonAssist, (IDataEntityProperty)newSrcProp);
            field.setSrcFieldProp((IDataEntityProperty)newSrcProp);
        }
        catch (CloneNotSupportedException e) {
            LogFactory.getLog(ComAssistService.class).error("clone failed.", (Throwable)e);
        }
    }

    public static void modifyCommonAssistField(CommonAssist commonAssist, BasedataEdit comAssistEdit) {
        comAssistEdit.setCaption(commonAssist.getLocaleName());
    }

    public static void modifyListColumn(CommonAssist commonAssist, IListColumn column) {
        column.setCaption(commonAssist.getLocaleName());
        column.setVisible(ControlVisible.show.value);
    }

    public static void modifyCommonAssistProp(CommonAssist commonAssist, IDataEntityProperty property) {
        if (property instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)property;
            basedataProp.setDisplayName(commonAssist.getLocaleName());
            basedataProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)commonAssist.valueSource));
            basedataProp.setBaseEntityId(commonAssist.valueSource);
            if (!"fbasedataid".equals(basedataProp.getName())) {
                basedataProp.setCustomProperty(F7_FILTER, (Object)ComAssistService.generateQFilter(commonAssist, basedataProp.getComplexType()));
            }
        } else if (property instanceof MulBasedataProp) {
            MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
            mulBasedataProp.setDisplayName(commonAssist.getLocaleName());
            mulBasedataProp.setBaseEntityId(commonAssist.valueSource);
            BasedataProp comAssistProp = (BasedataProp)mulBasedataProp.getItemType().getProperties().get((Object)"fbasedataid");
            ComAssistService.modifyCommonAssistProp(commonAssist, (IDataEntityProperty)comAssistProp);
            mulBasedataProp.setCustomProperty(F7_FILTER, (Object)ComAssistService.generateQFilter(commonAssist, comAssistProp.getComplexType()));
        }
    }

    public static QFilter generateQFilter(CommonAssist commonAssist, IDataEntityType complexType) {
        QFilterBuilder qFilterBuilder = new QFilterBuilder();
        if (commonAssist.isAssistantSource()) {
            qFilterBuilder.add(AssistantDataDetailSchema.INSTANCE.group.toFilter((Object)commonAssist.assistType));
        }
        switch (commonAssist.valueSource) {
            case "bos_org": 
            case "bos_adminorg": {
                qFilterBuilder.add(OrgFilterUtils.getOrgFilterByEntityId(commonAssist.valueSource, true));
                break;
            }
            default: {
                if (((BasedataEntityType)complexType).findProperty(ISLEAF) == null) break;
                qFilterBuilder.addEqual(ISLEAF, (Object)true);
            }
        }
        QFilter qFilter = qFilterBuilder.buildSingleFilter();
        return qFilter == null ? QFilter.of((String)"1=1", (Object[])new Object[0]) : qFilter;
    }
}

