/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.common;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import kd.bos.orm.query.QFilter;

public class AccountType {
    public static final String ASSETS = "0";
    public static final String LIABILITIES = "1";
    public static final String RIGHTSINTERESTS = "2";
    public static final String COST = "3";
    public static final String PROFITLOSS = "4";
    public static final String BW = "5";
    public static final String COMMON = "6";
    public static final String OTHER = "7";
    public static final String BUDGET_INCOME = "A";
    public static final String BUDGET_EXPENSE = "B";
    public static final String BUDGET_SURPLUS = "C";
    private static final Set<String> BUDGET_PROPS = ImmutableSet.of((Object)"A", (Object)"B", (Object)"C");
    private static final String ACCOUNT_PROP = "accounttype";

    public static boolean isBudgetProp(String propVal) {
        return BUDGET_PROPS.contains(propVal);
    }

    public static boolean isBudgetType(long accountTypeId) {
        return kd.fi.bd.consts.AccountType.isBudgetType((long)accountTypeId);
    }

    public static String fromAccountTypeId(long accountTypeId) {
        return kd.fi.bd.consts.AccountType.fromAccountTypeId((long)accountTypeId);
    }

    public static QFilter buildNonBudgetFilter() {
        String accountPropKey = String.join((CharSequence)".", ACCOUNT_PROP, ACCOUNT_PROP);
        return new QFilter(accountPropKey, "not in", BUDGET_PROPS);
    }
}

