/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.common;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.fi.bd.util.BillParamUtil;

public class ExtFields {
    private static final Log LOG = LogFactory.getLog(ExtFields.class);
    private Map<String, IDataEntityProperty> extFields;

    public ExtFields(String entityId) {
        this.init(entityId);
    }

    private void init(String entityId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        if (dataEntityType == null) {
            this.extFields = Collections.emptyMap();
            return;
        }
        String id = this.getExtFieldPrefix();
        Map allFields = dataEntityType.getAllFields();
        this.extFields = allFields.entrySet().stream().filter(x -> ((String)x.getKey()).startsWith(id + "_")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o, n) -> n, LinkedHashMap::new));
        LOG.info("fi.gl.extfields_{}:{}", (Object)entityId, (Object)String.join((CharSequence)",", this.extFields.keySet()));
    }

    private String getExtFieldPrefix() {
        String prefix = BillParamUtil.getStringValue((String)"83bfebc8000017ac", (String)"fi.gl.extfield.prefix", (String)ISVServiceHelper.getISVInfo().getId());
        LOG.info("fi.gl.extfield.prefix:{}", (Object)prefix);
        return prefix;
    }

    public Map<String, IDataEntityProperty> getExtFields() {
        return this.extFields;
    }
}

