/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.common;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.bd.rate.IRateCalculator;
import kd.fi.gl.finalprocess.info.AmountInfo;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GLUtil;

public class VoucherEntryInfo {
    private int templateSeq;
    private static final String SUFFIX_ID = "_id";
    private Map<Object, Object> expand;
    private DynamicObject dynObj;
    private String accNumber;

    protected static VoucherEntryInfo newEntryInfo(DynamicObjectType dt) {
        return new VoucherEntryInfo(new DynamicObject(dt));
    }

    protected VoucherEntryInfo(DynamicObject dynObj) {
        this.dynObj = dynObj;
    }

    public DynamicObject getDynObj() {
        return this.dynObj;
    }

    public Map<Object, Object> getExpand() {
        return this.expand;
    }

    public void setExpand(Map<Object, Object> p) {
        this.expand = p;
    }

    public Object getAttr(Object t) {
        if (this.expand == null) {
            return null;
        }
        return this.expand.get(t);
    }

    public void setAttr(Object k, Object v) {
        if (this.expand != null) {
            this.expand.put(k, v);
        }
    }

    public void setAccount(Long id) {
        this.dynObj.set("account_id", (Object)id);
    }

    public Long getAccount() {
        return this.dynObj.getLong("account_id");
    }

    public String getAccNumber() {
        if (StringUtils.isEmpty((CharSequence)this.accNumber)) {
            Object acctDyn = this.dynObj.get("account");
            if (acctDyn instanceof DynamicObject) {
                return ((DynamicObject)acctDyn).getString("number");
            }
            return "";
        }
        return this.accNumber;
    }

    public void setAccNumber(String accNumber) {
        this.accNumber = accNumber;
    }

    public void setCurency(Long id) {
        this.dynObj.set("currency_id", (Object)id);
    }

    public Long getCurency() {
        return this.dynObj.getLong("currency_id");
    }

    public void setUnit(Long id) {
        this.dynObj.set("measureunit_id", (Object)id);
    }

    public Long getUnit() {
        return this.dynObj.getLong("measureunit_id");
    }

    public String getDesc() {
        return this.dynObj.getString("edescription");
    }

    public void setDesc(String desc) {
        this.dynObj.set("edescription", (Object)desc);
    }

    public void setSeq(int seq) {
        this.dynObj.set("seq", (Object)seq);
    }

    public int getSeq() {
        return this.dynObj.getInt("seq");
    }

    public void setOriAmt(BigDecimal dr, BigDecimal cr) {
        this.setAmt(dr, cr, "debitori", "creditori");
    }

    public BigDecimal getOriAmt() {
        return this.getAmt("debitori", "creditori");
    }

    public void setLocAmt(BigDecimal dr, BigDecimal cr) {
        this.setAmt(dr, cr, "debitlocal", "creditlocal");
    }

    public BigDecimal getlocAmt() {
        return this.getAmt("debitlocal", "creditlocal");
    }

    public void set(String fieldKey, Object value) {
        this.dynObj.set(fieldKey, value);
    }

    private void setAmt(BigDecimal dr, BigDecimal cr, String drKey, String crKey) {
        String dc;
        String string = dc = this.getEntryDC() == null ? "1" : this.getEntryDC();
        if ("1".equals(dc)) {
            this.dynObj.set(drKey, (Object)dr);
        } else {
            this.dynObj.set(crKey, (Object)cr);
        }
    }

    BigDecimal getAmt(String drKey, String crKey) {
        String dc = this.getEntryDC() == null ? "1" : this.getEntryDC();
        BigDecimal rs = "1".equals(dc) ? this.dynObj.getBigDecimal(drKey) : this.dynObj.getBigDecimal(crKey);
        return rs;
    }

    public BigDecimal getCreOri() {
        return this.dynObj.getBigDecimal("creditori");
    }

    public void setCreOri(BigDecimal o) {
        this.dynObj.set("creditori", (Object)o);
    }

    public BigDecimal getDebOri() {
        return this.dynObj.getBigDecimal("debitori");
    }

    public void setDebOri(BigDecimal o) {
        this.dynObj.set("debitori", (Object)o);
    }

    public BigDecimal getDebLoc() {
        return this.dynObj.getBigDecimal("debitlocal");
    }

    public void setDebLoc(BigDecimal o) {
        this.dynObj.set("debitlocal", (Object)o);
    }

    public BigDecimal getCreLoc() {
        return this.dynObj.getBigDecimal("creditlocal");
    }

    public void setCreLoc(BigDecimal o) {
        this.dynObj.set("creditlocal", (Object)o);
    }

    public void setLocRate(BigDecimal o) {
        if (BigDecimal.ZERO.compareTo(o) == 0) {
            this.dynObj.set("localrate", (Object)BigDecimal.ONE);
        } else {
            this.dynObj.set("localrate", (Object)o);
        }
    }

    public BigDecimal getLocRate() {
        return this.dynObj.getBigDecimal("localrate");
    }

    public void setQty(BigDecimal o) {
        this.dynObj.set("quantity", (Object)o);
    }

    public BigDecimal getQty() {
        return this.dynObj.getBigDecimal("quantity");
    }

    public void setPrice(BigDecimal o) {
        if (o != null) {
            o = o.abs();
        }
        this.dynObj.set("price", (Object)o);
    }

    public BigDecimal getPrice() {
        return this.dynObj.getBigDecimal("price");
    }

    public void setEntryDC(String dc) {
        if ("1".equals(dc) || "-1".equals(dc)) {
            this.dynObj.set("entrydc", (Object)dc);
        }
    }

    public String getEntryDC() {
        return this.dynObj.getString("entrydc");
    }

    public void setAssgrp(Long id) {
        this.dynObj.set("assgrp_id", (Object)id);
    }

    public Long getAssgrp() {
        return this.dynObj.getLong("assgrp_id");
    }

    public void setExpireDate(Date enDate) {
        this.dynObj.set("expiredate", (Object)enDate);
    }

    public Date getExpireDate() {
        return this.dynObj.getDate("expiredate");
    }

    public int getTemplateSeq() {
        return this.templateSeq;
    }

    public void setTemplateSeq(int templateSeq) {
        this.templateSeq = templateSeq;
    }

    public void loadAmountInfo(AmountInfo amountInfo) {
        this.setAssgrp(amountInfo.getAssgrpId());
        this.setAccount(amountInfo.getAccountId());
        this.setCurency(amountInfo.getCrrencyId());
        this.setLocRate(amountInfo.getRate());
        this.setQty(amountInfo.getQty());
        this.setUnit(amountInfo.getMeasureUnitID());
        Map<Integer, Long> comAssistIdMap = amountInfo.getComAssistIdMap();
        comAssistIdMap.forEach(this::setComAssist);
        if (this.getQty().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal price = amountInfo.getPrice();
            if (price.compareTo(BigDecimal.ZERO) == 0) {
                price = amountInfo.getOriAmount().divide(this.getQty(), GLUtil.getCurrencyPriceScale(this.getCurency()), RoundingMode.HALF_UP);
            }
            this.setPrice(price);
        }
        if ("1".equals(amountInfo.getDc())) {
            this.setDebOri(amountInfo.getOriAmount());
            this.setDebLoc(amountInfo.getLocAmount());
        } else {
            this.setCreOri(amountInfo.getOriAmount());
            this.setCreLoc(amountInfo.getLocAmount());
        }
    }

    public void loadAmountInfo(AmountInfo amountInfo, IRateCalculator rateCalculator) {
        this.loadAmountInfo(amountInfo);
        this.setLocRate(rateCalculator.calRate(amountInfo.getOriAmount(), amountInfo.getLocAmount(), GLUtil.getCurrencyScale(amountInfo.getCrrencyId())));
    }

    public String toString() {
        return String.format("VoucherEntryInfo at row number %s {acct:%s, assgrp:%s, amt in local:%s, amt in originAmt:%s, DC for %s, currency in %s, qty in %s, measure unit in %s, price in %s, expire date at %s}", this.getSeq(), this.getAccount(), this.getAssgrp(), this.getlocAmt(), this.getOriAmt(), this.getEntryDC(), this.getCurency(), this.getQty(), this.getUnit(), this.getPrice(), this.getExpireDate());
    }

    public void setOrg(Long org) {
        this.dynObj.set("eorg", (Object)org);
    }

    public void setPeriod(Long period) {
        this.dynObj.set("eperiod", (Object)period);
    }

    public Object getEntryId() {
        return this.dynObj.getPkValue();
    }

    public VoucherEntryInfo copy() {
        VoucherEntryInfo voucherEntryInfo = new VoucherEntryInfo(this.dynObj);
        voucherEntryInfo.setAccNumber(this.accNumber);
        voucherEntryInfo.setTemplateSeq(this.templateSeq);
        voucherEntryInfo.setExpand(this.expand);
        return voucherEntryInfo;
    }

    public void setComAssist(int comAssistIndex, Long comAssist) {
        this.dynObj.set(CommonAssistUtil.getComassistField(comAssistIndex) + SUFFIX_ID, (Object)comAssist);
    }

    public Long getComAssist(int comAssistIndex) {
        return this.dynObj.getLong(CommonAssistUtil.getComassistField(comAssistIndex) + SUFFIX_ID);
    }
}

