/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.constant;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.finalprocess.info.scheme.DynamicEntity;
import kd.fi.gl.finalprocess.info.scheme.PropertyKey;

public abstract class Constant {
    public final String entity = this.getKey();
    private static final Map<String, String> specifiedPropKeyMap = new HashMap<String, String>(8);
    public static final PropertyKey Entity_AccountBookType = new PropertyKey("bookstype");
    public static final PropertyKey Entity_VoucherType = new PropertyKey("vouchertypeid");
    public static final PropertyKey Entity_AccountTable = new PropertyKey("accounttable");
    public static final PropertyKey Entity_Org = new PropertyKey("org");
    public static final PropertyKey Entity_Number = new PropertyKey("number");
    public static final PropertyKey Entity_BillNo = new PropertyKey("billno");
    public static final PropertyKey Entity_Name = new PropertyKey("name");
    public static final PropertyKey Entity_ID = new PropertyKey("id");
    public static final PropertyKey Entity_MasterID = new PropertyKey("masterid");
    public static final PropertyKey Entity_Account = new PropertyKey("accountid");
    public static final PropertyKey Entity_Entry = new PropertyKey("entryentity");
    public static final PropertyKey Entity_Seq = new PropertyKey("seq");

    public static void putSpecifiedKey(PropertyKey nameSpaceProp, PropertyKey commonKey, String specifiedKey) {
        specifiedPropKeyMap.put(nameSpaceProp.toFullNameString() + "." + commonKey.toString(), specifiedKey);
    }

    protected final String getKey() {
        return this.getEntityKey();
    }

    public abstract String getEntityKey();

    public static String getSpecifiedKey(String schemeType, PropertyKey propKey) {
        if (schemeType == null) {
            return propKey.key;
        }
        return specifiedPropKeyMap.getOrDefault(schemeType + "." + propKey.key, propKey.key);
    }

    public static String getSpecifiedKey(PropertyKey entryProp, PropertyKey propKey) {
        if (entryProp == null) {
            return propKey.key;
        }
        return specifiedPropKeyMap.getOrDefault(entryProp.toFullNameString() + "." + propKey.key, propKey.key);
    }

    public static String getSpecifiedKeyToPrepare(PropertyKey entryProp, PropertyKey propKey) {
        if (entryProp == null) {
            return propKey.key;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(entryProp.toStringOnEntry());
        sb.append(sb.length() == 0 ? "" : ".").append(Constant.getSpecifiedKey(entryProp.toFullNameString(), propKey));
        return sb.toString();
    }

    public static void initSpecifiedKey(String nameSpace, PropertyKey commonProp, String specifedKey) {
        specifiedPropKeyMap.put(nameSpace + commonProp.toString(), specifedKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Constant constant = (Constant)o;
        return Objects.equals(this.entity, constant.entity);
    }

    public int hashCode() {
        return Objects.hash(this.entity);
    }

    public static String getInnerPropString(PropertyKey ... props) {
        return Arrays.stream(props).map(prop -> Constant.getSpecifiedKey(prop.entityKey, prop)).collect(Collectors.joining("."));
    }

    public List<DynamicEntity> loadEntity(List<QFilter> filters, PropertyKey ... props) {
        DynamicObject[] entityArr = BusinessDataServiceHelper.load((String)this.getEntityKey(), (String)PropertyKey.getSelectPropertyFields(props), (QFilter[])filters.toArray(new QFilter[0]));
        return Arrays.stream(entityArr).map(entity -> new DynamicEntity((DynamicObject)entity, props)).collect(Collectors.toList());
    }

    static {
        specifiedPropKeyMap.put("gl_voucheramortacheme." + Entity_AccountBookType.toString(), "accountbooks");
        specifiedPropKeyMap.put("gl_autotrans." + Entity_AccountBookType.toString(), "bookstype");
        specifiedPropKeyMap.put("gl_transplprogram." + Entity_AccountBookType.toString(), "book");
        specifiedPropKeyMap.put("gl_adjustexchangerate." + Entity_AccountBookType.toString(), "bookstype");
        specifiedPropKeyMap.put("gl_voucheramortacheme." + Entity_VoucherType.toString(), "vouchertype");
        specifiedPropKeyMap.put("gl_adjustexchangerate." + Entity_Number.toString(), "billno");
        specifiedPropKeyMap.put("gl_autotrans.autotransentry." + Entity_Seq.toString(), "seq");
    }
}

