/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.enums.writeoff;

import java.util.function.Function;
import kd.bos.algo.DataType;
import kd.fi.gl.constant.reciprocal.UnAcccurrent;
import kd.fi.gl.reciprocal.ReciprocalRecord;

public enum WriteOffField {
    ID("id", (DataType)DataType.LongType, ReciprocalRecord::getId),
    ORG("orgname", (DataType)DataType.LongType, ReciprocalRecord::getOrg),
    BOOKTYPE("booktype", (DataType)DataType.LongType, ReciprocalRecord::getBookType),
    ACCOUNT("accountid", (DataType)DataType.LongType, ReciprocalRecord::getAccount),
    ASSGRP("assgrp", (DataType)DataType.LongType, ReciprocalRecord::getAssgrp),
    ASSGRPVALUE("assval", (DataType)DataType.StringType, ReciprocalRecord::getAssgrpValStr),
    CURRENCYID("currencyid", (DataType)DataType.LongType, null),
    CURRENCYFOR("currencyfor", (DataType)DataType.LongType, ReciprocalRecord::getCurrency),
    CURRENCYLOCAL("currencylocal", (DataType)DataType.LongType, ReciprocalRecord::getLocalCurrency),
    AMOUNTBAL("amountbal", (DataType)DataType.BigDecimalType, ReciprocalRecord::getAmountBal),
    AMOUNTBALFOR("amountbalfor", (DataType)DataType.BigDecimalType, ReciprocalRecord::getAmountBalFor),
    BIZDATE("bizDate", (DataType)DataType.DateType, ReciprocalRecord::getBizDate),
    EXPIREDATE("expiredate", (DataType)DataType.DateType, ReciprocalRecord::getExpireDate),
    VOUCHERID("voucherid", (DataType)DataType.LongType, ReciprocalRecord::getVoucherId),
    DESCRIPTION("description", (DataType)DataType.StringType, ReciprocalRecord::getDescription),
    BIZNUM("biznum", (DataType)DataType.StringType, ReciprocalRecord::getBizNum),
    FORWRITEOFFDATE(UnAcccurrent.FORWRITEOFFDATE, (DataType)DataType.DateType, null),
    LOCALWRITEOFFDATE(UnAcccurrent.LOCALWRITEOFFDATE, (DataType)DataType.DateType, null),
    ASSGRPITEM("assgrpitem", (DataType)DataType.LongType, null),
    OVERDUETOTAL("overduetotal", (DataType)DataType.BigDecimalType, null),
    OVERDUETOTALLOCAL("overduetotallocal", (DataType)DataType.BigDecimalType, null),
    OVERDUE("overdue", (DataType)DataType.BigDecimalType, null),
    UNDUETOTAL("unduetotal", (DataType)DataType.BigDecimalType, null),
    UNDUETOTALLOCAL("unduetotallocal", (DataType)DataType.BigDecimalType, null),
    UNDUE("undue", (DataType)DataType.BigDecimalType, null),
    BALTOTAL("baltotal", (DataType)DataType.BigDecimalType, null),
    LOCALBALTOTAL("localbaltotal", (DataType)DataType.BigDecimalType, null),
    UDE_EXT("", (DataType)DataType.BigDecimalType, null);

    private String filed;
    private DataType type;
    private Function<ReciprocalRecord, Object> function;

    private WriteOffField(String field, DataType type, Function<ReciprocalRecord, Object> function) {
        this.filed = field;
        this.type = type;
        this.function = function;
    }

    public String getFiled() {
        return this.filed;
    }

    public WriteOffField setField(String field) {
        this.filed = field;
        return this;
    }

    public DataType getType() {
        return this.type;
    }

    public Function<ReciprocalRecord, Object> getFunction() {
        return this.function;
    }

    public static WriteOffField getValueByName(String valueName) {
        for (WriteOffField writeOffField : WriteOffField.values()) {
            if (!writeOffField.filed.equals(valueName)) continue;
            return writeOffField;
        }
        return null;
    }
}

