/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.bean.EntryFieldInfo;
import kd.fi.gl.bean.GlVoucherField;

public class VoucherEntryDBHelper {
    private static final String DELETE_SQL_VOUCHER_ENTRIES = "delete from t_gl_voucherentry where ";
    private static final Log logger = LogFactory.getLog((String)VoucherEntryDBHelper.class.getTypeName());

    public static void deleteEntryById(Object destVid, String sqlTag) {
        VoucherEntryDBHelper.deleteEntryById(new HashSet<Object>(Collections.singletonList(destVid)), sqlTag);
    }

    public static void deleteEntryById(Set<Object> destVids, String sqlTag) {
        HintCondition hintId = new HintCondition("fid", "in", destVids);
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{hintId}).prepareShardingIndex();){
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append(DELETE_SQL_VOUCHER_ENTRIES, new Object[0]);
            sqlBuilder.appendIn("fid", new ArrayList<Object>(destVids));
            if (DebugTrace.enable()) {
                logger.info("{} destVids: {},  sql: {}", new Object[]{sqlTag, destVids, sqlBuilder.toString()});
            }
            try (TXHandle h = TX.requiresNew((String)sqlTag);){
                try {
                    DB.execute((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
                }
                catch (Throwable e) {
                    h.markRollback();
                    logger.error("{} error, destVids: {}", new Object[]{sqlTag, destVids, e});
                    throw e;
                }
            }
        }
    }

    public static DataSet getSrcVoucherEntries(Set<Object> srcVidList, String selectFields) {
        HintCondition hintId = new HintCondition("fid", "in", srcVidList);
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{hintId}).prepareShardingIndex();){
            QFilter idFilter = new QFilter("id", "in", srcVidList);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"VoucherEntryDBHelper.getSrcVoucherEntries", (String)"gl_voucher", (String)selectFields, (QFilter[])new QFilter[]{idFilter}, (String)"id");
            return dataSet;
        }
    }

    public static DataSet getDestVoucherEntries(Set<Object> destVids) {
        HintCondition hintId = new HintCondition("fid", "in", destVids);
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{hintId}).prepareShardingIndex();){
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid, fentryid, faccountid, fmaincfitemid, fmaincfamount, ", new Object[0]);
            sqlBuilder.append(" fsuppcfitemid, fsuppcfamount, flocaldebit, flocalcredit from t_gl_voucherentry where ", new Object[0]);
            sqlBuilder.appendIn("fid", new ArrayList<Object>(destVids));
            sqlBuilder.append(" order by fid ", new Object[0]);
            DataSet dataSet = DB.queryDataSet((String)"getDestVoucherEntries", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
            return dataSet;
        }
    }

    public static DataSet querySortedEntries(Set<Object> destVids, GlVoucherField glVoucherField) {
        HintCondition hintId = new HintCondition("fid", "in", destVids);
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{hintId}).prepareShardingIndex();){
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid, fentryid, faccountid, fassgrpid, fcurrencyid, flocalexchangerate, fmeasureunitid,fmaincfitemid, fmaincfassgrpid, fmaincfamount, fsuppcfitemid, fsuppcfamount, foriginaldebit, foriginalcredit, flocaldebit, flocalcredit, fquantity, fprice, fdescription, fentrydc, fexpiredate, fbusinessnum, fbiznumrecordid, forgid, fperiodid", new Object[0]);
            List<EntryFieldInfo> allEntryFieldInfos = glVoucherField.getAllEntryFieldInfos();
            if (!allEntryFieldInfos.isEmpty()) {
                for (EntryFieldInfo entryFieldInfo : allEntryFieldInfos) {
                    sqlBuilder.append(",", new Object[0]).append(entryFieldInfo.getAlias(), new Object[0]);
                }
            }
            sqlBuilder.append(" from t_gl_voucherentry where ", new Object[0]);
            sqlBuilder.appendIn("fid", new ArrayList<Object>(destVids));
            sqlBuilder.append(" order by fid,fseq", new Object[0]);
            DataSet dataSet = DB.queryDataSet((String)"querySortedEntries", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
            return dataSet;
        }
    }

    public static void saveMergedEntries(List<Object[]> paramList, GlVoucherField glVoucherField) {
        logger.info("saveMergedEntries, paramList.size: {},  destvid: {}, entryid[0]: {}", new Object[]{paramList.size(), paramList.get(0)[0], paramList.get(0)[1]});
        if (!paramList.isEmpty()) {
            Long orgId = Long.parseLong(paramList.get(0)[23] + "");
            HashMap<Long, List> periodIdAndparamList = new HashMap<Long, List>();
            for (Object[] objectArray : paramList) {
                Long periodId = Long.parseLong(objectArray[24] + "");
                periodIdAndparamList.computeIfAbsent(periodId, fun -> new ArrayList()).add(objectArray);
            }
            for (Map.Entry entry : periodIdAndparamList.entrySet()) {
                HintCondition hintOrg = new HintCondition("forgid", "=", (Object)orgId);
                HintCondition hintPeroid = new HintCondition("fperiodid", "=", entry.getKey());
                ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{hintOrg, hintPeroid}).prepareShardingIndex();
                Throwable throwable = null;
                try {
                    List<EntryFieldInfo> allEntryFieldInfos = glVoucherField.getAllEntryFieldInfos();
                    StringBuilder insertEntriesSql = new StringBuilder();
                    insertEntriesSql.append("insert into t_gl_voucherentry (").append("fid, fentryid, faccountid, fassgrpid, fcurrencyid, flocalexchangerate, fmeasureunitid, ").append("fmaincfitemid, fmaincfassgrpid, fmaincfamount, fsuppcfitemid, fsuppcfamount,").append("foriginaldebit, foriginalcredit, flocaldebit, flocalcredit,").append(" fquantity, fprice, fdescription, fentrydc,fexpiredate, fbusinessnum, fbiznumrecordid, forgid, fperiodid, fseq");
                    if (!allEntryFieldInfos.isEmpty()) {
                        for (EntryFieldInfo entryFieldInfo : allEntryFieldInfos) {
                            insertEntriesSql.append(",").append(entryFieldInfo.getAlias());
                        }
                    }
                    insertEntriesSql.append(") values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?");
                    int size = allEntryFieldInfos.size();
                    for (int i = 0; i < size; ++i) {
                        insertEntriesSql.append(",?");
                    }
                    insertEntriesSql.append(")");
                    TXHandle h = TX.requiresNew((String)"saveMergedEntries");
                    Throwable throwable2 = null;
                    try {
                        try {
                            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)insertEntriesSql.toString(), (List)((List)entry.getValue()));
                        }
                        catch (Throwable e) {
                            h.markRollback();
                            logger.error("saveMergedEntries error, destVid: {}", paramList.get(0)[0], (Object)e);
                            throw e;
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (h == null) continue;
                        if (throwable2 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        h.close();
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (ctx == null) continue;
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    ctx.close();
                }
            }
        }
    }
}

