/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.info;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;

public class AmountInfo {
    private Long accountId;
    private Long assgrpId;
    private Long crrencyId;
    private Long unitId;
    private BigDecimal locAmount = BigDecimal.ZERO;
    private BigDecimal oriAmount = BigDecimal.ZERO;
    private BigDecimal rate = BigDecimal.ONE;
    private String dc;
    private BigDecimal qty = BigDecimal.ZERO;
    private String plType;
    private BigDecimal price = BigDecimal.ZERO;
    private Long measureUnitID = 0L;
    private Map<Integer, Long> comAssistIdMap = new HashMap<Integer, Long>();
    private String mulCurType;

    public AmountInfo() {
    }

    public AmountInfo(Builder builder) {
        this.accountId = builder.accountId;
        this.assgrpId = builder.assgrpId;
        this.crrencyId = builder.crrencyId;
        this.unitId = builder.unitId;
        this.locAmount = builder.locAmount;
        this.oriAmount = builder.oriAmount;
        this.rate = builder.rate;
        this.dc = builder.dc;
        this.qty = builder.qty;
        this.plType = builder.plType;
        this.price = builder.price;
        this.measureUnitID = builder.measureUnitID;
        this.comAssistIdMap = builder.comAssistIdMap;
        this.mulCurType = builder.mulCurType;
    }

    public AmountInfo(Long accountId, Long assgrpId, Long crrencyId, BigDecimal locAmount, BigDecimal oriAmount, BigDecimal rate, String dc) {
        this.accountId = accountId;
        this.assgrpId = assgrpId;
        this.crrencyId = crrencyId;
        this.locAmount = locAmount;
        this.oriAmount = oriAmount;
        this.rate = rate;
        this.dc = dc;
    }

    public void switchDcAndNegate() {
        this.dc = new BigDecimal(this.dc).negate().toString();
        this.negate();
    }

    public void negate() {
        this.oriAmount = this.oriAmount.negate();
        this.locAmount = this.locAmount.negate();
        this.qty = this.qty.negate();
    }

    public void multiplyPercent(BigDecimal percent, int locScale, int oriScale, int qtyScale) {
        this.setLocAmount(this.getLocAmount().multiply(percent).setScale(locScale, RoundingMode.HALF_UP));
        this.setOriAmount(this.getOriAmount().multiply(percent).setScale(oriScale, RoundingMode.HALF_UP));
        if (qtyScale >= 0) {
            this.setQty(this.getQty().multiply(percent).setScale(qtyScale, RoundingMode.HALF_UP));
        }
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getAssgrpId() {
        return this.assgrpId;
    }

    public void setAssgrpId(Long assgrpId) {
        this.assgrpId = assgrpId;
    }

    public Long getCrrencyId() {
        return this.crrencyId;
    }

    public void setCrrencyId(Long crrencyId) {
        this.crrencyId = crrencyId;
    }

    public Long getUnitId() {
        return this.unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public BigDecimal getLocAmount() {
        return this.locAmount;
    }

    public void setLocAmount(BigDecimal locAmount) {
        this.locAmount = locAmount;
    }

    public BigDecimal getOriAmount() {
        return this.oriAmount;
    }

    public void setOriAmount(BigDecimal oriAmount) {
        this.oriAmount = oriAmount;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public String getDc() {
        return this.dc;
    }

    public void setDc(String dc) {
        this.dc = dc;
    }

    public BigDecimal getQty() {
        return this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public String getPlType() {
        return this.plType;
    }

    public void setPlType(String plType) {
        this.plType = plType;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Long getMeasureUnitID() {
        return this.measureUnitID;
    }

    public void setMeasureUnitID(Long measureUnitID) {
        this.measureUnitID = measureUnitID == null ? Long.valueOf(0L) : measureUnitID;
    }

    public Map<Integer, Long> getComAssistIdMap() {
        return this.comAssistIdMap;
    }

    public void setComAssistIdMap(Map<Integer, Long> comAssistIdMap) {
        this.comAssistIdMap = comAssistIdMap;
    }

    public String getMulCurType() {
        return this.mulCurType;
    }

    public String toString() {
        return "AmountInfo{accountId=" + this.accountId + ", assgrpId=" + this.assgrpId + ", crrencyId=" + this.crrencyId + ", unitId=" + this.unitId + ", locAmount=" + this.locAmount + ", oriAmount=" + this.oriAmount + ", rate=" + this.rate + ", dc='" + this.dc + '\'' + ", qty=" + this.qty + ", plType='" + this.plType + '\'' + ", price=" + this.price + ", measureUnitID=" + this.measureUnitID + ", comAssistIdMap = " + this.comAssistIdMap + '}';
    }

    public static String displayInfos(Iterable<AmountInfo> itr) {
        StringBuilder res = new StringBuilder();
        for (AmountInfo amount : itr) {
            res.append(amount.toString()).append("\n");
        }
        return res.toString();
    }

    public static class Builder {
        private Long accountId;
        private Long assgrpId;
        private Long crrencyId;
        private Long unitId;
        private BigDecimal locAmount = BigDecimal.ZERO;
        private BigDecimal oriAmount = BigDecimal.ZERO;
        private BigDecimal rate = BigDecimal.ONE;
        private String dc;
        private BigDecimal qty = BigDecimal.ZERO;
        private String plType;
        private BigDecimal price = BigDecimal.ZERO;
        private Long measureUnitID = 0L;
        private Map<Integer, Long> comAssistIdMap = new HashMap<Integer, Long>();
        private String mulCurType;

        public Builder accountId(Long accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder assgrpId(Long assgrpId) {
            this.assgrpId = assgrpId;
            return this;
        }

        public Builder currencyId(Long currencyId) {
            this.crrencyId = currencyId;
            return this;
        }

        public Builder unitId(Long unitId) {
            this.unitId = unitId;
            return this;
        }

        public Builder locAmount(BigDecimal locAmount) {
            this.locAmount = locAmount;
            return this;
        }

        public Builder oriAmount(BigDecimal oriAmount) {
            this.oriAmount = oriAmount;
            return this;
        }

        public Builder rate(BigDecimal rate) {
            this.rate = rate;
            return this;
        }

        public Builder dc(String dc) {
            this.dc = dc;
            return this;
        }

        public Builder qty(BigDecimal qty) {
            this.qty = qty;
            return this;
        }

        public Builder plType(String plType) {
            this.plType = plType;
            return this;
        }

        public Builder price(BigDecimal price) {
            this.price = price;
            return this;
        }

        public Builder measureUnitId(Long measureUnitID) {
            this.measureUnitID = measureUnitID;
            return this;
        }

        public Builder comAssistIdMap(Map<Integer, Long> comAssistIdMap) {
            this.comAssistIdMap = comAssistIdMap;
            return this;
        }

        public Builder mulCurType(String type) {
            this.mulCurType = StringUtils.isBlank((CharSequence)type) ? "BaseCurrency" : type;
            return this;
        }

        public AmountInfo build() {
            return new AmountInfo(this);
        }
    }
}

