/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.info.scheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.finalprocess.info.scheme.DynamicEntryRow;
import kd.fi.gl.finalprocess.info.scheme.PropertyKey;

public class DynamicEntry {
    private final String key;
    private final Set<PropertyKey> entryColumnKeys;
    private final List<DynamicEntryRow> rowList;

    public DynamicEntry(DynamicObject entity, PropertyKey ... props) {
        this.key = props[0].entryKey;
        this.rowList = new ArrayList<DynamicEntryRow>(12);
        this.entryColumnKeys = Arrays.stream(props).filter(prop -> prop.entryKey.equals(this.key)).collect(Collectors.toSet());
        this.initEntry(entity);
    }

    public DynamicEntry(DynamicObject entity, String entryKey, Set<PropertyKey> props) {
        this.key = entryKey;
        this.rowList = new ArrayList<DynamicEntryRow>(12);
        this.entryColumnKeys = new HashSet<PropertyKey>(8);
        this.initEntry(entity);
    }

    private void initEntry(DynamicObject entity) {
        entity.getDynamicObjectCollection(this.key).stream().map(rowDyo -> new DynamicEntryRow(this.entryColumnKeys, (DynamicObject)rowDyo, null)).forEach(this.rowList::add);
    }

    public String getKey() {
        return this.key;
    }

    public Set<PropertyKey> getEntryColumnKeys() {
        return this.entryColumnKeys;
    }

    public List<DynamicEntryRow> getRowList() {
        return this.rowList;
    }

    public String getStringProperty(int seq, PropertyKey property) {
        Object val = this.getProperty(seq, property);
        return val == null ? null : (String)val;
    }

    public DynamicObject getDynamicObjectProperty(int seq, PropertyKey property) {
        Object val = this.getProperty(seq, property);
        return val == null ? null : (DynamicObject)val;
    }

    public Long getLongProperty(int seq, PropertyKey property) {
        Object val = this.getProperty(seq, property);
        return val == null ? null : (Long)val;
    }

    private Object getProperty(int seq, PropertyKey property) {
        return this.rowList.get(seq).getProperty(property);
    }

    public Set<Object> getEntryPropSet(PropertyKey prop) {
        return this.rowList.stream().map(row -> row.getProperty(prop)).collect(Collectors.toSet());
    }
}

