/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.info.scheme;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.gl.enums.AutoTransAmtTypeEnum;
import kd.fi.gl.enums.AutoTransQtyTypeEnum;
import kd.fi.gl.finalprocess.constant.AutoTransConstant;
import kd.fi.gl.finalprocess.info.scheme.PropertyKey;
import kd.fi.gl.finalprocess.info.scheme.inittask.IEntryRowInitTask;
import kd.fi.gl.finalprocess.info.scheme.inittask.tasklibrary.autotrans.QtyInitTask;
import kd.fi.gl.finalprocess.info.scheme.inittask.tasklibrary.autotrans.RateInitTask;

public class DynamicEntryRow {
    private final Map<PropertyKey, Object> propertyStorage = new HashMap<PropertyKey, Object>(8);
    private static final Map<PropertyKey, IEntryRowInitTask> INIT_TASK_REPOSITORY = new HashMap<PropertyKey, IEntryRowInitTask>(8);

    public DynamicEntryRow(Set<PropertyKey> propToInit, DynamicObject entryDyo, Map<String, Object> taskContext) {
        propToInit.forEach(prop -> this.initDynamicEntryProperty((PropertyKey)prop, DynamicEntryRow.getInitTaskWithPropKey(prop).init(entryDyo, taskContext)));
    }

    public DynamicEntryRow(DynamicObject entryDyo, Map<String, Object> taskContext, PropertyKey ... props) {
        HashSet<PropertyKey> propToInit = new HashSet<PropertyKey>(Arrays.asList(props));
        propToInit.forEach(prop -> this.initDynamicEntryProperty((PropertyKey)prop, DynamicEntryRow.getInitTaskWithPropKey(prop).init(entryDyo, taskContext)));
    }

    public static IEntryRowInitTask getInitTaskWithPropKey(PropertyKey prop) {
        IEntryRowInitTask simpleInitTask = (entryRowDyo, taskContext) -> entryRowDyo.get(prop.toString());
        return INIT_TASK_REPOSITORY.getOrDefault(prop, simpleInitTask);
    }

    public DynamicEntryRow() {
    }

    public void initDynamicEntryProperty(PropertyKey property, Object value) {
        this.propertyStorage.put(property, value);
    }

    public Object getProperty(PropertyKey prop) {
        return this.propertyStorage.get(prop);
    }

    public Object getInnerProperty(PropertyKey ... props) {
        Object curPropDyo = this.getDynamicObject(props[0]);
        for (int i = 1; i < props.length && curPropDyo != null; curPropDyo = curPropDyo.get(props[i].key), ++i) {
        }
        return curPropDyo;
    }

    public int getInnerInt(PropertyKey ... props) {
        Object prop = this.getInnerProperty(props);
        return prop == null ? 0 : (Integer)prop;
    }

    public Long getInnerLong(PropertyKey ... props) {
        Object prop = this.getInnerProperty(props);
        return prop == null ? Long.valueOf(0L) : (Long)prop;
    }

    public String getInnerString(PropertyKey ... props) {
        Object prop = this.getInnerProperty(props);
        return prop == null ? "" : (String)prop;
    }

    public Object getPropertyPK(PropertyKey prop) {
        Object obj = this.getProperty(prop);
        return obj == null ? null : ((DynamicObject)obj).getPkValue();
    }

    public int getInt(PropertyKey prop) {
        Object obj = this.getProperty(prop);
        return obj == null ? 0 : (Integer)obj;
    }

    public String getString(PropertyKey prop) {
        Object obj = this.getProperty(prop);
        return obj == null ? "" : (String)obj;
    }

    public BigDecimal getBigDecimal(PropertyKey prop) {
        Object obj = this.getProperty(prop);
        return obj == null ? BigDecimal.ZERO : (BigDecimal)obj;
    }

    public DynamicObject getDynamicObject(PropertyKey prop) {
        Object obj = this.getProperty(prop);
        return obj == null ? null : (DynamicObject)obj;
    }

    public DynamicObjectCollection getDynamicObjectCollection(PropertyKey prop) {
        Object obj = this.getProperty(prop);
        return obj == null ? null : (DynamicObjectCollection)obj;
    }

    static {
        INIT_TASK_REPOSITORY.put(AutoTransConstant.Entry_QTY, new QtyInitTask());
        INIT_TASK_REPOSITORY.put(AutoTransConstant.Entry_Rate, new RateInitTask());
        INIT_TASK_REPOSITORY.put(AutoTransConstant.Entry_AMT_FROM, (entryRow, context) -> AutoTransAmtTypeEnum.valueOfHash(entryRow.getString(AutoTransConstant.Entry_AMT_FROM.toString())));
        INIT_TASK_REPOSITORY.put(AutoTransConstant.Entry_QTY_FROM, (entryRow, context) -> AutoTransQtyTypeEnum.valueOfHash(entryRow.getString(AutoTransConstant.Entry_QTY_FROM.toString())));
    }
}

