/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.info.scheme;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.constant.Constant;

public class PropertyKey {
    public final String entityKey;
    public final String entryKey;
    public final String key;

    public PropertyKey(String key) {
        this.entityKey = "";
        this.entryKey = "";
        this.key = key;
    }

    public PropertyKey(String entityKey, String key) {
        this.entityKey = entityKey;
        this.entryKey = "";
        this.key = key;
    }

    public PropertyKey(String entityKey, String entryKey, String key) {
        this.entityKey = entityKey;
        this.entryKey = entryKey;
        this.key = key;
    }

    public PropertyKey(String entityKey, PropertyKey entryKey, String key) {
        this.entityKey = entityKey;
        this.entryKey = entryKey.key;
        this.key = key;
    }

    public String getEntryKey() {
        return this.entryKey;
    }

    public String getKey() {
        return this.key;
    }

    @Deprecated
    public String toString() {
        return this.key;
    }

    public String toString(String schemeType) {
        return Constant.getSpecifiedKey(schemeType, this);
    }

    public String toIDString() {
        return this.key + "_id";
    }

    public String toNumberString() {
        return this.key + ".number";
    }

    public String toStringOnEntry() {
        return this.toStringOnEntry(this.entityKey);
    }

    public String toStringOnEntry(String schemeType) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)this.entryKey)) {
            sb.append(this.entryKey);
        }
        if (!StringUtils.isEmpty((CharSequence)this.key)) {
            sb.append(sb.length() == 0 ? "" : ".").append(Constant.getSpecifiedKey(schemeType, this));
        }
        return sb.toString();
    }

    public String toFullNameString() {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)this.entityKey)) {
            sb.append(this.entityKey);
        }
        sb.append(this.toStringOnEntry());
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyKey that = (PropertyKey)o;
        return Objects.equals(this.entityKey, that.entityKey) && Objects.equals(this.entryKey, that.entryKey) && Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return !StringUtils.isEmpty((CharSequence)this.entityKey) ? Objects.hash(this.entityKey, this.entryKey, this.key) : (!StringUtils.isEmpty((CharSequence)this.entryKey) ? Objects.hash(this.entryKey, this.key) : Objects.hash(this.key));
    }

    public static String getSelectPropertyFields(PropertyKey ... prop) {
        return Arrays.stream(prop).map(PropertyKey::toStringOnEntry).collect(Collectors.joining(", "));
    }

    public QFilter getFilter(String qcp, Object value) {
        return new QFilter(this.toStringOnEntry(), qcp, value);
    }

    public QFilter getFilter(String systemType, String qcp, Object value) {
        return new QFilter(this.toStringOnEntry(systemType), qcp, value);
    }

    public PropertyKey cloneProp(String entityKey, String entryKey, String key) {
        return new PropertyKey(entityKey == null ? this.entityKey : entityKey, entryKey == null ? this.entryKey : entryKey, key == null ? this.key : key);
    }

    public PropType getPropType() {
        return PropType.getPropType(this);
    }

    public static enum PropType {
        entityProp,
        entryProp,
        undefine;


        public static PropType getPropType(PropertyKey prop) {
            if (StringUtils.isEmpty((CharSequence)prop.entityKey) && !StringUtils.isEmpty((CharSequence)prop.key)) {
                return entityProp;
            }
            if (!(StringUtils.isEmpty((CharSequence)prop.entityKey) || StringUtils.isEmpty((CharSequence)prop.entryKey) || StringUtils.isEmpty((CharSequence)prop.key))) {
                return entryProp;
            }
            if (!StringUtils.isEmpty((CharSequence)prop.entityKey) && StringUtils.isEmpty((CharSequence)prop.entryKey) && !StringUtils.isEmpty((CharSequence)prop.key)) {
                return entityProp;
            }
            return undefine;
        }
    }
}

