/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.info.scheme.inittask.tasklibrary.autotrans;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.enums.AutoTransQtyTypeEnum;
import kd.fi.gl.finalprocess.constant.AutoTransConstant;
import kd.fi.gl.finalprocess.info.scheme.inittask.IEntryRowInitTask;

public class QtyInitTask
implements IEntryRowInitTask {
    @Override
    public Object init(DynamicObject entryRowDyo, Map<String, Object> taskContext) {
        AutoTransQtyTypeEnum qtyFrom = AutoTransQtyTypeEnum.valueOfHash(entryRowDyo.getString(AutoTransConstant.Entry_QTY_FROM.toString()));
        switch (qtyFrom) {
            case fixValue: {
                return entryRowDyo.getBigDecimal(AutoTransConstant.Entry_QTY.toString());
            }
            case formula: {
                return this.getQtyFromBcmFormula(entryRowDyo, (Map)taskContext.get("row2bcmFormulaCalculateInfo"));
            }
            case report: {
                return this.getQtyFromRpt(entryRowDyo, (Map)taskContext.get("rowToRptResult"));
            }
            case account: 
            case excel: 
            case noneValue: {
                return new BigDecimal(0);
            }
        }
        throw new IllegalStateException("Unexpected QTY From: " + (Object)((Object)qtyFrom));
    }

    private BigDecimal getQtyFromRpt(DynamicObject entryRowDyo, Map<String, Object> rowToRptResult) {
        Map entryrows = (Map)rowToRptResult.get("entryrows");
        Map entryFixRows = (Map)rowToRptResult.get("entryfixrows");
        String rowKey = QtyInitTask.getUUID(entryRowDyo, false);
        Map entryRow = (Map)entryrows.get(rowKey);
        if (Objects.isNull(entryRow)) {
            Object fixAmt = entryFixRows.get(rowKey);
            if (fixAmt != null && !(fixAmt instanceof BigDecimal)) {
                return new BigDecimal(fixAmt.toString());
            }
            return Optional.ofNullable((BigDecimal)fixAmt).orElse(BigDecimal.ZERO);
        }
        BigDecimal result = BigDecimal.ZERO;
        for (BigDecimal value : entryRow.values()) {
            result = result.add(value);
        }
        return result;
    }

    private BigDecimal getQtyFromBcmFormula(DynamicObject entryRowDyo, Map<String, BigDecimal> formulaCalRes) {
        return formulaCalRes.get(QtyInitTask.getUUID(entryRowDyo, false));
    }

    public static String getUUID(DynamicObject entryRow, boolean isAmount) {
        if (!isAmount) {
            return entryRow.get(AutoTransConstant.Entry_RowID.toString()) + "_QTY";
        }
        return entryRow.get(AutoTransConstant.Entry_RowID.toString()) + "_" + ("13".equals(entryRow.getString(AutoTransConstant.Entry_AMT_FROM.toString())) ? "IN" : "OUT");
    }
}

