/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.finalprocess.constant.EndingProcessConstant;
import kd.fi.gl.finalprocess.constant.EpGenVchRelationConstant;
import kd.fi.gl.finalprocess.info.scheme.AbstractEndingProcessScheme;
import kd.fi.gl.finalprocess.info.scheme.AutoTransScheme;
import kd.fi.gl.finalprocess.info.scheme.PropertyKey;
import kd.fi.gl.finalprocess.info.scheme.VchAmortScheme;
import kd.fi.gl.finalprocess.service.IEndingProcessingService;
import kd.fi.gl.finalprocess.service.impl.AutoTransService;
import kd.fi.gl.finalprocess.service.impl.VchAmortService;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.QFBuilder;

public abstract class AbstractEndingProcessingService
implements IEndingProcessingService {
    protected final AbstractEndingProcessScheme scheme;
    protected final EndingProcessConstant endingProcessConstant;

    public AbstractEndingProcessScheme getScheme() {
        return this.scheme;
    }

    public EndingProcessConstant getEndingProcessConstant() {
        return this.endingProcessConstant;
    }

    public AbstractEndingProcessingService(AbstractEndingProcessScheme scheme) {
        this.scheme = scheme;
        this.endingProcessConstant = this.getInstance(this.scheme);
    }

    protected final EndingProcessConstant getInstance(AbstractEndingProcessScheme scheme) {
        return this.getEndingConstantInstance(scheme);
    }

    protected abstract EndingProcessConstant getEndingConstantInstance(AbstractEndingProcessScheme var1);

    public boolean checkIfGenVchOnCurrentPeriod() {
        return this.checkSchemeIfGenVchOnPeriod(this.scheme.getCurPeriodDyn());
    }

    public boolean checkSchemeIfGenVchOnPeriod(DynamicObject periodDyo) {
        return !this.getVchOfSchemeOnPeriod(periodDyo).isEmpty();
    }

    public QFBuilder getAccountFilterInVersion(QFilter customFilter, boolean onlyLeaf) {
        return AccountUtils.getAccountFilerOnBookAndPeriod(this.scheme.getAccountBookInfo(), this.scheme.getCurPeriodId(), customFilter, onlyLeaf);
    }

    public long getAccountTableInVersion() {
        long orgID = this.scheme.getAccountBookInfo().getOrgId();
        long bookTypeID = this.scheme.getAccountBookInfo().getBookTypeId();
        return AccSysUtil.getCurPeriodAccountTableId(orgID, bookTypeID, this.scheme.getCurPeriodId());
    }

    public QFBuilder getAccountFilterInVersion(QFilter customFilter) {
        return this.getAccountFilterInVersion(customFilter, false);
    }

    @Override
    public Set<Long> getVchIDSet() {
        QFilter sIDFilter = new QFilter("srcentity", "=", (Object)this.scheme.getPkValue());
        QFilter sTypeFilter = new QFilter("type", "=", (Object)EpGenVchRelationConstant.SourceType.getEnum((AbstractEndingProcessScheme)this.scheme).key);
        return QueryServiceHelper.query((String)"gl_voucherrelation", (String)"targentity", (QFilter[])new QFilter[]{sIDFilter, sTypeFilter}).stream().map(relation -> relation.getLong("targentity")).collect(Collectors.toSet());
    }

    @Override
    public Set<Long> getAvailableAccountIDSet() {
        return this.getAvailableAccountIDSet(null);
    }

    public Set<Long> getAvailableAccountIDSet(QFilter customFilter) {
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])this.getAccountFilterInVersion(customFilter).toArray(), null, (int)-1).stream().mapToLong(id -> (Long)id).collect(HashSet::new, Set::add, (set1, set2) -> set2.addAll(set1));
    }

    @Override
    public int getVchNumberHasGen() {
        return this.getVchIDSet().size();
    }

    public static AbstractEndingProcessingService getServiceBySchemeDyo(DynamicObject scheme) {
        switch (scheme.getDataEntityType().getName()) {
            case "gl_autotrans": {
                return new AutoTransService(new AutoTransScheme(scheme));
            }
            case "gl_voucheramortacheme": {
                return new VchAmortService(new VchAmortScheme(scheme));
            }
        }
        return null;
    }

    public Set<DynamicObjectCollection> getAccountEntryDyoCollectionSet() {
        return new HashSet<DynamicObjectCollection>();
    }

    @Override
    public Map<String, Object> getRow2SchemeEntryColumnMap(PropertyKey prop) {
        return new HashMap<String, Object>(8);
    }
}

