/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.service.impl;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.finalprocess.constant.EndingProcessConstant;
import kd.fi.gl.finalprocess.constant.VchAmortConstant;
import kd.fi.gl.finalprocess.info.scheme.AbstractEndingProcessScheme;
import kd.fi.gl.finalprocess.info.scheme.VchAmortScheme;
import kd.fi.gl.finalprocess.service.AbstractEndingProcessingService;

public class VchAmortService
extends AbstractEndingProcessingService {
    public VchAmortService(VchAmortScheme scheme) {
        super(scheme);
    }

    public Set<Long> getVchOfSchemeOnPeriod(VchAmortScheme scheme, DynamicObject periodDyo) {
        return scheme.getDataEntity().getDynamicObjectCollection("policies").stream().filter(dyo -> dyo.getLong(GLField.id_("period")) == ((Long)periodDyo.getPkValue()).longValue()).map(dyo -> dyo.getLong(GLField.id_("period"))).collect(Collectors.toSet());
    }

    @Override
    public Set<Long> getVchOfSchemeOnPeriod(DynamicObject periodDyo) {
        return this.getVchOfSchemeOnPeriod((VchAmortScheme)this.scheme, periodDyo);
    }

    public Set<Long> getVchOnPeriodInDB(long periodID) {
        DynamicObject schemeDyo = BusinessDataServiceHelper.loadSingle((Object)this.scheme.getPkValue(), (String)"gl_voucheramortacheme");
        DynamicObject periodDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)periodID, (String)"bd_period");
        return this.getVchOfSchemeOnPeriod(new VchAmortScheme(schemeDyo), periodDyo);
    }

    public int getVchNumberHasGenByScheme() {
        DynamicObjectCollection amortRecordEntry = this.scheme.getDataEntity().getDynamicObjectCollection(VchAmortConstant.getKeyAmortRecord((VchAmortScheme)this.scheme));
        if (((VchAmortScheme)this.scheme).getAmortStyle().isCustom()) {
            return (int)amortRecordEntry.stream().filter(entry -> entry.getBoolean("isgenvoucher")).count();
        }
        return amortRecordEntry.size();
    }

    @Override
    protected EndingProcessConstant getEndingConstantInstance(AbstractEndingProcessScheme schemeInfo) {
        return new VchAmortConstant();
    }

    @Override
    public int getVchNumberHasGen() {
        return super.getVchNumberHasGen();
    }
}

