/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.amort.amortstyle;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.finalprocess.info.AmountInfo;
import kd.fi.gl.finalprocessing.amort.amortstyle.IAmortInfoGetter;
import kd.fi.gl.finalprocessing.info.AmortGenVchInfo;
import kd.fi.gl.util.VoucherAmortSchemeUtils;

public abstract class AbstractAmortInfoGetter
implements IAmortInfoGetter {
    protected DynamicObject schemeDyn;
    protected AmortGenVchInfo amortInfo;

    @Override
    public AmountInfo calAmountForNow() {
        BigDecimal locAmountForTotal = this.schemeDyn.getBigDecimal("totalamount");
        if (this.isLastPeriod()) {
            BigDecimal amortAmountVal = this.schemeDyn.getBigDecimal("amortamount");
            return new AmountInfo.Builder().locAmount(locAmountForTotal.subtract(amortAmountVal)).build();
        }
        BigDecimal locAmountForNow = this.schemeDyn.getBigDecimal("periodamortamount");
        return new AmountInfo.Builder().locAmount(locAmountForNow).oriAmount(this.calOriAmountForNow(locAmountForNow)).build();
    }

    @Override
    public AmountInfo calAmountForTotal() {
        BigDecimal oriTotal = this.amortInfo.getTargetEntry().stream().map(targetRow -> targetRow.getBigDecimal("planamount")).reduce(BigDecimal::add).get();
        return new AmountInfo.Builder().oriAmount(oriTotal).locAmount(this.schemeDyn.getBigDecimal("totalamount")).build();
    }

    public BigDecimal calOriAmountForNow(BigDecimal locAmountForNow) {
        BigDecimal locAmountForTotal = this.schemeDyn.getBigDecimal("totalamount");
        BigDecimal oriAmountForTotal = this.amortInfo.getAmountForTotal().getOriAmount();
        int oriScale = this.amortInfo.getTargetEntry().stream().map(x -> x.getInt("targetcurrency.amtprecision")).min(Integer::compareTo).get();
        return oriAmountForTotal.multiply(locAmountForNow).divide(locAmountForTotal, oriScale, RoundingMode.HALF_UP);
    }

    public Long getEndPeriodId() {
        DynamicObject startDyn = this.schemeDyn.getDynamicObject("startperiod");
        int planCount = this.schemeDyn.getInt("planperiod");
        int amortCount = this.schemeDyn.getInt("amortperiod");
        return VoucherAmortSchemeUtils.getMaxPeriodIdByCount(startDyn.getLong("id"), planCount + amortCount, "0");
    }

    @Override
    public boolean isLastPeriod() {
        return this.getEndPeriodId().equals(this.amortInfo.getCurPeriodId());
    }

    public BigDecimal getAmountForPerPeriod() {
        return this.schemeDyn.getBigDecimal("periodamortamount");
    }

    public AbstractAmortInfoGetter build(DynamicObject schemeDyn, AmortGenVchInfo amortInfo) {
        this.schemeDyn = schemeDyn;
        this.amortInfo = amortInfo;
        return this;
    }
}

