/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.info;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.rate.RateType;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.VoucherInfo;
import kd.fi.gl.finalprocessing.info.ExchangeRateType;
import kd.fi.gl.util.GLUtil;

public class FinalProcessingInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BD_PERIOD = "bd_period";
    protected DynamicObject dataEntity;
    private VoucherInfo voucherInfo = new VoucherInfo();
    private AccountBookInfo accountBookInfo;
    private Date bizDate = new Date();
    private BigDecimal zero = BigDecimal.ZERO;
    private DynamicObject curPeriodDyn;
    private DynamicObject baseCurrency;
    private Long curPeriodId;
    private Collection<LocalCurrencyConfigVO> localCurrencyConfig;
    private final Map<ExchangeRateType, Integer> ratePrecisionCache = new HashMap<ExchangeRateType, Integer>();

    public FinalProcessingInfo(DynamicObject dataEntity, AccountBookInfo accountBookInfo) {
        this.dataEntity = dataEntity;
        this.accountBookInfo = accountBookInfo;
        this.localCurrencyConfig = LocalCurrencyConfigService.queryEnableCurrencies((long)this.getOrgId(), (long)this.getAccountBookInfo().getBookTypeId());
    }

    public FinalProcessingInfo(DynamicObject dataEntity, String bookType, OperateOption option) {
        this.dataEntity = dataEntity;
        long orgId = dataEntity.getDynamicObject("org").getLong("id");
        long booksTypeId = dataEntity.getDynamicObject(bookType).getLong("id");
        this.accountBookInfo = AccSysUtil.getBookFromAccSys(orgId, booksTypeId);
        String openedPeriod = option.getVariableValue("openedperiod", "0");
        Long openedPeriodId = Long.valueOf(openedPeriod);
        this.curPeriodId = this.accountBookInfo.getCurPeriodId(openedPeriodId);
        this.localCurrencyConfig = LocalCurrencyConfigService.queryEnableCurrencies((long)this.getOrgId(), (long)this.getAccountBookInfo().getBookTypeId());
    }

    public Map<ExchangeRateType, Integer> getRatePrecisionCache() {
        return this.ratePrecisionCache;
    }

    public BigDecimal getLex(ExchangeRateType exchangeRateType, BigDecimal oriAmt, BigDecimal localAmt) {
        BigDecimal lex;
        if (oriAmt.compareTo(BigDecimal.ZERO) == 0) {
            lex = BigDecimal.ONE;
        } else {
            Integer ratePrecision = this.ratePrecisionCache.computeIfAbsent(exchangeRateType, exchangeRateType1 -> GLUtil.getRatePrecision(exchangeRateType.getRateTableCurrency(), exchangeRateType.getSourceCurrency(), exchangeRateType.getTargetCurrency(), exchangeRateType.getEffectiveDate()));
            RateType rateType = RateServiceHelper.getRateType((long)exchangeRateType.getSourceCurrency(), (long)exchangeRateType.getTargetCurrency(), (Date)exchangeRateType.getEffectiveDate());
            lex = rateType.getRateCalculator().calRate(oriAmt, localAmt, ratePrecision.intValue()).abs();
        }
        return lex;
    }

    public Collection<LocalCurrencyConfigVO> getLocalCurrencyConfig() {
        return this.localCurrencyConfig;
    }

    public DynamicObject getDataEntity() {
        return this.dataEntity;
    }

    public void setDataEntity(DynamicObject dataEntity) {
        this.dataEntity = dataEntity;
    }

    public AccountBookInfo getAccountBookInfo() {
        return this.accountBookInfo;
    }

    public void setAccountBookInfo(AccountBookInfo accountBookInfo) {
        this.accountBookInfo = accountBookInfo;
    }

    public Date getBizDate() {
        return this.bizDate;
    }

    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    public DynamicObject getCurPeroid() {
        if (this.curPeriodDyn == null && this.accountBookInfo != null) {
            this.curPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getCurPeriodId(), (String)BD_PERIOD);
        }
        return this.curPeriodDyn;
    }

    public void setCurPeroid(DynamicObject curPeroid) {
    }

    public VoucherInfo getVoucherInfo() {
        return this.voucherInfo;
    }

    public void setVoucherInfo(VoucherInfo voucherInfo) {
        this.voucherInfo = voucherInfo;
    }

    public long getExchangeTableId() {
        return this.accountBookInfo != null ? this.accountBookInfo.getExrateTableId() : 0L;
    }

    public long getBaseCurrencyId() {
        return this.accountBookInfo != null ? this.accountBookInfo.getBaseCurrencyId() : 0L;
    }

    public Date getCurPeriodEndDate() {
        if (this.curPeriodDyn == null && this.accountBookInfo != null) {
            this.curPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getCurPeriodId(), (String)BD_PERIOD);
        }
        return this.curPeriodDyn == null ? null : this.curPeriodDyn.getDate("enddate");
    }

    public long getAccountTableId() {
        return this.accountBookInfo != null ? this.accountBookInfo.getAccountTableId() : 0L;
    }

    public DynamicObject getBaseCurrencyDyn() {
        long baseCurrencyId;
        if (this.baseCurrency == null && (baseCurrencyId = this.getBaseCurrencyId()) > 0L) {
            this.baseCurrency = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter("id", "=", (Object)baseCurrencyId).toArray());
        }
        return this.baseCurrency;
    }

    public long getOrgId() {
        return this.dataEntity.getLong("org_id");
    }

    public Long getCurPeriodId() {
        return this.curPeriodId;
    }
}

