/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.flex;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;

public class FlexValueJson {
    private final String valueJson;
    private final Map<String, Object> valueMap;

    public FlexValueJson(String valueJson) {
        this.valueJson = valueJson;
        if (StringUtils.isBlank((CharSequence)this.valueJson)) {
            this.valueMap = new HashMap<String, Object>();
        } else {
            Map map = (Map)SerializationUtils.fromJsonString((String)this.valueJson, Map.class);
            this.valueMap = new HashMap<String, Object>(map.size());
            map.forEach((k, v) -> {
                if (v instanceof Integer) {
                    this.valueMap.put((String)k, Long.valueOf(v.toString()));
                } else {
                    this.valueMap.put((String)k, v);
                }
            });
        }
    }

    public Map<String, Object> getValueMap() {
        return this.valueMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlexValueJson other = (FlexValueJson)o;
        return this.valueJson.equals(other.valueJson) && this.valueMap.equals(other.valueMap);
    }

    public int hashCode() {
        return Objects.hash(this.valueJson, this.valueMap);
    }
}

