/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.notice;

import com.google.common.collect.Sets;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.fi.gl.notice.NoticeAction;
import kd.fi.gl.notice.NoticeQueueParam;
import kd.fi.gl.notice.NoticeTaskDispatcher;

public class NoticeMessenger {
    private static final Log logger = LogFactory.getLog(NoticeMessenger.class);

    public static void delivery(Long[] voucherIds, NoticeAction noticeAction) {
        logger.info("begin to delivery, voucherIds={}, action={}", (Object)voucherIds, (Object)noticeAction);
        if (ArrayUtils.isEmpty((Object[])voucherIds) || noticeAction == null || noticeAction == NoticeAction.DO_NOTHING) {
            return;
        }
        NoticeQueuePublisher.publishAfterTx(new NoticeQueueParam(Sets.newHashSet((Object[])voucherIds), noticeAction));
    }

    private static class NoticeQueuePublisher {
        private static final String QUEUE_NAME = "fi.gl.acnotice_queue";
        private static final String FI = "fi";

        private NoticeQueuePublisher() {
        }

        private static void publishAfterTx(final NoticeQueueParam param) {
            if (TX.inTX()) {
                TX.addCommitListener((CommitListener)new CommitListener(){

                    public void onEnded(boolean rollbacked) {
                        if (!rollbacked) {
                            NoticeQueuePublisher.publish(param);
                        }
                    }
                });
            } else {
                NoticeQueuePublisher.publish(param);
            }
        }

        private static void publish(NoticeQueueParam param) {
            if (param.getVoucherIdSet().size() == 1) {
                NoticeTaskDispatcher.dispatch(param);
                return;
            }
            MessagePublisher pulisher = MQFactory.get().createSimplePublisher(FI, QUEUE_NAME);
            try {
                String paramStr = SerializationUtils.toJsonString((Object)param);
                pulisher.publish(paramStr);
            }
            finally {
                if (null != pulisher) {
                    pulisher.close();
                }
            }
        }
    }
}

