/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.notice;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.gl.notice.INoticeSender;
import kd.fi.gl.notice.NoticeSenderFactory;
import kd.fi.gl.notice.NoticeUtils;
import kd.fi.gl.util.GLUtil;

public class NoticeSendExecutor {
    private static final Log LOGGER = LogFactory.getLog(NoticeSendExecutor.class);
    private static final NoticeSendExecutor INSTANCE = new NoticeSendExecutor();

    public static NoticeSendExecutor getInstance() {
        return INSTANCE;
    }

    private NoticeSendExecutor() {
    }

    protected void excute(String entityName, List<Long> voucherIds) {
        if (voucherIds == null || voucherIds.isEmpty()) {
            return;
        }
        INoticeSender noticeSender = NoticeSenderFactory.getNoticeSender(entityName);
        if (noticeSender == null) {
            return;
        }
        try {
            List<List<Long>> splitList = NoticeUtils.splitList(voucherIds, 100);
            ArrayList sendResults = new ArrayList(splitList.size());
            splitList.forEach(x -> sendResults.add(ThreadService.submit(() -> noticeSender.send((List<Long>)x), (TaskType)TaskType.GL_NOTICE_SEND_EXECUTOR)));
            for (Future future : sendResults) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    LOGGER.error(ResManager.loadKDString((String)"\u53d1\u9001\u901a\u77e5\u5355\u4e00\u6761\u7ebf\u7a0b\u5b58\u5728\u5931\u8d25\u3002", (String)"NoticeSendExecutor_0", (String)"fi-gl-common", (Object[])new Object[0]) + GLUtil.printError(e));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format(ResManager.loadKDString((String)"\u53d1\u9001\u901a\u77e5\u5355\u5931\u8d25%s\u3002", (String)"NoticeSendExecutor_1", (String)"fi-gl-common", (Object[])new Object[0]), GLUtil.printError(e)));
        }
    }
}

