/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.notice;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.fi.gl.notice.NoticeAction;
import kd.fi.gl.notice.NoticeQueueParam;
import kd.fi.gl.notice.NoticeSendExecutor;
import kd.fi.gl.notice.NoticeUtils;

public class NoticeTaskDispatcher {
    public static void dispatch(NoticeQueueParam param) {
        Set<Long> voucherIdSet = param.getVoucherIdSet();
        NoticeAction noticeAction = param.getNoticeAction();
        ArrayList<Long> voucherPks = new ArrayList<Long>(voucherIdSet);
        switch (noticeAction) {
            case SEND_AC: {
                NoticeTaskDispatcher.sendAC(voucherPks);
                break;
            }
            case SEND_CF: {
                NoticeTaskDispatcher.sendCF(voucherPks);
                break;
            }
            case SEND_ALL: {
                NoticeTaskDispatcher.sendAll(voucherPks);
                break;
            }
            case DELETE_ALL: {
                NoticeTaskDispatcher.deleteAll(voucherPks);
                break;
            }
        }
    }

    private static void sendAC(List<Long> vouchers) {
        NoticeSendExecutor.getInstance().excute("gl_acnotice", vouchers);
    }

    private static void sendCF(List<Long> vouchers) {
        NoticeSendExecutor.getInstance().excute("gl_cfnotice", vouchers);
    }

    private static void sendAll(List<Long> vouchers) {
        NoticeTaskDispatcher.sendAC(vouchers);
        NoticeTaskDispatcher.sendCF(vouchers);
    }

    private static void deleteAC(List<Long> vouchers) {
        NoticeUtils.deleteNoticeByVoucherIds("gl_acnotice", vouchers);
    }

    private static void deleteCF(List<Long> vouchers) {
        NoticeUtils.deleteNoticeByVoucherIds("gl_cfnotice", vouchers);
    }

    private static void deleteAll(List<Long> vouchers) {
        NoticeTaskDispatcher.deleteAC(vouchers);
        NoticeTaskDispatcher.deleteCF(vouchers);
    }
}

