/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.fi.gl.reciprocal.AbstractRcpWriteOffLoginUnit;
import kd.fi.gl.reciprocal.RcpWriteOffUtils;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.reciprocal.RecordIteratorResult;

public class AmtEqlWriteOffLogicUnit
extends AbstractRcpWriteOffLoginUnit {
    private Map<Long, Long> srcAndTgtEntryMap;
    private Iterator<ReciprocalRecord> buyerIterator;
    private Iterator<ReciprocalRecord> writeOffIterator;
    private static final int COUNT = 2;

    @Override
    protected void beforeWriteOffEvent() {
        Map buyerRecordsGroupByMap;
        this.srcAndTgtEntryMap = new HashMap<Long, Long>();
        List<ReciprocalRecord> lstAllRecords = this.getAllRecords();
        ArrayList<ReciprocalRecord> buyerRecords = new ArrayList<ReciprocalRecord>();
        ArrayList<ReciprocalRecord> writeOffRecords = new ArrayList<ReciprocalRecord>();
        for (ReciprocalRecord reciprocalRecord : lstAllRecords) {
            if ("2".equals(reciprocalRecord.getStatus()) || RcpWriteOffUtils.isZero(reciprocalRecord.getAmountFor())) continue;
            if (reciprocalRecord.getBuyerFor().booleanValue()) {
                buyerRecords.add(reciprocalRecord);
                continue;
            }
            writeOffRecords.add(reciprocalRecord);
        }
        if (this.context.getScheme().isVerifiDiffBusiNo()) {
            buyerRecordsGroupByMap = buyerRecords.stream().collect(Collectors.groupingBy(ReciprocalRecord::getBaseKey, TreeMap::new, Collectors.collectingAndThen(Collectors.toList(), b -> b.stream().sorted(Comparator.comparing(ReciprocalRecord::getAmountFor).thenComparing(ReciprocalRecord::getBizDate).thenComparing(ReciprocalRecord::getId)).collect(Collectors.toList()))));
            buyerRecords.clear();
            for (Map.Entry entry : buyerRecordsGroupByMap.entrySet()) {
                buyerRecords.addAll((Collection)entry.getValue());
            }
            Map map = writeOffRecords.stream().collect(Collectors.groupingBy(ReciprocalRecord::getBaseKey, TreeMap::new, Collectors.collectingAndThen(Collectors.toList(), w -> w.stream().sorted(Comparator.comparing(ReciprocalRecord::getAmountFor).thenComparing(ReciprocalRecord::getBizDate).thenComparing(ReciprocalRecord::getId).reversed()).collect(Collectors.toList()))));
            writeOffRecords.clear();
            for (Map.Entry entry : map.entrySet()) {
                writeOffRecords.addAll((Collection)entry.getValue());
            }
        } else {
            buyerRecordsGroupByMap = buyerRecords.stream().collect(Collectors.groupingBy(ReciprocalRecord::getBaseKey, TreeMap::new, Collectors.collectingAndThen(Collectors.toList(), b -> b.stream().sorted(Comparator.comparing(ReciprocalRecord::getAmountFor).thenComparing(ReciprocalRecord::getBizNum).thenComparing(ReciprocalRecord::getId)).collect(Collectors.toList()))));
            buyerRecords.clear();
            for (Map.Entry entry : buyerRecordsGroupByMap.entrySet()) {
                buyerRecords.addAll((Collection)entry.getValue());
            }
            Map map = writeOffRecords.stream().collect(Collectors.groupingBy(ReciprocalRecord::getBaseKey, TreeMap::new, Collectors.collectingAndThen(Collectors.toList(), w -> w.stream().sorted(Comparator.comparing(ReciprocalRecord::getAmountFor).thenComparing(ReciprocalRecord::getBizNum).thenComparing(ReciprocalRecord::getId).reversed()).collect(Collectors.toList()))));
            writeOffRecords.clear();
            for (Map.Entry entry : map.entrySet()) {
                writeOffRecords.addAll((Collection)entry.getValue());
            }
        }
        this.buyerIterator = buyerRecords.iterator();
        this.writeOffIterator = writeOffRecords.iterator();
    }

    @Override
    protected List<Long> getBatchRecords() {
        HashSet<Long> vchIds = new HashSet<Long>();
        if (!this.buyerIterator.hasNext() || !this.writeOffIterator.hasNext()) {
            return new ArrayList<Long>(vchIds);
        }
        int iCount = 0;
        ReciprocalRecord buyerRecord = this.buyerIterator.next();
        ReciprocalRecord writeOffRecord = this.writeOffIterator.next();
        RecordIteratorResult result = new RecordIteratorResult(buyerRecord, writeOffRecord, iCount, true);
        while (result.hasNext().booleanValue()) {
            result = this.getNextRecords(vchIds, result);
        }
        return new ArrayList<Long>(vchIds);
    }

    private RecordIteratorResult getNextRecords(Set<Long> vchIds, RecordIteratorResult result) {
        ReciprocalRecord buyerRecord = result.getBuyerRecord();
        ReciprocalRecord writeOffRecord = result.getWriteOffRecord();
        int iCount = result.getCount();
        Integer compareRst = buyerRecord.compareToByInt(writeOffRecord, this.context.getScheme());
        Boolean hasNext = Boolean.TRUE;
        if (compareRst == 0) {
            this.srcAndTgtEntryMap.put(buyerRecord.getId(), writeOffRecord.getId());
            vchIds.add(buyerRecord.getVoucherId());
            vchIds.add(writeOffRecord.getVoucherId());
            buyerRecord = this.getNextRecord(this.buyerIterator);
            writeOffRecord = this.getNextRecord(this.writeOffIterator);
            if ((iCount += 2) >= 1000) {
                hasNext = Boolean.FALSE;
            }
        } else if (compareRst > 0) {
            writeOffRecord = this.getNextRecord(this.writeOffIterator);
        } else {
            buyerRecord = this.getNextRecord(this.buyerIterator);
        }
        return new RecordIteratorResult(buyerRecord, writeOffRecord, iCount, hasNext);
    }

    private ReciprocalRecord getNextRecord(Iterator<ReciprocalRecord> iterator) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    protected void doEveryWriteOff() {
        for (Map.Entry<Long, Long> entrySet : this.srcAndTgtEntryMap.entrySet()) {
            Long buyerEntryId = entrySet.getKey();
            Long writeOffEntryId = entrySet.getValue();
            ReciprocalRecord buyerRecord = this.getRecordById(buyerEntryId);
            ReciprocalRecord writeOffRecord = this.getRecordById(writeOffEntryId);
            this.generateWriteOffLog(buyerRecord, writeOffRecord);
        }
        this.srcAndTgtEntryMap.clear();
    }

    @Override
    public Boolean isNeedSplit() {
        return Boolean.TRUE;
    }

    @Override
    protected String getQuerySourceType() {
        return "-1";
    }

    @Override
    protected String getWriteOffSourceType() {
        return "-1";
    }
}

