/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.enums.writeoff.WriteOffField;
import kd.fi.gl.reciprocal.AbstractRcpWriteOffLoginUnit;
import kd.fi.gl.reciprocal.AmtEqlWriteOffLogicUnit;
import kd.fi.gl.reciprocal.ReciprocalContext;
import kd.fi.gl.reciprocal.ReciprocalLog;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.reciprocal.ReciprocalScheme;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.reciprocal.simulate.SimulateRecord;

public class RcpWriteOffUtils {
    private static final Log logger = LogFactory.getLog(RcpWriteOffUtils.class);
    private static final String SELECTFIELDS = "id, org.id org, booktype.id booktype, accounttable.id accounttable, period.id period, account.id account, assgrp.id assgrp, assgrp.value assval, currency.id currency,amountfor,amountbalfor,localcurrency,amount,amountbal,biznum,bizDate,voucherid,voucherentry vchentryid,sourcetype,modifytime,status,expiredate,description, masterid,writeoffperson,creator,entrydc";
    private static final int BatchCount_Query = 30000;
    private static final int BatchCount_WriteOff = 15000;

    public static void writeOff(AbstractRcpWriteOffLoginUnit unit) {
        String log = "";
        if (unit.isNeedSplit().booleanValue()) {
            log = String.format(ResManager.loadKDString((String)"\u6267\u884c\u5355\u5143%s\u5206\u6279\u6267\u884c\u3002", (String)"RcpWriteOffUtils_0", (String)"fi-gl-common", (Object[])new Object[0]), unit.getClass().getName());
            RcpWriteOffUtils.splitWriteOffRecords(unit);
        } else {
            log = String.format(ResManager.loadKDString((String)"\u6267\u884c\u5355\u5143%s\u5168\u90e8\u67e5\u8be2\u540e\u6267\u884c\u3002", (String)"RcpWriteOffUtils_1", (String)"fi-gl-common", (Object[])new Object[0]), unit.getClass().getName());
            RcpWriteOffUtils.writeOffAllRecords(unit);
        }
        RcpWriteOffUtils.logInfo(unit, log);
    }

    private static void splitWriteOffRecords(AbstractRcpWriteOffLoginUnit unit) {
        if (unit.reLoadRecords().booleanValue()) {
            RcpWriteOffUtils.reLoadRecords(unit);
        }
        if (unit instanceof AmtEqlWriteOffLogicUnit && !unit.context.getScheme().isEqualamountpriority() && !unit.context.getScheme().isEquaCanVerfi()) {
            return;
        }
        RcpWriteOffUtils.doWriteOff(unit);
    }

    private static void reLoadRecords(AbstractRcpWriteOffLoginUnit unit) {
        ReciprocalContext context = unit.context;
        ReciprocalScheme scheme = context.getScheme();
        String sourceType = unit.getQuerySourceType();
        Set<Long> curRecordIds = context.getCurTask().getEntryIds(sourceType);
        if (DebugTrace.enable()) {
            logger.info("=====reciprocalAging_taskId:{}_RcpWriteOffUtils_reLoadRecords_\u5f53\u524d\u65b9\u6848:{}_\u7ec4\u7ec7:{}_\u6267\u884c\u5355\u5143:{}_sourceType:{}_curRecordIdsSize:{}_curRecordIds:{}=====", new Object[]{context.getCurTask().getTaskId(), scheme.getNumber(), scheme.getOrg(), unit.getClass().getName(), sourceType, curRecordIds == null ? 0 : curRecordIds.size(), curRecordIds == null ? Integer.valueOf(0) : JSON.toJSON(curRecordIds)});
        }
        if (curRecordIds == null) {
            return;
        }
        Set<Long> loadedRecordIds = context.getLoadedRecordIds();
        curRecordIds.removeAll(loadedRecordIds);
        String orderString = RcpWriteOffUtils.getOrderString(scheme);
        RcpWriteOffUtils.logInfo(unit, String.format(ResManager.loadKDString((String)"\u6267\u884c\u5355\u5143%1$s\u5171%2$s\u6761\u67e5\u8be2\u6570\u636e\uff0c\u5c06\u5206\u6279\u8bfb\u53d6\u6570\u636e\u8fdb\u884c\u6838\u9500\u3002", (String)"RcpWriteOffUtils_2", (String)"fi-gl-common", (Object[])new Object[0]), unit.getClass().getName(), curRecordIds.size()));
        List<List<Long>> ids = RcpWriteOffUtils.splitQueryRecordIds(curRecordIds);
        int iSrcCount = 0;
        int iTgtCount = 0;
        String logMsg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u5355\u5143%1$s\u5206\u6279\u67e5\u8be2\uff0c\u672c\u6279\u6b21\u52a0\u8f7d%2$s\u6761\u8bb0\u5f55\u5230\u5185\u5b58\u3002", (String)"RcpWriteOffUtils_3", (String)"fi-gl-common", (Object[])new Object[0]), unit.getClass().getName(), ids.size());
        QFilter permQFilter = null;
        if (!context.IsSimulate().booleanValue()) {
            permQFilter = RcpWriteOffUtils.getPermQFilter(context);
        }
        int count = 0;
        for (List<Long> splitIds : ids) {
            String log = String.format(logMsg, unit.getClass().getName(), splitIds.size());
            RcpWriteOffUtils.logInfo(unit, log);
            QFilter idFilter = new QFilter("id", "in", splitIds);
            QFilter[] filters = new QFilter[]{idFilter, permQFilter};
            DataSet dsSet = QueryServiceHelper.queryDataSet((String)"LoadRcpRecordUtils.splitWriteOffRecords", (String)"gl_acccurrent", (String)SELECTFIELDS, (QFilter[])filters, (String)orderString);
            Throwable throwable = null;
            try {
                for (Row row : dsSet) {
                    ++count;
                    ReciprocalRecord record = RcpWriteOffUtils.addRecord(context, row);
                    if ((iSrcCount += RcpWriteOffUtils.addCount(record, "0")) < 15000 || (iTgtCount += RcpWriteOffUtils.addCount(record, "1")) < 15000) continue;
                    RcpWriteOffUtils.doWriteOff(unit);
                    if (iSrcCount > iTgtCount) {
                        iSrcCount -= iTgtCount;
                        iTgtCount = 0;
                        continue;
                    }
                    iTgtCount -= iSrcCount;
                    iSrcCount = 0;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dsSet == null) continue;
                if (throwable != null) {
                    try {
                        dsSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dsSet.close();
            }
        }
        if (DebugTrace.enable()) {
            List<ReciprocalRecord> records = context.getRecords("-1");
            logger.info("=====reciprocalAging_taskId:{}_RcpWriteOffUtils_reLoadRecords_\u5f53\u524d\u65b9\u6848:{}_\u7ec4\u7ec7:{}_\u6267\u884c\u5355\u5143:{}_count:{}_allRecordsSize:{}_allRecords:{}=====", new Object[]{unit.context.getCurTask().getTaskId(), scheme.getNumber(), scheme.getOrg(), unit.getClass().getName(), count, records == null ? 0 : records.size(), records == null ? Integer.valueOf(0) : JSON.toJSON(records)});
        }
    }

    private static void logInfo(AbstractRcpWriteOffLoginUnit unit, String msg) {
        unit.context.logInfo(msg);
    }

    private static int addCount(ReciprocalRecord record, String type) {
        if (type.equals(record.entryType())) {
            return 1;
        }
        return 0;
    }

    private static List<List<Long>> splitQueryRecordIds(Set<Long> curRecordIds) {
        ArrayList<List<Long>> ids = new ArrayList<List<Long>>();
        ArrayList<Long> tmpIds = new ArrayList<Long>(30000);
        for (Long id : curRecordIds) {
            tmpIds.add(id);
            if (tmpIds.size() < 30000) continue;
            ids.add(tmpIds);
            tmpIds = new ArrayList(30000);
        }
        if (!tmpIds.isEmpty()) {
            ids.add(tmpIds);
        }
        return ids;
    }

    private static void writeOffAllRecords(AbstractRcpWriteOffLoginUnit unit) {
        if (unit.reLoadRecords().booleanValue()) {
            ReciprocalContext context = unit.context;
            ReciprocalScheme scheme = context.getScheme();
            String sourceType = unit.getQuerySourceType();
            Set<Long> curRecordIds = context.getCurTask().getEntryIds(sourceType);
            if (DebugTrace.enable()) {
                logger.info("=====reciprocalAging_taskId:{}_RcpWriteOffUtils_writeOffAllRecords_\u5f53\u524d\u65b9\u6848:{}_\u7ec4\u7ec7:{}_\u6267\u884c\u5355\u5143:{}_sourceType:{}_curRecordIdsSize:{}_curRecordIds:{}=====", new Object[]{context.getCurTask().getTaskId(), scheme.getNumber(), scheme.getOrg(), unit.getClass().getName(), sourceType, curRecordIds == null ? 0 : curRecordIds.size(), curRecordIds == null ? Integer.valueOf(0) : JSON.toJSON(curRecordIds)});
            }
            int count = 0;
            if (curRecordIds != null) {
                Set<Long> loadedRecordIds = context.getLoadedRecordIds();
                curRecordIds.removeAll(loadedRecordIds);
                ArrayList<QFilter> lstFilters = new ArrayList<QFilter>();
                lstFilters.add(new QFilter("id", "in", curRecordIds));
                String orderString = RcpWriteOffUtils.getOrderString(scheme);
                QFilter permQFilter = null;
                if (!context.IsSimulate().booleanValue()) {
                    permQFilter = RcpWriteOffUtils.getPermQFilter(context);
                    lstFilters.add(permQFilter);
                }
                if (DebugTrace.enable()) {
                    logger.info("=====reciprocalAging_taskId:{}_RcpWriteOffUtils_writeOffAllRecords_\u5f53\u524d\u65b9\u6848:{}_\u7ec4\u7ec7:{}_\u6267\u884c\u5355\u5143:{}_filters:{}=====", new Object[]{unit.context.getCurTask().getTaskId(), scheme.getNumber(), scheme.getOrg(), unit.getClass().getName(), JSON.toJSON(lstFilters)});
                }
                try (DataSet result = QueryServiceHelper.queryDataSet((String)"LoadRcpRecordUtils.writeOffAllRecords", (String)"gl_acccurrent", (String)SELECTFIELDS, (QFilter[])lstFilters.toArray(new QFilter[0]), (String)orderString);){
                    for (Row row : result) {
                        ++count;
                        RcpWriteOffUtils.addRecord(context, row);
                    }
                }
            }
            if (DebugTrace.enable()) {
                List<ReciprocalRecord> records = context.getRecords("-1");
                logger.info("=====reciprocalAging_taskId:{}_RcpWriteOffUtils_writeOffAllRecords_\u5f53\u524d\u65b9\u6848:{}_\u7ec4\u7ec7:{}_\u6267\u884c\u5355\u5143:{}_count:{}_allRecordsSize:{}_allRecords:{}=====", new Object[]{unit.context.getCurTask().getTaskId(), scheme.getNumber(), scheme.getOrg(), unit.getClass().getName(), count, records == null ? 0 : records.size(), records == null ? Integer.valueOf(0) : JSON.toJSON(records)});
            }
        }
        RcpWriteOffUtils.doWriteOff(unit);
    }

    public static ReciprocalRecord addRecord(ReciprocalContext context, Row row) {
        SimulateRecord sr;
        ReciprocalRecord record = RcpWriteOffUtils.getRecord(context, row);
        Map<Long, SimulateRecord> recordAndWOAmountMap = context.getScheme().getSimulateMap();
        if (context.IsSimulate().booleanValue() && (sr = recordAndWOAmountMap.get(record.getMasterId())) != null) {
            record.addBalFor(sr.getAmountFor());
            record.addBalLocal(sr.getAmount());
            record.setLeavingAmount(record.getAmountBal());
            record.setLeavingAmountFor(record.getAmountBalFor());
            if (record.getAmountBalFor().compareTo(record.getAmountFor()) == 0) {
                record.setStatus("0");
            } else {
                record.setStatus("1");
            }
        }
        if (!"2".equals(record.getStatus()) || context.IsSimulate().booleanValue() && record.getAmountBal().compareTo(BigDecimal.ZERO) != 0) {
            if (context.IsSimulate().booleanValue() && !context.getScheme().isShowByamount()) {
                if (RcpWriteOffUtils.isBuyerVch(record).booleanValue()) {
                    context.addRecords(row.getString("sourcetype"), record);
                }
            } else {
                context.addRecords(row.getString("sourcetype"), record);
            }
        }
        return record;
    }

    private static void doWriteOff(AbstractRcpWriteOffLoginUnit unit) {
        ReciprocalScheme scheme = unit.context.getScheme();
        if (unit.context.IsSimulate().booleanValue() && !scheme.isShowByamount()) {
            return;
        }
        unit.invokeWriteOff();
    }

    private static String getOrderString(ReciprocalScheme scheme) {
        String orderString = "account,assgrp";
        orderString = "0".equals(scheme.getVerifiOrder()) ? orderString + ",bizdate,biznum" : orderString + ",biznum,bizdate";
        orderString = orderString + ",createtime,id";
        return orderString;
    }

    private static ReciprocalRecord getRecord(ReciprocalContext context, Row row) {
        ReciprocalRecord record = new ReciprocalRecord();
        record.setId(row.getLong("id"));
        record.setMasterId(row.getLong("masterid"));
        record.setOrg(row.getLong("org"));
        record.setBookType(row.getLong("booktype"));
        record.setAccountTable(row.getLong("accounttable"));
        record.setAccount(row.getLong("account"));
        record.setAssgrp(row.getLong("assgrp"));
        String assgrpVal = row.getString("assval");
        if (StringUtils.isNotEmpty((String)assgrpVal)) {
            record.setAssgrpVals((Map<String, Object>)JSONObject.parseObject((String)assgrpVal));
        }
        record.setCurrency(row.getLong("currency"));
        record.setAmountFor(row.getBigDecimal("amountfor"));
        record.setAmountBalFor(row.getBigDecimal("amountbalfor"));
        record.setLocalCurrency(row.getLong("localcurrency"));
        record.setAmount(row.getBigDecimal("amount"));
        record.setAmountBal(row.getBigDecimal("amountbal"));
        record.setPeriod(row.getLong("period"));
        record.setBizNum(row.getString("biznum"));
        record.setBizDate(row.getDate("bizDate"));
        record.setVoucherId(row.getLong("voucherid"));
        record.setVchEntryId(row.getLong("vchentryid"));
        record.setSourceType(row.getString("sourcetype"));
        record.setModifyTime(row.getDate("modifytime"));
        record.setStatus(row.getString("status"));
        record.setExpireDate(row.getDate("expiredate"));
        record.setWriteOffPerson(row.getLong("writeoffperson"));
        if (context.IsSimulate().booleanValue()) {
            record.setDescription(row.getString("description"));
        }
        record.setCreatorId(row.getLong("creator"));
        record.setEntryDc(row.getString("entrydc"));
        record.setLeavingAmount(record.getAmountBal());
        record.setLeavingAmountFor(record.getAmountBalFor());
        return record;
    }

    private static QFilter getPermQFilter(ReciprocalContext context) {
        try {
            ITimeService timeService = (ITimeService)Class.forName(context.getScheme().getTimeService()).newInstance();
            IUserService userService = (IUserService)Class.forName(context.getScheme().getUserService()).newInstance();
            String ruleId = ReciprocalUtils.checkSpecialPerm(true);
            if (StringUtils.isNotEmpty((String)ruleId)) {
                return ReciprocalUtils.getSpecialPermFilter(ruleId, timeService, userService);
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
        return null;
    }

    public static void generateWriteOffLog(ReciprocalRecord srcRecord, ReciprocalRecord targetRecord, ReciprocalContext ctx, Boolean isSeparateDeduct) {
        BigDecimal writeOffAmtFor;
        BigDecimal writeOffAmtLocal;
        if (DebugTrace.enable()) {
            logger.info("==FifoAutoWriteOffService firstRecord:{}", (Object)srcRecord);
            logger.info("==FifoAutoWriteOffService curRecord:{} \r\n", (Object)targetRecord);
        }
        if (RcpWriteOffUtils.isZero(srcRecord.getAmountBalFor().multiply(targetRecord.getAmountBalFor())) && RcpWriteOffUtils.isZero(srcRecord.getAmountBal().multiply(targetRecord.getAmountBal()))) {
            return;
        }
        ReciprocalRecord buyerRecord = null;
        ReciprocalRecord writeOffRecord = null;
        if (srcRecord.getBuyerFor().booleanValue() || RcpWriteOffUtils.isSameDc(srcRecord.getAmountBalFor(), targetRecord.getAmountBalFor()).booleanValue() && srcRecord.getBuyerLocal().booleanValue()) {
            buyerRecord = srcRecord;
            writeOffRecord = targetRecord;
        } else {
            buyerRecord = targetRecord;
            writeOffRecord = srcRecord;
        }
        BigDecimal srcAmt = srcRecord.getAmountBal().abs();
        BigDecimal srcAmtFor = srcRecord.getAmountBalFor().abs();
        BigDecimal tgtAmt = targetRecord.getAmountBal().abs();
        BigDecimal tgtAmtFor = targetRecord.getAmountBalFor().abs();
        BigDecimal bigDecimal = RcpWriteOffUtils.isSameDc(srcRecord.getAmountBal(), targetRecord.getAmountBal()) != false ? BigDecimal.ZERO : (writeOffAmtLocal = srcAmt.compareTo(tgtAmt) <= 0 ? srcAmt : tgtAmt);
        BigDecimal bigDecimal2 = RcpWriteOffUtils.isSameDc(srcRecord.getAmountBalFor(), targetRecord.getAmountBalFor()) != false ? BigDecimal.ZERO : (writeOffAmtFor = srcAmtFor.compareTo(tgtAmtFor) <= 0 ? srcAmtFor : tgtAmtFor);
        if (RcpWriteOffUtils.isZero(writeOffAmtLocal) && RcpWriteOffUtils.isZero(writeOffAmtFor)) {
            return;
        }
        if (isSeparateDeduct.booleanValue() && buyerRecord.getAmount().multiply(buyerRecord.getAmountFor()).compareTo(BigDecimal.ZERO) < 0) {
            if (writeOffAmtFor.compareTo(BigDecimal.ZERO) > 0) {
                buyerRecord.substractBalFor(writeOffAmtFor);
                buyerRecord.setLeavingAmountFor(buyerRecord.getAmountBalFor());
                writeOffRecord.substractBalFor(writeOffAmtFor);
                writeOffRecord.setLeavingAmountFor(writeOffRecord.getAmountBalFor());
            }
            if (writeOffAmtLocal.compareTo(BigDecimal.ZERO) > 0) {
                buyerRecord.substractBalLocal(writeOffAmtLocal);
                buyerRecord.setLeavingAmount(buyerRecord.getAmountBal());
                writeOffRecord.substractBalLocal(writeOffAmtLocal);
                writeOffRecord.setLeavingAmount(writeOffRecord.getAmountBal());
            }
        } else {
            buyerRecord.substractBalFor(writeOffAmtFor);
            buyerRecord.setLeavingAmountFor(buyerRecord.getAmountBalFor());
            writeOffRecord.substractBalFor(writeOffAmtFor);
            writeOffRecord.setLeavingAmountFor(writeOffRecord.getAmountBalFor());
            buyerRecord.substractBalLocal(writeOffAmtLocal);
            buyerRecord.setLeavingAmount(buyerRecord.getAmountBal());
            writeOffRecord.substractBalLocal(writeOffAmtLocal);
            writeOffRecord.setLeavingAmount(writeOffRecord.getAmountBal());
        }
        if (writeOffRecord.getAmountBalFor().compareTo(BigDecimal.ZERO) == 0 && writeOffRecord.getAmountBal().compareTo(BigDecimal.ZERO) == 0) {
            writeOffRecord.setStatus("2");
            ctx.addBalZeroRecord(writeOffRecord);
        } else {
            writeOffRecord.setStatus("1");
        }
        if (buyerRecord.getAmountBalFor().compareTo(BigDecimal.ZERO) == 0 && buyerRecord.getAmountBal().compareTo(BigDecimal.ZERO) == 0) {
            buyerRecord.setStatus("2");
            ctx.addBalZeroRecord(buyerRecord);
        } else {
            buyerRecord.setStatus("1");
        }
        if (!ctx.IsSimulate().booleanValue()) {
            ctx.addSuccessRecord(writeOffRecord);
            ctx.addSuccessRecord(buyerRecord);
            ctx.getSuccessWriteOffSize().addAndGet(1);
            RcpWriteOffUtils.addReciprocalLog(buyerRecord, writeOffRecord, writeOffAmtLocal, writeOffAmtFor, ctx);
        }
    }

    public static void addReciprocalLog(ReciprocalRecord buyerRecord, ReciprocalRecord writeOffRecord, BigDecimal writeOffAmount, BigDecimal writeOffAmountFor, ReciprocalContext ctx) {
        ReciprocalLog rcpLog = new ReciprocalLog();
        rcpLog.setOrg(buyerRecord.getOrg());
        rcpLog.setBookType(buyerRecord.getBookType());
        rcpLog.setPeriod(buyerRecord.getPeriod());
        rcpLog.setWriteOffDate(ctx.getWriteOffDate());
        rcpLog.setAcctTable(buyerRecord.getAccountTable());
        rcpLog.setAccount(buyerRecord.getAccount());
        rcpLog.setAssgrp(buyerRecord.getAssgrp());
        rcpLog.setCurrency(buyerRecord.getCurrency());
        rcpLog.setLocalCurrency(buyerRecord.getLocalCurrency());
        rcpLog.setAmount(writeOffAmount);
        rcpLog.setAmountFor(writeOffAmountFor);
        rcpLog.setBuyerEntryId(buyerRecord.getId());
        rcpLog.setWriteOffEntryId(writeOffRecord.getId());
        rcpLog.setWriter(ctx.getWriter());
        ctx.addReciprocalLog(rcpLog);
    }

    public static void saveReciprocalLog(ReciprocalContext ctx) {
        List<ReciprocalLog> lstLogs = ctx.getReciprocalLogs();
        boolean manualWriteoff = ctx.getScheme().isManualWriteoff();
        ArrayList<DynamicObject> lstSaveDatas = new ArrayList<DynamicObject>(lstLogs.size());
        MainEntityType logType = EntityMetadataCache.getDataEntityType((String)"gl_reciprocal_log");
        for (ReciprocalLog log : lstLogs) {
            DynamicObject saveObj = (DynamicObject)logType.createInstance();
            saveObj.set("org", (Object)log.getOrg());
            saveObj.set("booktype", (Object)log.getBookType());
            saveObj.set("period", (Object)log.getPeriod());
            saveObj.set("writeoffdate", (Object)log.getWriteOffDate());
            saveObj.set("accounttable", (Object)log.getAcctTable());
            saveObj.set("account", (Object)log.getAccount());
            saveObj.set("assgrp", (Object)log.getAssgrp());
            saveObj.set("currency", (Object)log.getCurrency());
            saveObj.set("amountfor", (Object)log.getAmountFor());
            saveObj.set("localcurrency", (Object)log.getLocalCurrency());
            saveObj.set("amount", (Object)log.getAmount());
            saveObj.set("buyerentry", (Object)log.getBuyerEntryId());
            saveObj.set("writeoffentry", (Object)log.getWriteOffEntryId());
            saveObj.set("writer", (Object)log.getWriter());
            saveObj.set("writeofftype", (Object)(manualWriteoff ? "0" : "1"));
            lstSaveDatas.add(saveObj);
        }
        SaveServiceHelper.save((IDataEntityType)logType, (Object[])lstSaveDatas.toArray(new DynamicObject[0]));
        lstLogs.clear();
    }

    public static boolean isZero(BigDecimal amt) {
        return amt.compareTo(BigDecimal.ZERO) == 0;
    }

    public static boolean isZeroByMultiply(BigDecimal a, BigDecimal b) {
        return a.multiply(b).compareTo(BigDecimal.ZERO) == 0;
    }

    public static Boolean isBuyerVch(ReciprocalRecord record) {
        if (record.getAmountFor().compareTo(BigDecimal.ZERO) > 0) {
            return Boolean.TRUE;
        }
        if (record.getAmountFor().compareTo(BigDecimal.ZERO) == 0 && record.getAmount().compareTo(BigDecimal.ZERO) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isSameDc(BigDecimal a, BigDecimal b) {
        if (a.compareTo(BigDecimal.ZERO) == 0 && b.compareTo(BigDecimal.ZERO) > 0) {
            return Boolean.TRUE;
        }
        if (a.compareTo(BigDecimal.ZERO) == 0 && b.compareTo(BigDecimal.ZERO) < 0) {
            return Boolean.FALSE;
        }
        if (b.compareTo(BigDecimal.ZERO) == 0 && a.compareTo(BigDecimal.ZERO) > 0) {
            return Boolean.TRUE;
        }
        if (b.compareTo(BigDecimal.ZERO) == 0 && a.compareTo(BigDecimal.ZERO) < 0) {
            return Boolean.FALSE;
        }
        return a.multiply(b).compareTo(BigDecimal.ZERO) > 0;
    }

    public static Field buildField(WriteOffField writeOffField) {
        return new Field(writeOffField.getFiled(), writeOffField.getType());
    }

    public static Field buildField(String name, DataType dataType) {
        return new Field(name, dataType);
    }

    public static DataSetBuilder buildWriteOffDs(List<String> buildFields, List<DataType> buildDt) {
        RowMeta meta = new RowMeta(buildFields.toArray(new String[0]), buildDt.toArray(new DataType[0]));
        return Algo.create((String)RcpWriteOffUtils.class.getName()).createDataSetBuilder(meta);
    }

    public static DataSetBuilder dataSetBuilder(RowMeta rowMeta) {
        return Algo.create((String)RcpWriteOffUtils.class.getName()).createDataSetBuilder(rowMeta);
    }

    public static List<WriteOffField> writeoffAllField() {
        ArrayList<WriteOffField> writeOffFields = new ArrayList<WriteOffField>(15);
        writeOffFields.add(WriteOffField.ID);
        writeOffFields.add(WriteOffField.ORG);
        writeOffFields.add(WriteOffField.BOOKTYPE);
        writeOffFields.add(WriteOffField.ACCOUNT);
        writeOffFields.add(WriteOffField.ASSGRP);
        writeOffFields.add(WriteOffField.ASSGRPVALUE);
        writeOffFields.add(WriteOffField.CURRENCYID);
        writeOffFields.add(WriteOffField.CURRENCYFOR);
        writeOffFields.add(WriteOffField.CURRENCYLOCAL);
        writeOffFields.add(WriteOffField.AMOUNTBAL);
        writeOffFields.add(WriteOffField.AMOUNTBALFOR);
        writeOffFields.add(WriteOffField.BIZDATE);
        writeOffFields.add(WriteOffField.EXPIREDATE);
        writeOffFields.add(WriteOffField.VOUCHERID);
        writeOffFields.add(WriteOffField.DESCRIPTION);
        writeOffFields.add(WriteOffField.BIZNUM);
        return writeOffFields;
    }

    public static DataSet buildEmptyDs() {
        List<WriteOffField> fields = RcpWriteOffUtils.writeoffAllField();
        ArrayList<String> buildFields = new ArrayList<String>(16);
        ArrayList<DataType> buildDt = new ArrayList<DataType>(16);
        for (WriteOffField field : fields) {
            buildFields.add(field.getFiled());
            buildDt.add(field.getType());
        }
        return RcpWriteOffUtils.buildWriteOffDs(buildFields, buildDt).build();
    }
}

