/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import java.util.Comparator;
import kd.fi.gl.reciprocal.ReciprocalRecord;

public class ReciprocalComparator
implements Comparator<ReciprocalRecord> {
    private String compareType;
    private int orderType;

    public ReciprocalComparator(String strCompareType, int iOrderType) {
        this.compareType = strCompareType;
        this.orderType = iOrderType;
    }

    @Override
    public int compare(ReciprocalRecord o1, ReciprocalRecord o2) {
        if (o1.getBaseKey().compareTo(o2.getBaseKey()) > 0) {
            return 1;
        }
        if (o1.getBaseKey().compareTo(o2.getBaseKey()) < 0) {
            return -1;
        }
        int comparator = 0;
        switch (this.compareType) {
            case "amount": {
                comparator = this.getAmtCompareResult(o1, o2);
                break;
            }
            case "date": {
                comparator = this.getDateCompareResult(o1, o2);
                break;
            }
            case "biznum": {
                comparator = this.getBizNumCompareResult(o1, o2);
                break;
            }
        }
        return comparator;
    }

    public int getAmtCompareResult(ReciprocalRecord o1, ReciprocalRecord o2) {
        if (this.orderType == 1) {
            return o1.getAmountBal().compareTo(o2.getAmountBal());
        }
        return o2.getAmountBal().compareTo(o1.getAmountBal());
    }

    public int getDateCompareResult(ReciprocalRecord o1, ReciprocalRecord o2) {
        if (this.orderType == 1) {
            return o1.getBizDate().compareTo(o2.getBizDate());
        }
        return o2.getBizDate().compareTo(o1.getBizDate());
    }

    public int getBizNumCompareResult(ReciprocalRecord o1, ReciprocalRecord o2) {
        if (o1.getBizNum().compareTo(o2.getBizNum()) == 0) {
            return this.getAmtCompareResult(o1, o2);
        }
        return o1.getBizNum().compareTo(o2.getBizNum());
    }
}

